/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.BinaryExpression;
import com.google.j2cl.transpiler.ast.BinaryOperator;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;

public enum WasmBinaryOperation {
    DIV("_s"),
    SUB,
    ADD,
    MUL,
    REM_S,
    SHL,
    SHR_U,
    SHR_S,
    LT("_s"),
    GT("_s"),
    LE("_s"),
    GE("_s"),
    EQ,
    NE,
    XOR,
    AND,
    OR;

    private final String integerSuffix;
    private static final ImmutableMap<BinaryOperator, WasmBinaryOperation> WASM_OPERATION_BY_BINARY_OPERATOR;

    private WasmBinaryOperation() {
        this.integerSuffix = "";
    }

    private WasmBinaryOperation(String integerSuffix) {
        this.integerSuffix = integerSuffix;
    }

    public String getInstruction(BinaryExpression expression) {
        TypeDescriptor operandType = this.getOperandType(expression);
        if (AstUtils.isPrimitiveNonNativeJsEnum((TypeDescriptor)operandType)) {
            operandType = AstUtils.getJsEnumValueFieldType((TypeDescriptor)operandType);
        }
        String prefix = operandType.isPrimitive() ? WasmGenerationEnvironment.getWasmTypeForPrimitive(operandType) : "ref";
        String suffix = TypeDescriptors.isPrimitiveFloatOrDouble((TypeDescriptor)operandType) ? "" : this.integerSuffix;
        return prefix + "." + Ascii.toLowerCase((String)this.name()) + suffix;
    }

    public TypeDescriptor getOperandType(BinaryExpression expression) {
        if (expression.isReferenceComparison()) {
            return TypeDescriptors.get().javaLangObject;
        }
        Preconditions.checkState((boolean)expression.getTypeDescriptor().isPrimitive());
        return expression.getLeftOperand().getTypeDescriptor();
    }

    public static WasmBinaryOperation getOperation(BinaryExpression expression) {
        BinaryOperator operator = expression.getOperator();
        Preconditions.checkState((boolean)WASM_OPERATION_BY_BINARY_OPERATOR.containsKey((Object)operator));
        Preconditions.checkState((boolean)expression.getTypeDescriptor().isPrimitive());
        return (WasmBinaryOperation)((Object)WASM_OPERATION_BY_BINARY_OPERATOR.get((Object)operator));
    }

    static {
        WASM_OPERATION_BY_BINARY_OPERATOR = ImmutableMap.builder().put((Object)BinaryOperator.DIVIDE, (Object)DIV).put((Object)BinaryOperator.MINUS, (Object)SUB).put((Object)BinaryOperator.PLUS, (Object)ADD).put((Object)BinaryOperator.TIMES, (Object)MUL).put((Object)BinaryOperator.REMAINDER, (Object)REM_S).put((Object)BinaryOperator.LEFT_SHIFT, (Object)SHL).put((Object)BinaryOperator.RIGHT_SHIFT_SIGNED, (Object)SHR_S).put((Object)BinaryOperator.RIGHT_SHIFT_UNSIGNED, (Object)SHR_U).put((Object)BinaryOperator.LESS, (Object)LT).put((Object)BinaryOperator.GREATER, (Object)GT).put((Object)BinaryOperator.LESS_EQUALS, (Object)LE).put((Object)BinaryOperator.GREATER_EQUALS, (Object)GE).put((Object)BinaryOperator.EQUALS, (Object)EQ).put((Object)BinaryOperator.NOT_EQUALS, (Object)NE).put((Object)BinaryOperator.BIT_XOR, (Object)XOR).put((Object)BinaryOperator.BIT_AND, (Object)AND).put((Object)BinaryOperator.BIT_OR, (Object)OR).build();
    }
}

