/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2cl.transpiler.ast.ArrayLiteral;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Field;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.HasName;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.NameDeclaration;
import com.google.j2cl.transpiler.ast.PrimitiveTypeDescriptor;
import com.google.j2cl.transpiler.ast.PrimitiveTypes;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.backend.common.UniqueNamesResolver;
import com.google.j2cl.transpiler.backend.wasm.ItableAllocator;
import com.google.j2cl.transpiler.backend.wasm.JsImportsGenerator;
import com.google.j2cl.transpiler.backend.wasm.JsMethodImport;
import com.google.j2cl.transpiler.backend.wasm.WasmTypeLayout;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class WasmGenerationEnvironment {
    private static final ImmutableMap<PrimitiveTypeDescriptor, String> WASM_TYPES_BY_PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)PrimitiveTypes.BOOLEAN, (Object)"i32").put((Object)PrimitiveTypes.BYTE, (Object)"i32").put((Object)PrimitiveTypes.CHAR, (Object)"i32").put((Object)PrimitiveTypes.SHORT, (Object)"i32").put((Object)PrimitiveTypes.INT, (Object)"i32").put((Object)PrimitiveTypes.LONG, (Object)"i64").put((Object)PrimitiveTypes.FLOAT, (Object)"f32").put((Object)PrimitiveTypes.DOUBLE, (Object)"f64").build();
    private static final ImmutableMap<PrimitiveTypeDescriptor, String> WASM_PACKED_TYPES_BY_PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)PrimitiveTypes.BOOLEAN, (Object)"i8").put((Object)PrimitiveTypes.BYTE, (Object)"i8").put((Object)PrimitiveTypes.CHAR, (Object)"i16").put((Object)PrimitiveTypes.SHORT, (Object)"i16").put((Object)PrimitiveTypes.INT, (Object)"i32").put((Object)PrimitiveTypes.LONG, (Object)"i64").put((Object)PrimitiveTypes.FLOAT, (Object)"f32").put((Object)PrimitiveTypes.DOUBLE, (Object)"f64").build();
    private final Map<TypeDeclaration, WasmTypeLayout> wasmTypeLayoutByTypeDeclaration;
    private final Map<HasName, String> nameByDeclaration = new HashMap<HasName, String>();
    private final Map<ArrayLiteral, String> dataNameByLiteral = new HashMap<ArrayLiteral, String>();
    private final Multiset<String> lastIndexByName = HashMultiset.create();
    private final boolean isModular;
    private final Library library;
    private final JsImportsGenerator.Imports jsImports;
    private final ItableAllocator<TypeDeclaration> itableAllocator;

    static String getWasmTypeForPrimitive(TypeDescriptor typeDescriptor) {
        Preconditions.checkArgument((typeDescriptor.isPrimitive() && !TypeDescriptors.isPrimitiveVoid((TypeDescriptor)typeDescriptor) ? 1 : 0) != 0);
        return (String)WASM_TYPES_BY_PRIMITIVE_TYPES.get((Object)typeDescriptor);
    }

    static String getWasmPackedTypeForPrimitive(TypeDescriptor typeDescriptor) {
        Preconditions.checkArgument((typeDescriptor.isPrimitive() && !TypeDescriptors.isPrimitiveVoid((TypeDescriptor)typeDescriptor) ? 1 : 0) != 0);
        return (String)WASM_PACKED_TYPES_BY_PRIMITIVE_TYPES.get((Object)typeDescriptor);
    }

    static String getGetterInstruction(TypeDescriptor typeDescriptor) {
        if (TypeDescriptors.isPrimitiveChar((TypeDescriptor)typeDescriptor)) {
            return "get_u";
        }
        if (typeDescriptor.isPrimitive() && !WasmGenerationEnvironment.getWasmTypeForPrimitive(typeDescriptor).equals(WasmGenerationEnvironment.getWasmPackedTypeForPrimitive(typeDescriptor))) {
            return "get_s";
        }
        return "get";
    }

    WasmTypeLayout getWasmTypeLayout(TypeDeclaration typeDeclaration) {
        return (WasmTypeLayout)Preconditions.checkNotNull((Object)this.wasmTypeLayoutByTypeDeclaration.get(typeDeclaration));
    }

    String getWasmType(TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isJsEnum()) {
            return this.getWasmEnumType(typeDescriptor);
        }
        if (typeDescriptor.isPrimitive()) {
            return WasmGenerationEnvironment.getWasmTypeForPrimitive(typeDescriptor);
        }
        return "(ref null " + this.getWasmTypeName(typeDescriptor) + ")";
    }

    String getWasmEnumType(TypeDescriptor typeDescriptor) {
        TypeDeclaration typeDeclaration = ((DeclaredTypeDescriptor)typeDescriptor).getTypeDeclaration();
        TypeDescriptor valueFieldType = AstUtils.getJsEnumValueFieldType((TypeDeclaration)typeDeclaration);
        return this.getWasmType(valueFieldType);
    }

    String getWasmFieldType(TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isPrimitive()) {
            return WasmGenerationEnvironment.getWasmPackedTypeForPrimitive(typeDescriptor);
        }
        return this.getWasmType(typeDescriptor);
    }

    String getWasmTypeName(TypeDeclaration typeDeclaration) {
        return this.getWasmTypeName((TypeDescriptor)typeDeclaration.toUnparameterizedTypeDescriptor());
    }

    String getWasmTypeName(TypeDescriptor typeDescriptor) {
        if ((typeDescriptor = typeDescriptor.toRawTypeDescriptor()) instanceof DeclaredTypeDescriptor && ((DeclaredTypeDescriptor)typeDescriptor).getTypeDeclaration().getWasmInfo() != null) {
            return ((DeclaredTypeDescriptor)typeDescriptor).getTypeDeclaration().getWasmInfo();
        }
        if (typeDescriptor.isNative()) {
            return "extern";
        }
        if (typeDescriptor.isArray()) {
            ArrayTypeDescriptor arrayTypeDescriptor = (ArrayTypeDescriptor)typeDescriptor;
            if (arrayTypeDescriptor.isNativeWasmArray()) {
                String wasmTypeName = this.getWasmTypeName(arrayTypeDescriptor.getComponentTypeDescriptor());
                String prefix = wasmTypeName.startsWith("$") ? "" : "$";
                return String.format("%s%s.array", prefix, wasmTypeName);
            }
            return this.getWasmTypeName((TypeDescriptor)TypeDescriptors.getWasmArrayType((ArrayTypeDescriptor)arrayTypeDescriptor));
        }
        if (typeDescriptor.isInterface()) {
            return this.getWasmTypeName((TypeDescriptor)TypeDescriptors.get().javaLangObject);
        }
        return this.getTypeSignature(typeDescriptor);
    }

    public String getTypeSignature(TypeDeclaration typeDeclaration) {
        return this.getTypeSignature((TypeDescriptor)typeDeclaration.toUnparameterizedTypeDescriptor());
    }

    public String getTypeSignature(TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isPrimitive()) {
            return "$" + typeDescriptor.getReadableDescription();
        }
        if ((typeDescriptor = typeDescriptor.toRawTypeDescriptor()) instanceof DeclaredTypeDescriptor) {
            return "$" + ((DeclaredTypeDescriptor)typeDescriptor).getQualifiedSourceName();
        }
        throw new AssertionError((Object)("Unexpected type: " + typeDescriptor.getReadableDescription()));
    }

    public String getWasmEmptyArrayGlobalName(ArrayTypeDescriptor arrayTypeDescriptor) {
        return "$__emptyArray_" + this.getWasmTypeName((TypeDescriptor)arrayTypeDescriptor);
    }

    public String getWasmItableGlobalName(DeclaredTypeDescriptor typeDescriptor) {
        if (!typeDescriptor.getTypeDeclaration().implementsInterfaces()) {
            return "$itable.empty";
        }
        return this.getTypeSignature((TypeDescriptor)typeDescriptor) + ".itable";
    }

    public String getWasmItableGlobalName(TypeDeclaration typeDeclaration) {
        return this.getWasmItableGlobalName(typeDeclaration.toUnparameterizedTypeDescriptor());
    }

    public String getWasmVtableTypeName(DeclaredTypeDescriptor typeDescriptor) {
        return this.getTypeSignature((TypeDescriptor)typeDescriptor) + ".vtable";
    }

    public String getWasmVtableTypeName(TypeDeclaration typeDeclaration) {
        return this.getWasmVtableTypeName(typeDeclaration.toUnparameterizedTypeDescriptor());
    }

    public String getWasmItableTypeName(TypeDeclaration typeDeclaration) {
        if (typeDeclaration == null || !typeDeclaration.implementsInterfaces()) {
            return "$itable";
        }
        return this.getTypeSignature(typeDeclaration) + ".itable";
    }

    public String getWasmItableInterfaceGetter(TypeDeclaration typeDeclaration) {
        return this.getWasmItableInterfaceGetter(this.getTypeSignature(typeDeclaration));
    }

    public String getWasmItableInterfaceGetter(String fieldName) {
        return String.format("$get.itable.%s", fieldName);
    }

    public String getWasmInterfaceVtableGlobalName(TypeDeclaration ifce, TypeDeclaration inClass) {
        return String.format("%s@%s", this.getWasmVtableTypeName(ifce), this.getWasmTypeName(inClass));
    }

    public String getWasmVtableGlobalName(DeclaredTypeDescriptor typeDescriptor) {
        return this.getWasmVtableGlobalName(typeDescriptor.getTypeDeclaration());
    }

    public String getWasmVtableGlobalName(TypeDeclaration typeDeclaration) {
        return this.getWasmVtableTypeName(typeDeclaration);
    }

    public String getVtableFieldName(MethodDescriptor methodDescriptor) {
        return "$" + methodDescriptor.getMangledName();
    }

    public String getMethodImplementationName(MethodDescriptor methodDescriptor) {
        methodDescriptor = methodDescriptor.getDeclarationDescriptor();
        return "$" + methodDescriptor.getMangledName() + (methodDescriptor.getOrigin().isOnceMethod() ? "_<once>_" : "") + "@" + methodDescriptor.getEnclosingTypeDescriptor().getQualifiedSourceName();
    }

    String getFieldName(Field field) {
        return this.getFieldName(field.getDescriptor());
    }

    String getFieldName(FieldDescriptor fieldDescriptor) {
        return "$" + fieldDescriptor.getName() + "@" + fieldDescriptor.getEnclosingTypeDescriptor().getQualifiedSourceName();
    }

    boolean isWasmArrayElementsField(FieldDescriptor descriptor) {
        return TypeDescriptors.isWasmArrayOrSubtype((TypeDescriptor)descriptor.getEnclosingTypeDescriptor()) && descriptor.getName().equals("elements");
    }

    String getDeclarationName(NameDeclaration declaration) {
        return "$" + (String)Preconditions.checkNotNull((Object)this.nameByDeclaration.get(declaration));
    }

    String getFunctionTypeName(MethodDescriptor methodDescriptor) {
        return this.generateFunctionTypeName("$function", methodDescriptor);
    }

    String getNoSideEffectWrapperFunctionName(MethodDescriptor methodDescriptor) {
        return this.generateFunctionTypeName("$function.no.side.effects", methodDescriptor);
    }

    private String generateFunctionTypeName(String prefix, MethodDescriptor methodDescriptor) {
        return prefix + "." + methodDescriptor.getMangledName();
    }

    ImmutableMap<String, MethodDescriptor> collectMethodsNeedingIntrinsicDeclarations() {
        return (ImmutableMap)this.library.streamTypes().flatMap(t -> t.getMethods().stream()).map(Method::getDescriptor).filter(MethodDescriptor::isSideEffectFree).collect(ImmutableMap.toImmutableMap(this::getNoSideEffectWrapperFunctionName, Function.identity(), (a, b) -> a));
    }

    ImmutableMap<String, MethodDescriptor> collectMethodsThatNeedTypeDeclarations() {
        return (ImmutableMap)this.library.streamTypes().flatMap(t -> t.getMethods().stream()).map(Method::getDescriptor).filter(MethodDescriptor::isPolymorphic).collect(ImmutableMap.toImmutableMap(this::getFunctionTypeName, Function.identity(), (a, b) -> a));
    }

    public boolean registerDataSegmentLiteral(ArrayLiteral arrayLiteral, String typeQualifiedName) {
        if (this.dataNameByLiteral.containsKey(arrayLiteral)) {
            return false;
        }
        this.lastIndexByName.add((Object)typeQualifiedName);
        String name = "$arrayliteral@" + typeQualifiedName + "-" + this.lastIndexByName.count((Object)typeQualifiedName);
        this.dataNameByLiteral.put(arrayLiteral, name);
        return true;
    }

    public String getDataElementNameForLiteral(ArrayLiteral arrayLiteral) {
        return this.dataNameByLiteral.get(arrayLiteral);
    }

    int getItableIndexForInterface(TypeDeclaration typeDeclaration) {
        return this.itableAllocator.getItableFieldIndex(typeDeclaration);
    }

    int getItableSize() {
        if (this.isModular) {
            throw new UnsupportedOperationException();
        }
        return this.itableAllocator.getItableSize();
    }

    public JsImportsGenerator.Imports getJsImports() {
        return this.jsImports;
    }

    public JsMethodImport getJsMethodImport(MethodDescriptor methodDescriptor) {
        return (JsMethodImport)this.jsImports.getMethodImports().get((Object)methodDescriptor);
    }

    public boolean isJsImport(Method method) {
        MethodDescriptor methodDescriptor = method.getDescriptor();
        return this.jsImports.getMethodImports().get((Object)methodDescriptor) != null;
    }

    WasmGenerationEnvironment(Library library, JsImportsGenerator.Imports jsImports) {
        this(library, jsImports, false);
    }

    WasmGenerationEnvironment(Library library, JsImportsGenerator.Imports jsImports, boolean isModular) {
        this.isModular = isModular;
        this.library = library;
        library.streamTypes().forEach(t -> this.nameByDeclaration.putAll(UniqueNamesResolver.computeUniqueNames((Set)ImmutableSet.of(), (Type)t)));
        this.wasmTypeLayoutByTypeDeclaration = new LinkedHashMap<TypeDeclaration, WasmTypeLayout>();
        library.streamTypes().sorted(Comparator.comparingInt(t -> t.getDeclaration().getTypeHierarchyDepth())).forEach(t -> {
            TypeDeclaration typeDeclaration = t.getDeclaration();
            typeDeclaration.getAllSuperInterfaces().forEach(this::getOrCreateWasmTypeLayout);
            WasmTypeLayout superWasmLayout = this.getOrCreateWasmTypeLayout(typeDeclaration.getSuperTypeDeclaration());
            WasmTypeLayout previous = this.wasmTypeLayoutByTypeDeclaration.put(typeDeclaration, WasmTypeLayout.createFromType(t, superWasmLayout));
            Preconditions.checkState((previous == null ? 1 : 0) != 0);
        });
        this.itableAllocator = this.createItableAllocator(library);
        this.jsImports = jsImports;
    }

    private ItableAllocator<TypeDeclaration> createItableAllocator(Library library) {
        if (this.isModular) {
            return null;
        }
        return new ItableAllocator<TypeDeclaration>((List)library.streamTypes().filter(Predicates.not(Type::isInterface)).map(Type::getDeclaration).collect(ImmutableList.toImmutableList()), TypeDeclaration::getAllSuperInterfaces);
    }

    @Nullable
    @CanIgnoreReturnValue
    private WasmTypeLayout getOrCreateWasmTypeLayout(TypeDeclaration typeDeclaration) {
        if (typeDeclaration == null) {
            return null;
        }
        if (!this.wasmTypeLayoutByTypeDeclaration.containsKey(typeDeclaration)) {
            WasmTypeLayout superTypeLayout = this.getOrCreateWasmTypeLayout(typeDeclaration.getSuperTypeDeclaration());
            WasmTypeLayout typeLayout = WasmTypeLayout.createFromTypeDeclaration(typeDeclaration, superTypeLayout);
            this.wasmTypeLayoutByTypeDeclaration.put(typeDeclaration, typeLayout);
            return typeLayout;
        }
        return this.wasmTypeLayoutByTypeDeclaration.get(typeDeclaration);
    }
}

