/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.OutputUtils;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.Field;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.Member;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import com.google.j2cl.transpiler.backend.wasm.JsImportsGenerator;
import com.google.j2cl.transpiler.backend.wasm.SummaryBuilder;
import com.google.j2cl.transpiler.backend.wasm.WasmConstructsGenerator;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;

public class WasmGeneratorStage {
    private final Problems problems;
    private final OutputUtils.Output output;
    private final Path libraryInfoOutputPath;
    private WasmGenerationEnvironment environment;

    public WasmGeneratorStage(Library library, Problems problems) {
        this(null, null, problems);
        this.environment = new WasmGenerationEnvironment(library, JsImportsGenerator.collectImports(library, problems), true);
    }

    private WasmGeneratorStage(OutputUtils.Output output, Path libraryInfoOutputPath, Problems problems) {
        this.output = output;
        this.libraryInfoOutputPath = libraryInfoOutputPath;
        this.problems = problems;
    }

    public WasmGenerationEnvironment getEnvironment() {
        return this.environment;
    }

    public static void generateModularOutput(Library library, OutputUtils.Output output, Path libraryInfoOutputPath, Problems problems) {
        new WasmGeneratorStage(output, libraryInfoOutputPath, problems).generateModularOutput(library);
    }

    private void generateModularOutput(Library library) {
        if (this.libraryInfoOutputPath != null) {
            OutputUtils.writeToFile((Path)this.libraryInfoOutputPath, (byte[])new byte[0], (Problems)this.problems);
        }
        JsImportsGenerator.Imports jsImports = JsImportsGenerator.collectImports(library, this.problems);
        this.environment = new WasmGenerationEnvironment(library, jsImports, true);
        SummaryBuilder summaryBuilder = new SummaryBuilder(library, this.environment, this.problems);
        JsImportsGenerator.collectImportSnippets(jsImports).forEach((key, value) -> summaryBuilder.addSharedJsImportSnippet((String)key, (String)value));
        jsImports.getModuleImports().forEach(summaryBuilder::addSharedJsImportRequireSnippet);
        this.collectUsedNativeArrayTypes(library).forEach(t -> {
            summaryBuilder.addSharedTypeSnippet(this.environment.getWasmTypeName((TypeDescriptor)t), this.emitToString(g -> g.emitNativeArrayType((ArrayTypeDescriptor)t)));
            summaryBuilder.addSharedGlobalSnippet(this.environment.getWasmEmptyArrayGlobalName((ArrayTypeDescriptor)t), this.emitToString(g -> g.emitEmptyArraySingleton((ArrayTypeDescriptor)t)));
        });
        this.environment.collectMethodsThatNeedTypeDeclarations().forEach((k, m) -> summaryBuilder.addSharedTypeSnippet((String)k, this.emitToString(g -> g.emitFunctionType((String)k, (MethodDescriptor)m))));
        this.environment.collectMethodsNeedingIntrinsicDeclarations().forEach((k, m) -> summaryBuilder.addSharedWasmImportSnippet((String)k, this.emitToString(g -> g.emitBinaryenIntrinsicImport((String)k, (MethodDescriptor)m))));
        this.output.write("summary.txtpb", summaryBuilder.toJson(this.problems));
        this.output.write("summary.binpb", summaryBuilder.toByteArray());
        this.copyJavaSources(library);
        this.emitToFile("types.wat", generator -> generator.emitForEachType(library, generator::renderModularTypeStructs, "type definition"));
        this.emitToFile("imports.wat", generator -> generator.emitForEachType(library, generator::renderImportedMethods, "imports"));
        this.emitToFile("contents.wat", generator -> {
            generator.emitDataSegments(library);
            generator.emitGlobals(library);
            generator.emitClassDispatchTables(library, false);
            generator.emitForEachType(library, generator::renderTypeMethods, "methods");
        });
        this.emitNameMappingFile(library, this.output);
        this.generateJsImportsFile();
    }

    public String emitToString(Consumer<WasmConstructsGenerator> emitter) {
        SourceBuilder builder = new SourceBuilder();
        WasmConstructsGenerator generator = new WasmConstructsGenerator(this.environment, builder);
        emitter.accept(generator);
        return builder.build();
    }

    private void emitToFile(String filename, Consumer<WasmConstructsGenerator> emitter) {
        String content = this.emitToString(emitter);
        if (content.isEmpty()) {
            return;
        }
        this.output.write(filename, content);
    }

    public static void generateMonolithicOutput(Library library, OutputUtils.Output output, Path libraryInfoOutputPath, Problems problems) {
        new WasmGeneratorStage(output, libraryInfoOutputPath, problems).generateMonolithicOutput(library);
    }

    private void generateMonolithicOutput(Library library) {
        this.copyJavaSources(library);
        this.generateWasmModule(library);
        this.generateJsImportsFile();
    }

    private void copyJavaSources(Library library) {
        library.getCompilationUnits().stream().filter(Predicates.not(CompilationUnit::isSynthetic)).forEach(compilationUnit -> this.output.copyFile(compilationUnit.getFilePath(), compilationUnit.getPackageRelativePath()));
    }

    private void generateWasmModule(Library library) {
        this.environment = new WasmGenerationEnvironment(library, JsImportsGenerator.collectImports(library, this.problems));
        SourceBuilder builder = new SourceBuilder();
        WasmConstructsGenerator generator = new WasmConstructsGenerator(this.environment, builder);
        List<ArrayTypeDescriptor> usedNativeArrayTypes = this.collectUsedNativeArrayTypes(library);
        builder.appendln(";;; Code generated by J2WASM");
        builder.append("(module");
        generator.emitLibraryRecGroup(library, usedNativeArrayTypes);
        generator.emitImportsForBinaryenIntrinsics();
        generator.emitForEachType(library, generator::renderImportedMethods, "imports");
        generator.emitExceptionTag();
        generator.emitDataSegments(library);
        generator.emitDispatchTablesInitialization(library);
        generator.emitEmptyArraySingletons(usedNativeArrayTypes);
        generator.emitGlobals(library);
        generator.emitForEachType(library, generator::renderTypeMethods, "methods");
        generator.emitItableInterfaceGetters(library);
        builder.newLine();
        builder.append(")");
        this.output.write("module.wat", builder.buildToList());
        this.emitNameMappingFile(library, this.output);
    }

    public static void generateWasmExportMethods(List<Method> methods, OutputUtils.Output output, Problems problems) {
        WasmGeneratorStage wasmGeneratorStage = new WasmGeneratorStage(output, null, problems);
        wasmGeneratorStage.generateWasmExportMethods(methods);
        wasmGeneratorStage.emitNameMappingFile(methods, output);
    }

    private void generateWasmExportMethods(List<Method> methods) {
        if (methods.isEmpty()) {
            return;
        }
        CompilationUnit cu = CompilationUnit.createSynthetic((String)"wasm.exports");
        LinkedHashMap typesByDeclaration = new LinkedHashMap();
        methods.forEach(m -> {
            TypeDeclaration typeDeclaration = m.getDescriptor().getEnclosingTypeDescriptor().getTypeDeclaration();
            Type type = typesByDeclaration.computeIfAbsent(typeDeclaration, t -> new Type(SourcePosition.NONE, t));
            type.addMember((Member)m);
        });
        typesByDeclaration.values().forEach(arg_0 -> ((CompilationUnit)cu).addType(arg_0));
        Library library = Library.newBuilder().setCompilationUnits((List)ImmutableList.of((Object)cu)).build();
        this.environment = new WasmGenerationEnvironment(library, JsImportsGenerator.collectImports(library, this.problems));
        SourceBuilder builder = new SourceBuilder();
        WasmConstructsGenerator generator = new WasmConstructsGenerator(this.environment, builder);
        methods.forEach(generator::renderMethod);
        this.output.write("contents.wat", builder.buildToList());
    }

    private List<ArrayTypeDescriptor> collectUsedNativeArrayTypes(Library library) {
        final LinkedHashSet usedArrayTypes = new LinkedHashSet();
        library.accept((Processor)new AbstractVisitor(){

            public void exitField(Field field) {
                this.collectIfArrayType(field.getDescriptor().getTypeDescriptor());
            }

            public void exitVariable(Variable variable) {
                this.collectIfArrayType(variable.getTypeDescriptor());
            }

            private void collectIfArrayType(TypeDescriptor typeDescriptor) {
                if (!typeDescriptor.isArray()) {
                    return;
                }
                ArrayTypeDescriptor arrayTypeDescriptor = (ArrayTypeDescriptor)typeDescriptor;
                if (arrayTypeDescriptor.isNativeWasmArray()) {
                    usedArrayTypes.add(arrayTypeDescriptor);
                }
            }
        });
        return new ArrayList<ArrayTypeDescriptor>(usedArrayTypes);
    }

    private void generateJsImportsFile() {
        JsImportsGenerator.generateOutputs(this.output, this.environment.getJsImports());
    }

    private void emitNameMappingFile(Library library, OutputUtils.Output output) {
        final ArrayList<Method> methods = new ArrayList<Method>();
        library.accept((Processor)new AbstractVisitor(){

            public void exitMethod(Method method) {
                methods.add(method);
            }
        });
        this.emitNameMappingFile(methods, output);
    }

    private void emitNameMappingFile(List<Method> methods, OutputUtils.Output output) {
        SourceBuilder builder = new SourceBuilder();
        methods.forEach(m -> this.emitMethodMapping((Method)m, builder));
        output.write("namemap", builder.build());
    }

    private void emitMethodMapping(Method method, SourceBuilder builder) {
        MethodDescriptor methodDescriptor = method.getDescriptor();
        String methodImplementationName = this.environment.getMethodImplementationName(methodDescriptor);
        Preconditions.checkState((boolean)methodImplementationName.startsWith("$"));
        builder.append(String.format("%s:%s", methodImplementationName.substring(1), methodDescriptor.getQualifiedBinaryName()));
        builder.newLine();
    }
}

