/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class ItableAllocator<T> {
    private final SetMultimap<T, T> classesByInterface = LinkedHashMultimap.create();
    private final List<Set<T>> classesByFieldindex = new ArrayList<Set<T>>();
    private final Multiset<T> itableIndexByInterface = HashMultiset.create();

    public ItableAllocator(List<T> classes, Function<T, Set<T>> implementedInterfaceByType) {
        classes.forEach(c -> ((Set)implementedInterfaceByType.apply(c)).forEach(i -> this.classesByInterface.put(i, c)));
        this.classesByInterface.keySet().stream().sorted(Comparator.comparingInt(t -> this.classesByInterface.get(t).size()).reversed()).forEach(this::assignFirstNonConflictingFieldIndex);
    }

    public int getItableSize() {
        return this.classesByFieldindex.size();
    }

    public int getItableFieldIndex(T type) {
        return this.itableIndexByInterface.count(type) - 1;
    }

    private void assignFirstNonConflictingFieldIndex(T interfaceToAssign) {
        int fieldIndex = this.getFirstNonConflictingFieldIndex(interfaceToAssign);
        this.itableIndexByInterface.setCount(interfaceToAssign, fieldIndex + 1);
        this.addClassesToFieldIndex(fieldIndex, this.classesByInterface.get(interfaceToAssign));
    }

    private void addClassesToFieldIndex(int fieldIndex, Set<T> classes) {
        if (this.classesByFieldindex.size() == fieldIndex) {
            this.classesByFieldindex.add(new HashSet());
        }
        this.classesByFieldindex.get(fieldIndex).addAll(classes);
    }

    private int getFirstNonConflictingFieldIndex(T interfaceToAssign) {
        int itableSize = this.classesByFieldindex.size();
        for (int index = 0; index < itableSize; ++index) {
            if (!Collections.disjoint((Collection)this.classesByFieldindex.get(index), this.classesByInterface.get(interfaceToAssign))) continue;
            return index;
        }
        return itableSize;
    }
}

