/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Field;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.backend.wasm.AutoValue_WasmTypeLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@AutoValue
abstract class WasmTypeLayout {
    WasmTypeLayout() {
    }

    static WasmTypeLayout createFromType(Type javaType, WasmTypeLayout wasmSupertypeLayout) {
        return new AutoValue_WasmTypeLayout(javaType, javaType.getTypeDescriptor(), wasmSupertypeLayout);
    }

    static WasmTypeLayout createFromTypeDeclaration(TypeDeclaration typeDeclaration, WasmTypeLayout wasmSupertypeLayout) {
        return new AutoValue_WasmTypeLayout(null, typeDeclaration.toUnparameterizedTypeDescriptor(), wasmSupertypeLayout);
    }

    @Nullable
    abstract Type getJavaType();

    abstract DeclaredTypeDescriptor getTypeDescriptor();

    @Nullable
    abstract WasmTypeLayout getWasmSupertypeLayout();

    Collection<FieldDescriptor> getAllInstanceFields() {
        WasmTypeLayout wasmSupertypeLayout = this.getWasmSupertypeLayout();
        ArrayList<FieldDescriptor> instanceFields = new ArrayList<FieldDescriptor>();
        if (wasmSupertypeLayout != null) {
            instanceFields.addAll(wasmSupertypeLayout.getAllInstanceFields());
        }
        ImmutableList<FieldDescriptor> declaredInstanceFields = this.getDeclaredInstanceFields();
        if (TypeDescriptors.isWasmArraySubtype((TypeDescriptor)this.getTypeDescriptor())) {
            Preconditions.checkState((boolean)((FieldDescriptor)declaredInstanceFields.get(0)).getName().equals("elements"));
            FieldDescriptor removedField = (FieldDescriptor)instanceFields.remove(instanceFields.size() - 1);
            Preconditions.checkState((boolean)removedField.getName().equals("elements"));
        }
        instanceFields.addAll((Collection<FieldDescriptor>)declaredInstanceFields);
        return instanceFields;
    }

    private ImmutableList<FieldDescriptor> getDeclaredInstanceFields() {
        Stream<FieldDescriptor> declaredFieldDescriptors;
        Type type = this.getJavaType();
        if (type != null) {
            declaredFieldDescriptors = type.getInstanceFields().stream().map(Field::getDescriptor);
        } else {
            declaredFieldDescriptors = this.getTypeDescriptor().getDeclaredFieldDescriptors().stream().filter(FieldDescriptor::isInstanceMember);
            if (this.getTypeDescriptor().getTypeDeclaration().isCapturingEnclosingInstance()) {
                declaredFieldDescriptors = Stream.concat(declaredFieldDescriptors, Stream.of(this.getTypeDescriptor().getFieldDescriptorForEnclosingInstance()));
            }
        }
        return (ImmutableList)declaredFieldDescriptors.sorted(Comparator.comparing(FieldDescriptor::getMangledName)).collect(ImmutableList.toImmutableList());
    }

    Collection<MethodDescriptor> getAllPolymorphicMethods() {
        return this.getAllPolymorphicMethodsByMangledName().values();
    }

    MethodDescriptor getImplementationMethod(MethodDescriptor methodDescriptor) {
        return this.getAllPolymorphicMethodsByMangledName().get(methodDescriptor.getMangledName());
    }

    Map<String, MethodDescriptor> getAllPolymorphicMethodsByMangledName() {
        LinkedHashMap<String, MethodDescriptor> instanceMethodsByMangledName = new LinkedHashMap<String, MethodDescriptor>();
        if (this.getWasmSupertypeLayout() != null) {
            instanceMethodsByMangledName.putAll(this.getWasmSupertypeLayout().getAllPolymorphicMethodsByMangledName());
        }
        DeclaredTypeDescriptor typeDescriptor = this.getTypeDescriptor();
        typeDescriptor.getPolymorphicMethods().stream().filter(this::needsVtableEntry).sorted(Comparator.comparing(MethodDescriptor::getMangledName)).forEach(md -> instanceMethodsByMangledName.put(md.getMangledName(), (MethodDescriptor)md));
        if (!typeDescriptor.isInterface()) {
            MethodDescriptor getClassMethodDescriptor = WasmTypeLayout.getGetClassMethodDescriptor(typeDescriptor);
            instanceMethodsByMangledName.put(getClassMethodDescriptor.getMangledName(), getClassMethodDescriptor);
        }
        return instanceMethodsByMangledName;
    }

    private boolean needsVtableEntry(MethodDescriptor methodDescriptor) {
        if (this.getTypeDescriptor().isInterface() && methodDescriptor.isOrOverridesJavaLangObjectMethod()) {
            return false;
        }
        return !methodDescriptor.getEnclosingTypeDescriptor().isFinal() && !methodDescriptor.isFinal() || !methodDescriptor.getJsOverriddenMethodDescriptors().isEmpty() || this.isAccidentalInterfaceOverride(methodDescriptor);
    }

    private boolean isAccidentalInterfaceOverride(MethodDescriptor methodDescriptor) {
        return this.getTypeDescriptor().getInterfaceTypeDescriptors().stream().flatMap(i -> i.getPolymorphicMethods().stream()).filter(m -> m.getEnclosingTypeDescriptor().isInterface()).anyMatch(m -> m.getMangledName().equals(methodDescriptor.getMangledName()));
    }

    private static MethodDescriptor getGetClassMethodDescriptor(DeclaredTypeDescriptor typeDescriptor) {
        return MethodDescriptor.Builder.from((MethodDescriptor)TypeDescriptors.get().javaLangObject.getMethodDescriptor("$getClassImpl", new TypeDescriptor[0])).setEnclosingTypeDescriptor(typeDescriptor).setSynthetic(true).build();
    }
}

