/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.j2cl.transpiler.ast.PrefixExpression;
import com.google.j2cl.transpiler.ast.PrefixOperator;
import com.google.j2cl.transpiler.ast.UnaryExpression;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;

public enum WasmUnaryOperation {
    EQZ,
    NEG;


    public static WasmUnaryOperation get(UnaryExpression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof PrefixExpression));
        PrefixOperator operator = ((PrefixExpression)expression).getOperator();
        switch (operator) {
            case NOT: {
                return EQZ;
            }
            case MINUS: {
                return NEG;
            }
        }
        throw new AssertionError((Object)"Invalid operator");
    }

    public String getInstruction(UnaryExpression expression) {
        return WasmGenerationEnvironment.getWasmTypeForPrimitive(expression.getOperand().getTypeDescriptor()) + "." + Ascii.toLowerCase((String)this.name());
    }
}

