/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2cl.common.StringUtils;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.ArrayAccess;
import com.google.j2cl.transpiler.ast.ArrayLength;
import com.google.j2cl.transpiler.ast.ArrayLiteral;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.BinaryExpression;
import com.google.j2cl.transpiler.ast.BooleanLiteral;
import com.google.j2cl.transpiler.ast.CastExpression;
import com.google.j2cl.transpiler.ast.ConditionalExpression;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.ExpressionWithComment;
import com.google.j2cl.transpiler.ast.FieldAccess;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.InstanceOfExpression;
import com.google.j2cl.transpiler.ast.Invocation;
import com.google.j2cl.transpiler.ast.JsDocCastExpression;
import com.google.j2cl.transpiler.ast.MethodCall;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.MultiExpression;
import com.google.j2cl.transpiler.ast.NameDeclaration;
import com.google.j2cl.transpiler.ast.NewArray;
import com.google.j2cl.transpiler.ast.NewInstance;
import com.google.j2cl.transpiler.ast.NullLiteral;
import com.google.j2cl.transpiler.ast.NumberLiteral;
import com.google.j2cl.transpiler.ast.PrimitiveTypeDescriptor;
import com.google.j2cl.transpiler.ast.StringLiteral;
import com.google.j2cl.transpiler.ast.ThisOrSuperReference;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.UnaryExpression;
import com.google.j2cl.transpiler.ast.VariableDeclarationExpression;
import com.google.j2cl.transpiler.ast.VariableDeclarationFragment;
import com.google.j2cl.transpiler.ast.VariableReference;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import com.google.j2cl.transpiler.backend.wasm.WasmBinaryOperation;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;
import com.google.j2cl.transpiler.backend.wasm.WasmUnaryOperation;
import java.util.List;

final class ExpressionTranspiler {
    public static void renderWithUnusedResult(Expression expression, SourceBuilder sourceBuilder, WasmGenerationEnvironment environment) {
        if (ExpressionTranspiler.returnsVoid(expression)) {
            ExpressionTranspiler.render(expression, sourceBuilder, environment);
        } else {
            sourceBuilder.append("(drop ");
            ExpressionTranspiler.render(expression, sourceBuilder, environment);
            sourceBuilder.append(")");
        }
    }

    public static void render(Expression expression, final SourceBuilder sourceBuilder, final WasmGenerationEnvironment environment) {
        new AbstractVisitor(){

            public boolean enterBooleanLiteral(BooleanLiteral booleanLiteral) {
                sourceBuilder.append("(i32.const " + (booleanLiteral.getValue() ? "1" : "0") + ")");
                return false;
            }

            public boolean enterBinaryExpression(BinaryExpression expression) {
                if (expression.isSimpleAssignment()) {
                    return this.renderAssignment(expression.getLeftOperand(), expression.getRightOperand());
                }
                this.renderBinaryOperation(expression);
                return false;
            }

            private void renderBinaryOperation(BinaryExpression expression) {
                WasmBinaryOperation wasmOperation = WasmBinaryOperation.getOperation(expression);
                sourceBuilder.append("(" + wasmOperation.getInstruction(expression) + " ");
                this.render(expression.getLeftOperand());
                sourceBuilder.append(" ");
                this.render(expression.getRightOperand());
                sourceBuilder.append(")");
            }

            @CanIgnoreReturnValue
            private boolean renderAssignment(Expression left, Expression right) {
                sourceBuilder.append("(");
                this.renderAccessExpression(left, true);
                sourceBuilder.append(" ");
                this.render(right);
                sourceBuilder.append(")");
                return false;
            }

            private void renderAccessExpression(Expression expression, boolean setter) {
                if (expression instanceof VariableReference) {
                    sourceBuilder.append(String.format("local.%s %s", setter ? "set" : "get", environment.getDeclarationName((NameDeclaration)((VariableReference)expression).getTarget())));
                } else if (expression instanceof FieldAccess) {
                    FieldDescriptor fieldDescriptor = ((FieldAccess)expression).getTarget();
                    Expression qualifier = ((FieldAccess)expression).getQualifier();
                    if (fieldDescriptor.isStatic()) {
                        sourceBuilder.append(String.format("global.%s %s", setter ? "set" : "get", environment.getFieldName(fieldDescriptor)));
                    } else {
                        sourceBuilder.append(String.format("struct.%s %s %s ", setter ? "set" : WasmGenerationEnvironment.getGetterInstruction(fieldDescriptor.getTypeDescriptor()), environment.getWasmTypeName((TypeDescriptor)fieldDescriptor.getEnclosingTypeDescriptor()), environment.getFieldName(fieldDescriptor)));
                        this.render(qualifier);
                    }
                } else if (expression instanceof ArrayAccess) {
                    ArrayAccess arrayAccess = (ArrayAccess)expression;
                    Expression arrayExpression = arrayAccess.getArrayExpression();
                    sourceBuilder.append(String.format("array.%s %s ", setter ? "set" : WasmGenerationEnvironment.getGetterInstruction(arrayAccess.getTypeDescriptor()), environment.getWasmTypeName(arrayExpression.getTypeDescriptor())));
                    this.render(arrayExpression);
                    sourceBuilder.append(" ");
                    this.render(arrayAccess.getIndexExpression());
                }
            }

            public boolean enterArrayAccess(ArrayAccess arrayAccess) {
                sourceBuilder.append("(");
                this.renderAccessExpression((Expression)arrayAccess, false);
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterArrayLength(ArrayLength arrayLength) {
                sourceBuilder.append("(array.len ");
                this.render(arrayLength.getArrayExpression());
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterCastExpression(CastExpression castExpression) {
                TypeDescriptor castTypeDescriptor = castExpression.getCastTypeDescriptor().toRawTypeDescriptor();
                if (TypeDescriptors.isJavaLangObject((TypeDescriptor)castTypeDescriptor)) {
                    this.render(castExpression.getExpression());
                    return false;
                }
                if (castTypeDescriptor.isInterface()) {
                    this.render(castExpression.getExpression());
                    return false;
                }
                sourceBuilder.append(String.format("(ref.cast (ref null %s) ", environment.getWasmTypeName(castTypeDescriptor)));
                this.render(castExpression.getExpression());
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterJsDocCastExpression(JsDocCastExpression expression) {
                return this.enterCastExpression(CastExpression.newBuilder().setExpression(expression.getExpression()).setCastTypeDescriptor(expression.getTypeDescriptor()).build());
            }

            public boolean enterConditionalExpression(ConditionalExpression conditionalExpression) {
                TypeDescriptor typeDescriptor = conditionalExpression.getTypeDescriptor();
                sourceBuilder.append("(if (result " + environment.getWasmType(typeDescriptor) + ") ");
                this.render(conditionalExpression.getConditionExpression());
                sourceBuilder.append(" (then ");
                this.render(conditionalExpression.getTrueExpression());
                sourceBuilder.append(") (else ");
                this.render(conditionalExpression.getFalseExpression());
                sourceBuilder.append("))");
                return false;
            }

            public boolean enterFieldAccess(FieldAccess fieldAccess) {
                sourceBuilder.append("(");
                this.renderAccessExpression((Expression)fieldAccess, false);
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterExpressionWithComment(ExpressionWithComment expressionWithComment) {
                sourceBuilder.append(";; " + expressionWithComment.getComment());
                this.render(expressionWithComment.getExpression());
                return false;
            }

            public boolean enterInstanceOfExpression(InstanceOfExpression instanceOfExpression) {
                TypeDescriptor testTypeDescriptor = instanceOfExpression.getTestTypeDescriptor();
                if (!testTypeDescriptor.isInterface()) {
                    sourceBuilder.append(String.format("(ref.test (ref %s) ", environment.getWasmTypeName(testTypeDescriptor)));
                    this.render(instanceOfExpression.getExpression());
                    sourceBuilder.append(")");
                } else {
                    DeclaredTypeDescriptor targetTypeDescriptor = (DeclaredTypeDescriptor)testTypeDescriptor;
                    sourceBuilder.append("(if (result i32) (ref.is_null ");
                    this.render(instanceOfExpression.getExpression());
                    sourceBuilder.append(")");
                    sourceBuilder.indent();
                    sourceBuilder.newLine();
                    sourceBuilder.append("(then (i32.const 0))");
                    sourceBuilder.newLine();
                    sourceBuilder.append("(else ");
                    sourceBuilder.indent();
                    sourceBuilder.newLine();
                    sourceBuilder.append(String.format("(ref.test (ref %s) (call %s ", environment.getWasmVtableTypeName(targetTypeDescriptor), environment.getWasmItableInterfaceGetter(targetTypeDescriptor.getTypeDeclaration())));
                    this.render(instanceOfExpression.getExpression());
                    sourceBuilder.append(" ))");
                    sourceBuilder.unindent();
                    sourceBuilder.newLine();
                    sourceBuilder.append(")");
                    sourceBuilder.unindent();
                    sourceBuilder.newLine();
                    sourceBuilder.append(")");
                }
                return false;
            }

            public boolean enterMethodCall(MethodCall methodCall) {
                if (!methodCall.isPolymorphic() || methodCall.getTarget().isNative()) {
                    this.renderNonPolymorphicMethodCall((Invocation)methodCall);
                } else {
                    this.renderPolymorphicMethodCall(methodCall);
                }
                return false;
            }

            public boolean enterMultiExpression(MultiExpression multiExpression) {
                List expressions = multiExpression.getExpressions();
                Expression returnValue = (Expression)Iterables.getLast((Iterable)expressions);
                sourceBuilder.openParens("block ");
                sourceBuilder.append("(result " + environment.getWasmType(returnValue.getDeclaredTypeDescriptor()) + ")");
                expressions.forEach(expression -> {
                    sourceBuilder.newLine();
                    if (expression == returnValue) {
                        this.render((Expression)expression);
                    } else {
                        ExpressionTranspiler.renderWithUnusedResult(expression, sourceBuilder, environment);
                    }
                });
                sourceBuilder.closeParens();
                return false;
            }

            public boolean enterArrayLiteral(ArrayLiteral arrayLiteral) {
                Preconditions.checkArgument((boolean)arrayLiteral.getTypeDescriptor().isNativeWasmArray());
                String arrayType = environment.getWasmTypeName((TypeDescriptor)arrayLiteral.getTypeDescriptor());
                String dataElementName = environment.getDataElementNameForLiteral(arrayLiteral);
                if (dataElementName != null) {
                    sourceBuilder.append(String.format("(array.new_data %s %s (i32.const 0) (i32.const %d))", arrayType, dataElementName, arrayLiteral.getValueExpressions().size()));
                    return false;
                }
                sourceBuilder.append(String.format("(array.new_fixed %s %d ", arrayType, arrayLiteral.getValueExpressions().size()));
                arrayLiteral.getValueExpressions().forEach(this::render);
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterNewArray(NewArray newArray) {
                Preconditions.checkArgument((boolean)newArray.getTypeDescriptor().isNativeWasmArray());
                Expression dimensionExpression = (Expression)newArray.getDimensionExpressions().get(0);
                if (dimensionExpression instanceof NumberLiteral && ((NumberLiteral)dimensionExpression).getValue().equals(0)) {
                    sourceBuilder.append(String.format("(global.get %s)", environment.getWasmEmptyArrayGlobalName(newArray.getTypeDescriptor())));
                    return false;
                }
                String arrayType = environment.getWasmTypeName((TypeDescriptor)newArray.getTypeDescriptor());
                sourceBuilder.append(String.format("(array.new_default %s ", arrayType));
                this.render(dimensionExpression);
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterStringLiteral(StringLiteral stringLiteral) {
                sourceBuilder.append(String.format("(string.const \"%s\")", StringUtils.escapeAsUtf8((String)stringLiteral.getValue())));
                return false;
            }

            public boolean enterNewInstance(NewInstance newInstance) {
                if (ExpressionTranspiler.isNativeConstructor(newInstance.getTarget())) {
                    this.renderNonPolymorphicMethodCall((Invocation)newInstance);
                    return false;
                }
                sourceBuilder.append(String.format("(struct.new %s (ref.as_non_null (global.get %s)) (ref.as_non_null (global.get %s))", environment.getWasmTypeName((TypeDescriptor)newInstance.getTypeDescriptor()), environment.getWasmVtableGlobalName(newInstance.getTypeDescriptor()), environment.getWasmItableGlobalName(newInstance.getTypeDescriptor())));
                environment.getWasmTypeLayout(newInstance.getTypeDescriptor().getTypeDeclaration()).getAllInstanceFields().forEach(fieldDescriptor -> {
                    sourceBuilder.append(" ");
                    Expression initialValue = AstUtils.getInitialValue((TypeDescriptor)fieldDescriptor.getTypeDescriptor());
                    if (environment.isWasmArrayElementsField((FieldDescriptor)fieldDescriptor)) {
                        Expression argument = (Expression)Iterables.getOnlyElement((Iterable)newInstance.getArguments());
                        Preconditions.checkState((boolean)argument.getTypeDescriptor().isSameBaseType(fieldDescriptor.getTypeDescriptor()));
                        initialValue = argument;
                    }
                    this.render(initialValue);
                });
                sourceBuilder.append(")");
                return false;
            }

            private void renderPolymorphicMethodCall(MethodCall methodCall) {
                boolean isClassDispatch;
                MethodDescriptor target = methodCall.getTarget();
                if (target.isSideEffectFree()) {
                    sourceBuilder.append(String.format("(call %s ", environment.getNoSideEffectWrapperFunctionName(target)));
                } else {
                    sourceBuilder.append(String.format("(call_ref %s ", environment.getFunctionTypeName(target)));
                }
                this.renderReceiver((Invocation)methodCall);
                methodCall.getArguments().forEach(this::render);
                Expression qualifier = methodCall.getQualifier();
                TypeDescriptor qualifierTypeDescriptor = methodCall.getQualifier().getTypeDescriptor().toRawTypeDescriptor();
                boolean bl = isClassDispatch = !qualifierTypeDescriptor.isInterface() || target.isOrOverridesJavaLangObjectMethod();
                if (isClassDispatch) {
                    DeclaredTypeDescriptor vtableTypeDescriptor = qualifierTypeDescriptor.isClass() || qualifierTypeDescriptor.isEnum() ? (DeclaredTypeDescriptor)qualifierTypeDescriptor : TypeDescriptors.get().javaLangObject;
                    sourceBuilder.append(String.format("(struct.get %s %s (struct.get %s $vtable", environment.getWasmVtableTypeName(vtableTypeDescriptor), environment.getVtableFieldName(target), environment.getWasmTypeName((TypeDescriptor)vtableTypeDescriptor)));
                    this.render(qualifier);
                    sourceBuilder.append("))");
                } else {
                    Preconditions.checkState((boolean)qualifierTypeDescriptor.isInterface());
                    DeclaredTypeDescriptor vtableTypeDescriptor = (DeclaredTypeDescriptor)qualifierTypeDescriptor;
                    String vtableTypeName = environment.getWasmVtableTypeName(vtableTypeDescriptor);
                    sourceBuilder.append(String.format("(struct.get %s %s (ref.cast (ref %s) (call %s ", vtableTypeName, environment.getVtableFieldName(target), vtableTypeName, environment.getWasmItableInterfaceGetter(vtableTypeDescriptor.getTypeDeclaration())));
                    this.render(qualifier);
                    sourceBuilder.append(")))");
                }
                sourceBuilder.append(")");
            }

            private void renderNonPolymorphicMethodCall(Invocation methodCall) {
                MethodDescriptor target = methodCall.getTarget();
                String wasmInfo = target.getWasmInfo();
                if (wasmInfo == null) {
                    sourceBuilder.append(String.format("(call %s ", target.isSideEffectFree() ? environment.getNoSideEffectWrapperFunctionName(target) : environment.getMethodImplementationName(target)));
                } else {
                    sourceBuilder.append("(" + wasmInfo + " ");
                }
                if (!target.isStatic() && !target.isConstructor()) {
                    this.renderReceiver(methodCall);
                }
                methodCall.getArguments().forEach(this::render);
                if (target.isSideEffectFree()) {
                    sourceBuilder.append(String.format("(ref.func %s) ", environment.getMethodImplementationName(target)));
                }
                sourceBuilder.append(")");
            }

            private void renderReceiver(Invocation methodCall) {
                sourceBuilder.append("(ref.as_non_null ");
                this.render(methodCall.getQualifier());
                sourceBuilder.append(")");
            }

            public boolean enterNullLiteral(NullLiteral nullLiteral) {
                sourceBuilder.append("(ref.null " + environment.getWasmTypeName(nullLiteral.getTypeDescriptor()) + ")");
                return false;
            }

            public boolean enterNumberLiteral(NumberLiteral numberLiteral) {
                PrimitiveTypeDescriptor typeDescriptor = numberLiteral.getTypeDescriptor();
                String wasmType = (String)Preconditions.checkNotNull((Object)environment.getWasmType((TypeDescriptor)typeDescriptor));
                String value = this.convertToWasmLiteral(numberLiteral.getValue());
                sourceBuilder.append("(" + wasmType + ".const " + value + ")");
                return false;
            }

            private String convertToWasmLiteral(Number value) {
                return value.toString().replace("NaN", "nan").replace("Infinity", "inf");
            }

            public boolean enterThisOrSuperReference(ThisOrSuperReference receiverReference) {
                sourceBuilder.append("(local.get $this)");
                return false;
            }

            public boolean enterUnaryExpression(UnaryExpression expression) {
                WasmUnaryOperation wasmUnaryOperation = WasmUnaryOperation.get(expression);
                sourceBuilder.append("(" + wasmUnaryOperation.getInstruction(expression) + " ");
                this.render(expression.getOperand());
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterVariableDeclarationExpression(VariableDeclarationExpression expression) {
                boolean isFirst = true;
                for (VariableDeclarationFragment fragment : expression.getFragments()) {
                    if (fragment.getInitializer() == null) continue;
                    if (!isFirst) {
                        sourceBuilder.newLine();
                    }
                    isFirst = false;
                    this.renderAssignment((Expression)fragment.getVariable().createReference(), fragment.getInitializer());
                }
                return false;
            }

            public boolean enterVariableReference(VariableReference variableReference) {
                sourceBuilder.append("(");
                this.renderAccessExpression((Expression)variableReference, false);
                sourceBuilder.append(")");
                return false;
            }

            public boolean enterExpression(Expression expression) {
                throw new IllegalStateException("Unhandled expression " + expression);
            }

            private void render(Expression expression) {
                expression.accept((Processor)this);
            }
        }.render(expression);
    }

    public static boolean returnsVoid(Expression expression) {
        if (expression instanceof MethodCall && ((MethodCall)expression).getTarget().isConstructor()) {
            return false;
        }
        return TypeDescriptors.isPrimitiveVoid((TypeDescriptor)expression.getTypeDescriptor()) || expression.isSimpleAssignment();
    }

    private static boolean isNativeConstructor(MethodDescriptor method) {
        return method.getEnclosingTypeDescriptor().isNative() && method.isConstructor();
    }

    private ExpressionTranspiler() {
    }
}

