/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ItableAllocator<T> {
    private final SetMultimap<T, T> classesByInterface = LinkedHashMultimap.create();
    private final List<Set<T>> classesByFieldindex = new ArrayList<Set<T>>();
    private final List<Set<T>> interfacesByFieldIndex = new ArrayList<Set<T>>();
    private final SetMultimap<T, T> implementedInterfacesByClass = LinkedHashMultimap.create();
    private final Map<T, T> superInterfaceByInterface = new HashMap<T, T>();
    private final Multiset<T> itableIndexByInterface = HashMultiset.create();

    public ItableAllocator(List<T> classes, Function<T, Set<T>> implementedInterfaceByType, Function<T, T> superInterfaceByType) {
        classes.forEach(c -> ((Set)implementedInterfaceByType.apply(c)).forEach(i -> {
            this.classesByInterface.put(i, c);
            this.implementedInterfacesByClass.put(c, i);
        }));
        this.classesByInterface.keySet().forEach(i -> this.superInterfaceByInterface.put(i, superInterfaceByType.apply(i)));
        this.classesByInterface.keySet().stream().sorted(Comparator.comparingInt(t -> this.classesByInterface.get(t).size()).reversed()).forEach(this::assignFirstNonConflictingFieldIndex);
    }

    public int getItableSize() {
        return this.classesByFieldindex.size();
    }

    public int getItableFieldIndex(T type) {
        return this.itableIndexByInterface.count(type) - 1;
    }

    private void assignFirstNonConflictingFieldIndex(T interfaceToAssign) {
        int fieldIndex = this.getFirstNonConflictingFieldIndex(interfaceToAssign);
        this.itableIndexByInterface.setCount(interfaceToAssign, fieldIndex + 1);
        this.addClassesToFieldIndex(fieldIndex, interfaceToAssign);
    }

    private void addClassesToFieldIndex(int fieldIndex, T interfaceToAdd) {
        if (this.classesByFieldindex.size() == fieldIndex) {
            this.classesByFieldindex.add(new HashSet());
            this.interfacesByFieldIndex.add(new HashSet());
        }
        this.classesByFieldindex.get(fieldIndex).addAll(this.classesByInterface.get(interfaceToAdd));
        this.interfacesByFieldIndex.get(fieldIndex).add(interfaceToAdd);
    }

    private int getFirstNonConflictingFieldIndex(T interfaceToAssign) {
        int itableSize = this.classesByFieldindex.size();
        for (int index = 0; index < itableSize; ++index) {
            Set<T> alreadyAssignedInterfaces = this.interfacesByFieldIndex.get(index);
            if (!Sets.intersection(this.classesByFieldindex.get(index), (Set)this.classesByInterface.get(interfaceToAssign)).stream().flatMap(c -> this.implementedInterfacesByClass.get(c).stream()).distinct().filter(alreadyAssignedInterfaces::contains).allMatch(i -> this.sharesInheritanceChain(interfaceToAssign, i))) continue;
            return index;
        }
        return itableSize;
    }

    private boolean sharesInheritanceChain(T interface1, T interface2) {
        return interface1.equals(interface2) || this.isSubinterfaceOf(interface1, interface2) || this.isSubinterfaceOf(interface2, interface1);
    }

    private boolean isSubinterfaceOf(T maybeSubinterface, T superinterface) {
        T maybeSuperinterface = this.superInterfaceByInterface.get(maybeSubinterface);
        if (maybeSuperinterface == null) {
            return false;
        }
        return maybeSuperinterface.equals(superinterface) || this.isSubinterfaceOf(maybeSuperinterface, superinterface);
    }
}

