/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.j2cl.common.OutputUtils;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.backend.closure.ClosureGenerationEnvironment;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import com.google.j2cl.transpiler.backend.wasm.AutoValue_JsImportsGenerator_Imports;
import com.google.j2cl.transpiler.backend.wasm.JsMethodImport;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class JsImportsGenerator {
    public static final String MODULE = "imports";
    private final Imports imports;
    private final ClosureGenerationEnvironment closureEnvironment = JsImportsGenerator.createNominalClosureEnvironment();

    public static Imports collectImports(Library library, Problems problems) {
        ImmutableSet.Builder moduleImports = ImmutableSet.builder();
        ImmutableMap.Builder methodImports = ImmutableMap.builder();
        library.accept((Processor)new ImportCollector(problems, (ImmutableMap.Builder<MethodDescriptor, JsMethodImport>)methodImports, (ImmutableSet.Builder<String>)moduleImports));
        return Imports.create((ImmutableMap<MethodDescriptor, JsMethodImport>)methodImports.buildOrThrow(), (ImmutableSet<String>)moduleImports.build());
    }

    public static void generateOutputs(OutputUtils.Output output, Imports imports) {
        JsImportsGenerator importsGenerator = new JsImportsGenerator(imports);
        output.write("imports.txt", JsImportsGenerator.generateOutputs(importsGenerator.imports.getModuleImports(), (Map)imports.getMethodImports().values().stream().collect(ImmutableMap.toImmutableMap(JsMethodImport::getImportKey, importsGenerator::createImportBody, (i1, i2) -> i1))));
    }

    public static String generateOutputs(Collection<String> requiredModules, Map<String, String> methodImports) {
        SourceBuilder builder = new SourceBuilder();
        JsImportsGenerator.emitRequires(builder, requiredModules);
        JsImportsGenerator.emitJsImports(builder, methodImports);
        builder.newLine();
        return builder.build();
    }

    static Map<String, String> collectImportSnippets(Imports imports) {
        JsImportsGenerator importsGenerator = new JsImportsGenerator(imports);
        return (Map)imports.getMethodImports().values().stream().distinct().sorted(Comparator.comparing(JsMethodImport::getImportKey)).collect(ImmutableMap.toImmutableMap(JsMethodImport::getImportKey, importsGenerator::createImportBody, (i1, i2) -> i1));
    }

    private static void emitRequires(SourceBuilder builder, Collection<String> requiredModules) {
        requiredModules.stream().sorted().forEach(i -> {
            builder.append(JsImportsGenerator.createGoogRequire(i));
            builder.newLine();
        });
    }

    private static String createGoogRequire(String importedModule) {
        return String.format("const %s = goog.require('%s');", JsMethodImport.computeJsAlias(importedModule), importedModule);
    }

    private static void emitJsImports(SourceBuilder builder, Map<String, String> methodImports) {
        builder.newLine();
        builder.append("/** @return {!Object<string, *>} Wasm import object */");
        builder.newLine();
        builder.append("function getImports() ");
        builder.openBrace();
        builder.newLine();
        builder.append("return ");
        builder.openBrace();
        builder.newLine();
        builder.append("'WebAssembly': WebAssembly,");
        builder.newLine();
        builder.append(String.format("'%s': ", MODULE));
        builder.openBrace();
        methodImports.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(i -> {
            builder.newLine();
            builder.append(String.format("'%s': %s", i.getKey(), i.getValue()));
            builder.append(",");
        });
        builder.closeBrace();
        builder.closeBrace();
        builder.append(";");
        builder.closeBrace();
    }

    private String createImportBody(JsMethodImport methodImport) {
        if (methodImport.emitAsMethodReference()) {
            return AstUtils.buildQualifiedName((String[])new String[]{methodImport.getJsQualifier(), methodImport.getJsName()});
        }
        return this.createLambdaExpressionCode(methodImport);
    }

    private String createLambdaExpressionCode(JsMethodImport methodImport) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (methodImport.isInstance()) {
            sb.append(this.createParameterDefinition(new Variable.Builder().setName("$instance").setTypeDescriptor((TypeDescriptor)methodImport.getMethod().getDescriptor().getEnclosingTypeDescriptor().toNonNullable()).build()));
        }
        methodImport.getParameters().forEach(v -> sb.append(this.createParameterDefinition((Variable)v)));
        sb.append(") => ");
        if (methodImport.isConstructor()) {
            sb.append(String.format("new %s", methodImport.getJsQualifier()));
        } else if (methodImport.isInstance()) {
            sb.append(String.format("$instance.%s", methodImport.getJsName()));
        } else {
            sb.append(AstUtils.buildQualifiedName((String[])new String[]{methodImport.getJsQualifier(), methodImport.getJsName()}));
        }
        if (methodImport.isPropertyGetter()) {
            return sb.toString();
        }
        if (methodImport.isPropertySetter()) {
            sb.append(" = ");
            sb.append(methodImport.getParameters().get(0).getName());
            return sb.toString();
        }
        sb.append("(");
        for (Variable parameter : methodImport.getParameters()) {
            sb.append(parameter.getName() + ", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String createParameterDefinition(Variable parameter) {
        return String.format("/** %s */ %s, ", this.closureEnvironment.getClosureTypeString(parameter.getTypeDescriptor().toNonNullable()), parameter.getName());
    }

    private static void checkForConflicts(JsMethodImport newImport, JsMethodImport existingImport, Problems problems) {
        if (!JsMethodImport.isCompatible(existingImport, newImport)) {
            problems.error(newImport.getMethod().getSourcePosition(), "Native methods '%s' and '%s', importing JavaScript method '%s', do not match. Both or neither must be constructors, static, or JS properties (b/283986050).", new Object[]{existingImport.getMethod().getReadableDescription(), newImport.getMethod().getReadableDescription(), existingImport.getImportKey()});
        }
        if (!(newImport.getSignature().equals(existingImport.getSignature()) || newImport.emitAsMethodReference() && existingImport.emitAsMethodReference())) {
            problems.error(newImport.getMethod().getSourcePosition(), "Native methods '%s' and '%s', importing JavaScript method '%s', have different parameter types ('%s' vs '%s'), currently disallowed due to performance concerns (b/371225463).", new Object[]{existingImport.getMethod().getReadableDescription(), newImport.getMethod().getReadableDescription(), existingImport.getImportKey(), existingImport.getSignature(), newImport.getSignature()});
        }
    }

    private static boolean shouldGenerateImport(MethodDescriptor methodDescriptor) {
        if (!JsImportsGenerator.isNativeMethod(methodDescriptor)) {
            return false;
        }
        return methodDescriptor.getWasmInfo() == null;
    }

    private static boolean isNativeMethod(MethodDescriptor methodDescriptor) {
        return methodDescriptor.isNative() || methodDescriptor.getEnclosingTypeDescriptor().isNative() && methodDescriptor.isConstructor();
    }

    private static ClosureGenerationEnvironment createNominalClosureEnvironment() {
        return new ClosureGenerationEnvironment((Collection)ImmutableSet.of(), (Map)ImmutableMap.of()){

            public String aliasForType(TypeDeclaration typeDeclaration) {
                return JsMethodImport.getJsTypeName(typeDeclaration);
            }
        };
    }

    private JsImportsGenerator(Imports imports) {
        this.imports = imports;
    }

    private static class ImportCollector
    extends AbstractVisitor {
        private final Problems problems;
        private final ImmutableMap.Builder<MethodDescriptor, JsMethodImport> methodImports;
        private final ImmutableSet.Builder<String> moduleImports;
        private final Map<String, JsMethodImport> methodImportsByName = new HashMap<String, JsMethodImport>();
        private final ClosureGenerationEnvironment closureEnvironment = JsImportsGenerator.createNominalClosureEnvironment();

        public ImportCollector(Problems problems, ImmutableMap.Builder<MethodDescriptor, JsMethodImport> methodImports, ImmutableSet.Builder<String> moduleImports) {
            this.problems = problems;
            this.methodImports = methodImports;
            this.moduleImports = moduleImports;
        }

        public void exitMethod(Method method) {
            MethodDescriptor methodDescriptor = method.getDescriptor();
            if (!JsImportsGenerator.shouldGenerateImport(methodDescriptor)) {
                return;
            }
            this.addMethodImport(JsMethodImport.newBuilder().setBaseImportKey(JsMethodImport.getJsImportName(methodDescriptor)).setSignature(JsMethodImport.computeSignature(methodDescriptor, this.closureEnvironment)).setMethod(method).build());
            this.addModuleImports(methodDescriptor);
        }

        private void addMethodImport(JsMethodImport newImport) {
            JsMethodImport newOrExistingImport = this.methodImportsByName.compute(newImport.getImportKey(), (keyUnused, existingImport) -> {
                if (existingImport == null) {
                    return newImport;
                }
                JsImportsGenerator.checkForConflicts(newImport, existingImport, this.problems);
                return existingImport;
            });
            this.methodImports.put((Object)newImport.getMethod().getDescriptor(), (Object)newOrExistingImport);
        }

        private void addModuleImports(MethodDescriptor methodDescriptor) {
            if (!methodDescriptor.isExtern()) {
                if (methodDescriptor.hasJsNamespace()) {
                    this.moduleImports.add((Object)methodDescriptor.getJsNamespace());
                } else {
                    this.collectModuleImports((TypeDescriptor)methodDescriptor.getEnclosingTypeDescriptor());
                }
            }
            methodDescriptor.getParameterTypeDescriptors().forEach(this::collectModuleImports);
        }

        private void collectModuleImports(TypeDescriptor typeDescriptor) {
            if (!(typeDescriptor instanceof DeclaredTypeDescriptor)) {
                return;
            }
            DeclaredTypeDescriptor declaredTypeDescriptor = (DeclaredTypeDescriptor)typeDescriptor;
            TypeDeclaration typeDeclaration = declaredTypeDescriptor.getTypeDeclaration();
            if (!typeDeclaration.isNative() || typeDeclaration.isExtern()) {
                return;
            }
            this.moduleImports.add((Object)typeDeclaration.getEnclosingModule().getQualifiedJsName());
            for (TypeDescriptor t : declaredTypeDescriptor.getTypeArgumentDescriptors()) {
                this.collectModuleImports(t);
            }
        }
    }

    @AutoValue
    public static abstract class Imports {
        public abstract ImmutableMap<MethodDescriptor, JsMethodImport> getMethodImports();

        public abstract ImmutableSet<String> getModuleImports();

        public static Imports create(ImmutableMap<MethodDescriptor, JsMethodImport> methodImports, ImmutableSet<String> moduleImports) {
            return new AutoValue_JsImportsGenerator_Imports(methodImports, moduleImports);
        }
    }
}

