/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.math.Stats;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.Block;
import com.google.j2cl.transpiler.ast.BooleanLiteral;
import com.google.j2cl.transpiler.ast.BreakStatement;
import com.google.j2cl.transpiler.ast.CatchClause;
import com.google.j2cl.transpiler.ast.ContinueStatement;
import com.google.j2cl.transpiler.ast.DoWhileStatement;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.ExpressionStatement;
import com.google.j2cl.transpiler.ast.ForStatement;
import com.google.j2cl.transpiler.ast.IfStatement;
import com.google.j2cl.transpiler.ast.Label;
import com.google.j2cl.transpiler.ast.LabeledStatement;
import com.google.j2cl.transpiler.ast.LoopStatement;
import com.google.j2cl.transpiler.ast.NameDeclaration;
import com.google.j2cl.transpiler.ast.NumberLiteral;
import com.google.j2cl.transpiler.ast.ReturnStatement;
import com.google.j2cl.transpiler.ast.RuntimeMethods;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.SwitchCase;
import com.google.j2cl.transpiler.ast.SwitchStatement;
import com.google.j2cl.transpiler.ast.SynchronizedStatement;
import com.google.j2cl.transpiler.ast.ThrowStatement;
import com.google.j2cl.transpiler.ast.TryStatement;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.WhileStatement;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import com.google.j2cl.transpiler.backend.wasm.ExpressionTranspiler;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

final class StatementTranspiler {
    public static void render(Statement statement, final SourceBuilder builder, final WasmGenerationEnvironment environment) {
        if (!(statement instanceof Block)) {
            StatementTranspiler.renderSourceMappingComment(environment.getSourceMappingPathPrefix(), statement.getSourcePosition(), builder);
        }
        class SourceTransformer
        extends AbstractVisitor {
            private static final double MINIMUM_CASE_DENSITY = 0.25;

            SourceTransformer() {
            }

            public boolean enterStatement(Statement statement) {
                throw new IllegalStateException("Unhandled statement " + statement);
            }

            public boolean enterBlock(Block block) {
                builder.newLine();
                builder.openParens("block");
                this.renderStatements(block.getStatements());
                builder.closeParens();
                return false;
            }

            private void renderStatements(List<Statement> statements) {
                statements.forEach(this::render);
            }

            public boolean enterBreakStatement(BreakStatement breakStatement) {
                builder.newLine();
                builder.append("(br " + this.getBreakLabelName(breakStatement.getLabelReference().getTarget()) + ")");
                return false;
            }

            public boolean enterContinueStatement(ContinueStatement continueStatement) {
                builder.newLine();
                builder.append("(br " + this.getContinueLabelName(continueStatement.getLabelReference().getTarget()) + ")");
                return false;
            }

            public boolean enterExpressionStatement(ExpressionStatement expressionStatement) {
                Expression expression = expressionStatement.getExpression();
                builder.newLine();
                builder.emitWithMapping(expressionStatement.getSourcePosition(), () -> ExpressionTranspiler.renderWithUnusedResult(expression, builder, environment));
                return false;
            }

            public boolean enterIfStatement(IfStatement ifStatement) {
                builder.newLine();
                builder.openParens("if ");
                builder.emitWithMapping(ifStatement.getSourcePosition(), () -> this.renderExpression(ifStatement.getConditionExpression()));
                builder.newLine();
                builder.openParens("then");
                this.render(ifStatement.getThenStatement());
                builder.closeParens();
                if (ifStatement.getElseStatement() != null) {
                    builder.openParens("else");
                    this.render(ifStatement.getElseStatement());
                    builder.closeParens();
                }
                builder.closeParens();
                return false;
            }

            public boolean enterLabeledStatement(LabeledStatement labeledStatement) {
                if (labeledStatement.getStatement() instanceof LoopStatement) {
                    return true;
                }
                String label = this.getBreakLabelName(labeledStatement.getLabel());
                builder.newLine();
                builder.openParens("block " + label);
                this.render(labeledStatement.getStatement());
                builder.closeParens();
                return false;
            }

            public boolean enterReturnStatement(ReturnStatement returnStatement) {
                builder.emitWithMapping(returnStatement.getSourcePosition(), () -> {
                    builder.newLine();
                    builder.append("(return ");
                    if (returnStatement.getExpression() != null) {
                        ExpressionTranspiler.render(returnStatement.getExpression(), builder, environment);
                    }
                    builder.append(")");
                });
                return false;
            }

            public boolean enterSwitchStatement(SwitchStatement switchStatement) {
                for (SwitchCase unused : switchStatement.getCases()) {
                    builder.newLine();
                    builder.openParens("block");
                }
                this.renderSwitchDispatchTable(switchStatement);
                for (SwitchCase switchCase : switchStatement.getCases()) {
                    builder.newLine();
                    builder.append((String)(switchCase.isDefault() ? ";; default:" : ";; case " + switchCase.getCaseExpression() + ":"));
                    this.renderStatements(switchCase.getStatements());
                    builder.closeParens();
                }
                return false;
            }

            private void renderSwitchDispatchTable(SwitchStatement switchStatement) {
                Stats stats;
                if (this.isPrimitiveOrJsEnum(switchStatement.getExpression().getTypeDescriptor()) && this.isDense(stats = Stats.of((IntStream)switchStatement.getCases().stream().filter(Predicates.not(SwitchCase::isDefault)).mapToInt(x$0 -> StatementTranspiler.getSwitchCaseAsIntValue(x$0))))) {
                    this.renderDenseSwitchDispatchTable(switchStatement, stats);
                    return;
                }
                this.renderNonDenseSwitchDispatchTable(switchStatement);
            }

            private boolean isPrimitiveOrJsEnum(TypeDescriptor typeDescriptor) {
                return typeDescriptor.isPrimitive() || AstUtils.isPrimitiveNonNativeJsEnum((TypeDescriptor)typeDescriptor);
            }

            private boolean isDense(Stats caseStats) {
                return caseStats.count() > 0L && (double)caseStats.count() / (caseStats.max() - caseStats.min()) > 0.25;
            }

            private void renderDenseSwitchDispatchTable(SwitchStatement switchStatement, Stats caseStats) {
                List switchCases = switchStatement.getCases();
                int[] slots = new int[(int)(caseStats.max() - caseStats.min() + 2.0)];
                int defaultCasePosition = switchStatement.getDefaultCasePosition();
                if (defaultCasePosition == -1) {
                    defaultCasePosition = switchCases.size();
                }
                Arrays.fill(slots, defaultCasePosition);
                int offset = (int)caseStats.min();
                for (int casePosition = 0; casePosition < switchCases.size(); ++casePosition) {
                    SwitchCase switchCase = (SwitchCase)switchCases.get(casePosition);
                    if (switchCase.isDefault()) continue;
                    slots[StatementTranspiler.getSwitchCaseAsIntValue((SwitchCase)switchCase) - offset] = casePosition;
                }
                builder.newLine();
                builder.openParens("block ;; evaluate expression and jump");
                builder.newLine();
                builder.append("(br_table ");
                Arrays.stream(slots).forEach(slot -> builder.append(slot + " "));
                this.emitBranchIndexExpression(switchStatement.getExpression(), offset);
                builder.append(")");
                builder.closeParens();
            }

            private void emitBranchIndexExpression(Expression expression, int offset) {
                if (offset == 0) {
                    this.renderExpression(expression);
                } else {
                    builder.append("(i32.sub ");
                    this.renderExpression(expression);
                    builder.append(" (i32.const " + offset + "))");
                }
            }

            private void renderNonDenseSwitchDispatchTable(SwitchStatement switchStatement) {
                builder.newLine();
                builder.openParens("block ;; evaluate expression and jump");
                for (int casePosition = 0; casePosition < switchStatement.getCases().size(); ++casePosition) {
                    SwitchCase switchCase = (SwitchCase)switchStatement.getCases().get(casePosition);
                    if (switchCase.isDefault()) continue;
                    Expression condition = this.createCaseCondition(switchCase.getCaseExpression(), switchStatement.getExpression());
                    this.renderConditionalBranch(switchStatement.getSourcePosition(), condition, casePosition);
                }
                int defaultCasePosition = switchStatement.getDefaultCasePosition();
                this.renderUnconditionalBranch(defaultCasePosition != -1 ? defaultCasePosition : switchStatement.getCases().size());
                builder.closeParens();
            }

            private Expression createCaseCondition(Expression switchCaseExpression, Expression expression) {
                if (TypeDescriptors.isJavaLangString((TypeDescriptor)switchCaseExpression.getTypeDescriptor())) {
                    return RuntimeMethods.createStringEqualsMethodCall((Expression)switchCaseExpression, (Expression)expression);
                }
                Preconditions.checkState((boolean)switchCaseExpression.getTypeDescriptor().isPrimitive());
                return expression.infixEquals(switchCaseExpression);
            }

            public boolean enterSynchronizedStatement(SynchronizedStatement synchronizedStatement) {
                this.render((Statement)synchronizedStatement.getExpression().makeStatement(synchronizedStatement.getSourcePosition()));
                this.render((Statement)synchronizedStatement.getBody());
                return false;
            }

            public boolean enterThrowStatement(ThrowStatement throwStatement) {
                builder.newLine();
                builder.emitWithMapping(throwStatement.getSourcePosition(), () -> {
                    builder.append("(throw $exception.event ");
                    this.renderExpression(throwStatement.getExpression());
                    builder.append(")");
                });
                return false;
            }

            public boolean enterTryStatement(TryStatement tryStatement) {
                builder.newLine();
                CatchClause catchClause = (CatchClause)Iterables.getOnlyElement((Iterable)tryStatement.getCatchClauses(), null);
                if (catchClause != null) {
                    builder.append("(try (do");
                    builder.indent();
                    this.render((Statement)tryStatement.getBody());
                    builder.unindent();
                    builder.newLine();
                    builder.append(") (catch $exception.event");
                    builder.indent();
                    builder.newLine();
                    builder.append(String.format("(local.set %s (pop externref))", environment.getDeclarationName((NameDeclaration)catchClause.getExceptionVariable())));
                    this.render((Statement)catchClause.getBody());
                    builder.unindent();
                    builder.newLine();
                    builder.append("))");
                } else {
                    this.render((Statement)tryStatement.getBody());
                }
                Preconditions.checkState((tryStatement.getFinallyBlock() == null ? 1 : 0) != 0);
                return false;
            }

            public boolean enterWhileStatement(WhileStatement whileStatement) {
                this.renderLoop(() -> {
                    this.renderConditionalBranch(whileStatement.getSourcePosition(), whileStatement.getConditionExpression().prefixNot(), 1);
                    this.renderLabeledStatement(this.getContinueLabelName(this.getLabel()), whileStatement.getBody());
                    this.renderUnconditionalBranch(0);
                });
                return false;
            }

            public boolean enterDoWhileStatement(DoWhileStatement doWhileStatement) {
                this.renderLoop(() -> {
                    this.renderLabeledStatement(this.getContinueLabelName(this.getLabel()), doWhileStatement.getBody());
                    this.renderConditionalBranch(doWhileStatement.getSourcePosition(), doWhileStatement.getConditionExpression(), 0);
                });
                return false;
            }

            public boolean enterForStatement(ForStatement forStatement) {
                forStatement.getInitializers().forEach(i -> {
                    builder.newLine();
                    ExpressionTranspiler.renderWithUnusedResult(i, builder, environment);
                });
                this.renderLoop(() -> {
                    this.renderConditionalBranch(forStatement.getSourcePosition(), forStatement.getConditionExpression().prefixNot(), 1);
                    this.renderLabeledStatement(this.getContinueLabelName(this.getLabel()), forStatement.getBody());
                    forStatement.getUpdates().forEach(u -> {
                        builder.newLine();
                        ExpressionTranspiler.renderWithUnusedResult(u, builder, environment);
                    });
                    this.renderUnconditionalBranch(0);
                });
                return false;
            }

            private void renderUnconditionalBranch(int target) {
                builder.newLine();
                builder.append(String.format("(br %d)", target));
            }

            private void renderConditionalBranch(SourcePosition sourcePosition, Expression condition, int target) {
                if (condition.equals(BooleanLiteral.get((boolean)false))) {
                    return;
                }
                builder.newLine();
                builder.emitWithMapping(sourcePosition, () -> {
                    builder.append(String.format("(br_if %d ", target));
                    this.renderExpression(condition);
                    builder.append(")");
                });
            }

            void renderLoop(Runnable bodyEmitter) {
                builder.newLine();
                builder.openParens("block " + this.getBreakLabelName(this.getLabel()));
                builder.newLine();
                builder.openParens("loop");
                bodyEmitter.run();
                builder.closeParens();
                builder.closeParens();
            }

            void renderLabeledStatement(String label, Statement statement) {
                builder.newLine();
                builder.openParens("block " + label);
                this.render(statement);
                builder.closeParens();
            }

            private String getBreakLabelName(Label label) {
                return environment.getDeclarationName((NameDeclaration)label) + ".BREAK";
            }

            private String getContinueLabelName(Label label) {
                return environment.getDeclarationName((NameDeclaration)label) + ".CONTINUE";
            }

            private Label getLabel() {
                return ((LabeledStatement)this.getParent()).getLabel();
            }

            private void renderExpression(Expression expression) {
                ExpressionTranspiler.render(expression, builder, environment);
            }

            void render(Statement stmt) {
                StatementTranspiler.render(stmt, builder, environment);
            }
        }
        statement.accept((Processor)new SourceTransformer());
    }

    public static void renderSourceMappingComment(String sourceMappingPathPrefix, SourcePosition sourcePosition, SourceBuilder builder) {
        if (sourcePosition != SourcePosition.NONE) {
            builder.newLine();
            builder.append(String.format(";;@ %s%s:%d:%d", Strings.nullToEmpty((String)sourceMappingPathPrefix), sourcePosition.getPackageRelativePath(), sourcePosition.getStartFilePosition().getLine() + 1, sourcePosition.getStartFilePosition().getColumn()));
        }
    }

    private static int getSwitchCaseAsIntValue(SwitchCase switchCase) {
        NumberLiteral caseExpression = (NumberLiteral)switchCase.getCaseExpression();
        return caseExpression.getValue().intValue();
    }

    private StatementTranspiler() {
    }
}

