/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.StringUtils;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractRewriter;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.MethodCall;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.StringLiteral;
import com.google.j2cl.transpiler.ast.StringLiteralGettersCreator;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.backend.wasm.SharedSnippet;
import com.google.j2cl.transpiler.backend.wasm.StringLiteralInfo;
import com.google.j2cl.transpiler.backend.wasm.Summary;
import com.google.j2cl.transpiler.backend.wasm.SystemPropertyInfo;
import com.google.j2cl.transpiler.backend.wasm.TypeInfo;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class SummaryBuilder {
    public static final int NULL_TYPE = 0;
    private final Summary.Builder summary = Summary.newBuilder();
    private final Map<String, Integer> typeIdByTypeName = new HashMap<String, Integer>();
    private final WasmGenerationEnvironment environment;

    SummaryBuilder(Library library, WasmGenerationEnvironment environment, Problems problems) {
        this.environment = environment;
        this.summaryTypeHierarchy(library);
        this.summarizeSystemGetPropertyCalls(library);
        this.summarizeStringLiterals(library);
    }

    void addSharedTypeSnippet(String key, String snippet) {
        this.summary.addTypeSnippets(SharedSnippet.newBuilder().setKey(key).setSnippet(snippet));
    }

    void addSharedGlobalSnippet(String key, String snippet) {
        this.summary.addGlobalSnippets(SharedSnippet.newBuilder().setKey(key).setSnippet(snippet));
    }

    void addSharedWasmImportSnippet(String key, String snippet) {
        this.summary.addWasmImportSnippets(SharedSnippet.newBuilder().setKey(key).setSnippet(snippet));
    }

    void addSharedJsImportSnippet(String key, String snippet) {
        this.summary.addJsImportSnippets(SharedSnippet.newBuilder().setKey(key).setSnippet(snippet));
    }

    void addSharedJsImportRequireSnippet(String snippet) {
        this.summary.addJsImportRequires(snippet);
    }

    private void summaryTypeHierarchy(Library library) {
        library.streamTypes().sorted(Comparator.comparing(t -> t.getDeclaration().getTypeHierarchyDepth())).forEach(this::addType);
    }

    private void addType(Type type) {
        if (type.isNative() || type.isOverlayImplementation() || type.getDeclaration().getWasmInfo() != null) {
            return;
        }
        int typeId = this.getTypeId(type.getTypeDescriptor());
        TypeInfo.Builder typeHierarchyInfoBuilder = TypeInfo.newBuilder().setTypeId(typeId).setAbstract(type.getDeclaration().isAbstract());
        TypeDeclaration superTypeDeclaration = WasmGenerationEnvironment.getTypeLayoutSuperTypeDeclaration(type.getDeclaration());
        if (superTypeDeclaration != null && !superTypeDeclaration.isNative()) {
            typeHierarchyInfoBuilder.setExtendsType(this.getTypeId(superTypeDeclaration.toDescriptor()));
        }
        if (type.isInterface()) {
            this.summary.addInterfaces(typeHierarchyInfoBuilder.build());
        } else {
            type.getDeclaration().getAllSuperInterfaces().stream().filter(Predicate.not(TypeDeclaration::isNative)).forEach(t -> typeHierarchyInfoBuilder.addImplementsTypes(this.getTypeId(t.toDescriptor())));
            this.summary.addTypes(typeHierarchyInfoBuilder.build());
        }
    }

    private int getTypeId(DeclaredTypeDescriptor typeDescriptor) {
        String typeName = this.environment.getTypeSignature((TypeDescriptor)typeDescriptor);
        return this.typeIdByTypeName.computeIfAbsent(typeName, x -> this.typeIdByTypeName.size() + 1);
    }

    private void summarizeSystemGetPropertyCalls(Library library) {
        final LinkedHashSet allProperties = new LinkedHashSet();
        final LinkedHashSet requiredProperties = new LinkedHashSet();
        library.accept((Processor)new AbstractVisitor(){

            public void exitMethodCall(MethodCall methodCall) {
                MethodDescriptor target = methodCall.getTarget();
                String name = target.getName();
                if (target.getOrigin().isSystemGetPropertyGetter()) {
                    allProperties.add(name);
                }
                if (target.getOrigin().isRequiredSystemGetPropertyGetter()) {
                    requiredProperties.add(name);
                }
            }
        });
        this.summary.addAllSystemProperties((Iterable)allProperties.stream().map(pk -> SystemPropertyInfo.newBuilder().setPropertyKey(pk).setIsRequired(requiredProperties.contains(pk)).build()).collect(ImmutableList.toImmutableList()));
    }

    private void summarizeStringLiterals(Library library) {
        final StringLiteralGettersCreator stringLiteralGetterCreator = new StringLiteralGettersCreator();
        library.accept((Processor)new AbstractRewriter(){

            public Expression rewriteStringLiteral(StringLiteral stringLiteral) {
                return MethodCall.Builder.from((MethodDescriptor)stringLiteralGetterCreator.getOrCreateLiteralMethod(this.getCurrentType(), stringLiteral, false)).build();
            }
        });
        stringLiteralGetterCreator.getLiteralMethodByString().forEach((s, m) -> this.summary.addStringLiterals(StringLiteralInfo.newBuilder().setContent(StringUtils.escapeAsWtf16((String)s)).setEnclosingTypeName(m.getEnclosingTypeDescriptor().getQualifiedSourceName()).setMethodName(m.getName()).build()));
    }

    private Summary build() {
        this.summary.clearTypeNames();
        String[] typeNames = new String[this.typeIdByTypeName.size() + 1];
        typeNames[0] = "<no-type>";
        this.typeIdByTypeName.forEach((name, i) -> {
            typeNames[i.intValue()] = name;
        });
        this.summary.addAllTypeNames(Arrays.asList(typeNames));
        return this.summary.build();
    }

    @Nullable
    public String toJson(Problems problems) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)this.build());
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_WRITE_FILE, new Object[]{e.toString()});
            return null;
        }
    }

    public byte[] toByteArray() {
        return this.build().toByteArray();
    }
}

