/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend.wasm;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.StringUtils;
import com.google.j2cl.common.visitor.Processor;
import com.google.j2cl.transpiler.ast.AbstractVisitor;
import com.google.j2cl.transpiler.ast.ArrayLiteral;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.Field;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.NameDeclaration;
import com.google.j2cl.transpiler.ast.NumberLiteral;
import com.google.j2cl.transpiler.ast.PrimitiveTypeDescriptor;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.backend.common.SourceBuilder;
import com.google.j2cl.transpiler.backend.wasm.ExpressionTranspiler;
import com.google.j2cl.transpiler.backend.wasm.JsMethodImport;
import com.google.j2cl.transpiler.backend.wasm.StatementTranspiler;
import com.google.j2cl.transpiler.backend.wasm.WasmGenerationEnvironment;
import com.google.j2cl.transpiler.backend.wasm.WasmTypeLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class WasmConstructsGenerator {
    private final SourceBuilder builder;
    private final WasmGenerationEnvironment environment;
    private final String sourceMappingPathPrefix;

    public WasmConstructsGenerator(WasmGenerationEnvironment environment, SourceBuilder builder, String sourceMappingPathPrefix) {
        this.environment = environment;
        this.builder = builder;
        this.sourceMappingPathPrefix = sourceMappingPathPrefix;
    }

    void emitDataSegments(Library library) {
        library.accept((Processor)new AbstractVisitor(){

            public void exitArrayLiteral(ArrayLiteral arrayLiteral) {
                if (WasmConstructsGenerator.this.canBeMovedToDataSegment(arrayLiteral) && WasmConstructsGenerator.this.environment.registerDataSegmentLiteral(arrayLiteral, this.getCurrentType().getDeclaration().getQualifiedBinaryName())) {
                    String dataElementName = WasmConstructsGenerator.this.environment.getDataElementNameForLiteral(arrayLiteral);
                    WasmConstructsGenerator.this.builder.newLine();
                    WasmConstructsGenerator.this.builder.append(String.format("(data %s \"%s\")", dataElementName, WasmConstructsGenerator.this.toDataString(arrayLiteral)));
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBeMovedToDataSegment(ArrayLiteral arrayLiteral) {
        if (!TypeDescriptors.isNonVoidPrimitiveType((TypeDescriptor)arrayLiteral.getTypeDescriptor().getComponentTypeDescriptor())) return false;
        if (!arrayLiteral.getValueExpressions().stream().allMatch(NumberLiteral.class::isInstance)) return false;
        return true;
    }

    private String toDataString(ArrayLiteral arrayLiteral) {
        PrimitiveTypeDescriptor componentTypeDescriptor = (PrimitiveTypeDescriptor)arrayLiteral.getTypeDescriptor().getComponentTypeDescriptor();
        int sizeInBits = componentTypeDescriptor.getWidth();
        List valueExpressions = arrayLiteral.getValueExpressions();
        StringBuilder sb = new StringBuilder(valueExpressions.size() * (sizeInBits / 8));
        for (Expression expression : valueExpressions) {
            NumberLiteral literal = (NumberLiteral)expression;
            PrimitiveTypeDescriptor typeDescriptor = literal.getTypeDescriptor();
            long value = TypeDescriptors.isPrimitiveFloat((TypeDescriptor)typeDescriptor) ? (long)Float.floatToRawIntBits(literal.getValue().floatValue()) : (TypeDescriptors.isPrimitiveDouble((TypeDescriptor)typeDescriptor) ? Double.doubleToRawLongBits(literal.getValue().doubleValue()) : literal.getValue().longValue());
            int s = sizeInBits;
            while (s > 0) {
                sb.append(StringUtils.escapeAsUtf8((int)((int)(value & 0xFFL))));
                s -= 8;
                value >>>= 8;
            }
        }
        return sb.toString();
    }

    void emitLibraryRecGroup(Library library, List<ArrayTypeDescriptor> usedNativeArrayTypes) {
        this.builder.newLine();
        this.builder.append("(rec");
        this.builder.indent();
        this.emitDynamicDispatchMethodTypes();
        this.emitItableSupportTypes();
        this.emitNativeArrayTypes(usedNativeArrayTypes);
        this.emitForEachType(library, this::renderMonolithicTypeStructs, "type definition");
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
    }

    private void emitItableSupportTypes() {
        this.builder.newLine();
        this.builder.append("(type $itable (sub (struct");
        this.builder.indent();
        for (int index = 0; index < this.environment.getItableSize(); ++index) {
            this.builder.newLine();
            this.builder.append("(field (ref null struct))");
        }
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")))");
    }

    public void emitGlobals(Library library) {
        this.emitStaticFieldGlobals(library);
    }

    void emitDynamicDispatchMethodTypes() {
        this.environment.collectMethodsThatNeedTypeDeclarations().forEach(this::emitFunctionType);
    }

    void emitFunctionType(String typeName, MethodDescriptor m) {
        this.builder.newLine();
        this.builder.append(String.format("(type %s (func", typeName));
        this.emitFunctionParameterTypes(m);
        this.emitFunctionResultType(m);
        this.builder.append("))");
    }

    void emitImportsForBinaryenIntrinsics() {
        this.environment.collectMethodsNeedingIntrinsicDeclarations().forEach(this::emitBinaryenIntrinsicImport);
    }

    void emitBinaryenIntrinsicImport(String typeName, MethodDescriptor m) {
        this.builder.newLine();
        this.builder.append(String.format("(import \"binaryen-intrinsics\" \"call.without.effects\" (func %s ", typeName));
        this.emitFunctionParameterTypes(m);
        this.builder.append(" (param funcref)");
        this.emitFunctionResultType(m);
        this.builder.append("))");
    }

    private void emitFunctionParameterTypes(MethodDescriptor methodDescriptor) {
        if (!methodDescriptor.isStatic()) {
            this.builder.append(String.format(" (param (ref %s))", this.environment.getWasmTypeName((TypeDescriptor)TypeDescriptors.get().javaLangObject)));
        }
        methodDescriptor.getDispatchParameterTypeDescriptors().forEach(t -> this.builder.append(String.format(" (param %s)", this.environment.getWasmType((TypeDescriptor)t))));
    }

    private void emitFunctionResultType(MethodDescriptor methodDescriptor) {
        TypeDescriptor returnTypeDescriptor = methodDescriptor.getDispatchReturnTypeDescriptor();
        if (!TypeDescriptors.isPrimitiveVoid((TypeDescriptor)returnTypeDescriptor)) {
            this.builder.append(String.format(" (result %s)", this.environment.getWasmType(returnTypeDescriptor)));
        }
    }

    public void emitExceptionTag() {
        this.builder.newLine();
        this.builder.append("(import \"WebAssembly\" \"JSTag\" (tag $exception.event (param externref)))");
    }

    private void renderMonolithicTypeStructs(Type type) {
        this.renderTypeStructs(type, false);
    }

    void renderModularTypeStructs(Type type) {
        this.renderTypeStructs(type, true);
    }

    private void renderTypeStructs(Type type, boolean isModular) {
        if (type.isNative() || type.getDeclaration().getWasmInfo() != null) {
            return;
        }
        this.renderTypeVtableStruct(type);
        if (!type.isInterface()) {
            this.renderTypeStruct(type);
            if (!isModular) {
                this.renderClassItableStruct(type);
            }
        }
    }

    private void renderClassItableStruct(Type type) {
        TypeDeclaration typeDeclaration = type.getDeclaration();
        if (!typeDeclaration.implementsInterfaces()) {
            return;
        }
        this.emitItableType(typeDeclaration, this.getInterfacesByItableIndex(typeDeclaration));
    }

    private void renderTypeVtableStruct(Type type) {
        WasmTypeLayout wasmTypeLayout = this.environment.getWasmTypeLayout(type.getDeclaration());
        this.renderVtableStruct(type, wasmTypeLayout.getAllPolymorphicMethods());
    }

    private void renderVtableStruct(Type type, Collection<MethodDescriptor> methods) {
        this.emitWasmStruct(type, this.environment::getWasmVtableTypeName, () -> this.renderVtableEntries(methods));
    }

    private void renderVtableEntries(Collection<MethodDescriptor> methodDescriptors) {
        methodDescriptors.forEach(m -> {
            this.builder.newLine();
            this.builder.append(String.format("(field $%s (ref %s))", m.getMangledName(), this.environment.getFunctionTypeName((MethodDescriptor)m)));
        });
    }

    private void emitStaticFieldGlobals(Library library) {
        library.streamTypes().forEach(this::emitStaticFieldGlobals);
    }

    private void emitStaticFieldGlobals(Type type) {
        ImmutableList fields = type.getStaticFields();
        if (fields.isEmpty()) {
            return;
        }
        this.emitBeginCodeComment(type, "static fields");
        for (Field field : fields) {
            this.builder.newLine();
            this.builder.append("(global " + this.environment.getFieldName(field));
            if (field.isCompileTimeConstant()) {
                this.builder.append(String.format(" %s", this.environment.getWasmType(field.getDescriptor().getTypeDescriptor())));
                this.builder.indent();
                this.builder.newLine();
                ExpressionTranspiler.render(field.getInitializer(), this.builder, this.environment);
                this.builder.unindent();
            } else {
                this.builder.append(String.format(" (mut %s)", this.environment.getWasmType(field.getDescriptor().getTypeDescriptor())));
                this.builder.indent();
                this.builder.newLine();
                ExpressionTranspiler.render(AstUtils.getInitialValue((TypeDescriptor)field.getDescriptor().getTypeDescriptor()), this.builder, this.environment);
                this.builder.unindent();
            }
            this.builder.newLine();
            this.builder.append(")");
        }
        this.emitEndCodeComment(type, "static fields");
    }

    void renderImportedMethods(Type type) {
        type.getMethods().stream().filter(this.environment::isJsImport).forEach(this::renderMethod);
    }

    void renderTypeMethods(Type type) {
        type.getMethods().stream().filter(Predicate.not(this.environment::isJsImport)).forEach(this::renderMethod);
    }

    public void renderMethod(Method method) {
        MethodDescriptor methodDescriptor = method.getDescriptor();
        if (methodDescriptor.isAbstract() && !methodDescriptor.isNative() || methodDescriptor.getWasmInfo() != null) {
            return;
        }
        boolean isNativeConstructor = methodDescriptor.getEnclosingTypeDescriptor().isNative() && methodDescriptor.isConstructor();
        JsMethodImport jsMethodImport = this.environment.getJsMethodImport(methodDescriptor);
        this.builder.newLine();
        this.builder.newLine();
        this.builder.append(";;; " + method.getReadableDescription());
        this.builder.newLine();
        this.builder.append("(func " + this.environment.getMethodImplementationName(methodDescriptor));
        if (jsMethodImport != null) {
            this.builder.append(String.format(" (import \"%s\" \"%s\") ", "imports", jsMethodImport.getImportKey()));
        }
        if (method.isWasmEntryPoint()) {
            this.builder.append(" (export \"" + method.getWasmExportName() + "\")");
        }
        DeclaredTypeDescriptor enclosingTypeDescriptor = methodDescriptor.getEnclosingTypeDescriptor();
        this.builder.indent();
        if (WasmConstructsGenerator.isReceiverCastNeeded(methodDescriptor)) {
            this.builder.newLine();
            this.builder.append(String.format("(type %s)", this.environment.getFunctionTypeName(methodDescriptor)));
            this.builder.newLine();
            this.builder.append(String.format("(param $this.untyped (ref %s))", this.environment.getWasmTypeName((TypeDescriptor)TypeDescriptors.get().javaLangObject)));
        } else if (!method.isStatic() && !isNativeConstructor) {
            this.builder.newLine();
            this.builder.append(String.format("(param $this %s)", this.environment.getWasmType((TypeDescriptor)enclosingTypeDescriptor)));
        }
        for (Variable parameter : method.getParameters()) {
            this.builder.newLine();
            this.builder.append("(param " + this.environment.getDeclarationName((NameDeclaration)parameter) + " " + this.environment.getWasmType(parameter.getTypeDescriptor()) + ")");
        }
        TypeDescriptor returnTypeDescriptor = methodDescriptor.getDispatchReturnTypeDescriptor();
        if (!TypeDescriptors.isPrimitiveVoid((TypeDescriptor)returnTypeDescriptor)) {
            this.builder.newLine();
            this.builder.append("(result " + this.environment.getWasmType(returnTypeDescriptor) + ")");
        }
        if (jsMethodImport != null) {
            this.builder.unindent();
            this.builder.newLine();
            this.builder.append(")");
            return;
        }
        StatementTranspiler.renderSourceMappingComment(this.sourceMappingPathPrefix, method.getSourcePosition(), this.builder);
        for (Variable variable : WasmConstructsGenerator.collectLocals(method)) {
            this.builder.newLine();
            this.builder.append("(local " + this.environment.getDeclarationName((NameDeclaration)variable) + " " + this.environment.getWasmType(variable.getTypeDescriptor()) + ")");
        }
        if (WasmConstructsGenerator.isReceiverCastNeeded(methodDescriptor)) {
            this.builder.newLine();
            this.builder.append(String.format("(local $this %s)", this.environment.getWasmType((TypeDescriptor)enclosingTypeDescriptor)));
            this.builder.newLine();
            this.builder.append(String.format("(local.set $this (ref.cast (ref %s) (local.get $this.untyped)))", this.environment.getWasmTypeName((TypeDescriptor)enclosingTypeDescriptor)));
        }
        StatementTranspiler.render((Statement)method.getBody(), this.builder, this.environment);
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
        if (methodDescriptor.isPolymorphic()) {
            this.builder.newLine();
            this.builder.append(String.format("(elem declare func %s)", this.environment.getMethodImplementationName(method.getDescriptor())));
        }
    }

    private static boolean isReceiverCastNeeded(MethodDescriptor methodDescriptor) {
        return methodDescriptor.isPolymorphic() && !methodDescriptor.isNative() && !methodDescriptor.isJsOverlay() && !methodDescriptor.isDefaultMethod();
    }

    private static List<Variable> collectLocals(Method method) {
        final ArrayList<Variable> locals = new ArrayList<Variable>();
        method.getBody().accept((Processor)new AbstractVisitor(){

            public void exitVariable(Variable variable) {
                locals.add(variable);
            }
        });
        return locals;
    }

    private void renderTypeStruct(Type type) {
        this.emitWasmStruct(type, this.environment::getWasmTypeName, () -> this.renderTypeFields(type));
    }

    private void renderTypeFields(Type type) {
        this.builder.newLine();
        this.builder.append(String.format("(field $vtable (ref %s))", this.environment.getWasmVtableTypeName(type.getTypeDescriptor())));
        this.builder.newLine();
        this.builder.append(String.format("(field $itable (ref %s))", this.environment.getWasmItableTypeName(type.getDeclaration())));
        WasmTypeLayout wasmType = this.environment.getWasmTypeLayout(type.getDeclaration());
        for (FieldDescriptor fieldDescriptor : wasmType.getAllInstanceFields()) {
            this.builder.newLine();
            String fieldType = this.environment.getWasmFieldType(fieldDescriptor.getTypeDescriptor());
            if (!this.environment.isWasmArrayElementsField(fieldDescriptor)) {
                fieldType = String.format("(mut %s)", fieldType);
            }
            this.builder.append(String.format("(field %s %s)", this.environment.getFieldName(fieldDescriptor), fieldType));
        }
    }

    void emitDispatchTablesInitialization(Library library) {
        this.builder.newLine();
        this.builder.append(";;; Initialize dynamic dispatch tables.");
        this.emitEmptyItableGlobal();
        this.emitClassDispatchTables(library, true);
    }

    public void emitEmptyItableGlobal() {
        this.builder.newLine();
        this.builder.append("(global $itable.empty (ref $itable)");
        this.builder.indent();
        this.builder.newLine();
        this.builder.append("(struct.new_default $itable)");
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
    }

    void emitClassDispatchTables(Library library, boolean emitItableInitialization) {
        library.streamTypes().filter(Predicates.not(Type::isInterface)).filter(Predicates.not(Type::isNative)).map(Type::getDeclaration).filter((Predicate<TypeDeclaration>)Predicates.not(TypeDeclaration::isAbstract)).filter(type -> type.getWasmInfo() == null).forEach(t -> {
            this.emitVtablesInitialization((TypeDeclaration)t);
            if (emitItableInitialization) {
                this.emitItableInitialization((TypeDeclaration)t);
            }
        });
        this.builder.newLine();
    }

    private void emitVtablesInitialization(TypeDeclaration typeDeclaration) {
        WasmTypeLayout wasmTypeLayout = this.environment.getWasmTypeLayout(typeDeclaration);
        this.emitBeginCodeComment(typeDeclaration, "vtable.init");
        this.builder.newLine();
        this.builder.append(String.format("(global %s (ref %s)", this.environment.getWasmVtableGlobalName(typeDeclaration), this.environment.getWasmVtableTypeName(typeDeclaration)));
        this.builder.indent();
        this.emitVtableInitialization(typeDeclaration, wasmTypeLayout.getAllPolymorphicMethods());
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
        HashSet emittedInterfaces = new HashSet();
        typeDeclaration.getAllSuperInterfaces().stream().sorted(Comparator.comparing(TypeDeclaration::getTypeHierarchyDepth).reversed()).forEach(i -> {
            if (!emittedInterfaces.add(i)) {
                return;
            }
            this.builder.newLine();
            this.builder.append(String.format("(global %s (ref %s)", this.environment.getWasmInterfaceVtableGlobalName((TypeDeclaration)i, typeDeclaration), this.environment.getWasmVtableTypeName((TypeDeclaration)i)));
            this.builder.indent();
            WasmTypeLayout interfaceTypeLayout = this.environment.getWasmTypeLayout((TypeDeclaration)i);
            this.initializeInterfaceVtable(wasmTypeLayout, interfaceTypeLayout);
            this.builder.unindent();
            this.builder.newLine();
            this.builder.append(")");
            this.initializeSuperInterfaceVtables(wasmTypeLayout, interfaceTypeLayout, emittedInterfaces);
        });
        this.emitEndCodeComment(typeDeclaration, "vtable.init");
    }

    private void initializeInterfaceVtable(WasmTypeLayout wasmTypeLayout, WasmTypeLayout interfaceTypeLayout) {
        ImmutableList interfaceMethodImplementations = (ImmutableList)interfaceTypeLayout.getAllPolymorphicMethodsByMangledName().values().stream().map(wasmTypeLayout::getImplementationMethod).collect(ImmutableList.toImmutableList());
        this.emitVtableInitialization(interfaceTypeLayout.getTypeDeclaration(), (Collection<MethodDescriptor>)interfaceMethodImplementations);
    }

    private void initializeSuperInterfaceVtables(WasmTypeLayout wasmTypeLayout, WasmTypeLayout interfaceTypeLayout, Set<TypeDeclaration> alreadyEmittedInterfaces) {
        for (WasmTypeLayout superInterfaceTypeLayout = interfaceTypeLayout.getWasmSupertypeLayout(); superInterfaceTypeLayout != null && alreadyEmittedInterfaces.add(superInterfaceTypeLayout.getTypeDeclaration()); superInterfaceTypeLayout = superInterfaceTypeLayout.getWasmSupertypeLayout()) {
            this.builder.newLine();
            this.builder.append(String.format("(global %s (ref %s) (global.get %s))", this.environment.getWasmInterfaceVtableGlobalName(superInterfaceTypeLayout.getTypeDeclaration(), wasmTypeLayout.getTypeDeclaration()), this.environment.getWasmVtableTypeName(interfaceTypeLayout.getTypeDeclaration()), this.environment.getWasmInterfaceVtableGlobalName(interfaceTypeLayout.getTypeDeclaration(), wasmTypeLayout.getTypeDeclaration())));
        }
    }

    private void emitVtableInitialization(TypeDeclaration implementedType, Collection<MethodDescriptor> methodDescriptors) {
        this.builder.newLine();
        this.builder.append(String.format("(struct.new %s", this.environment.getWasmVtableTypeName(implementedType)));
        this.builder.indent();
        methodDescriptors.forEach(m -> {
            this.builder.newLine();
            this.builder.append(String.format("(ref.func %s)", this.environment.getMethodImplementationName((MethodDescriptor)m)));
        });
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
    }

    private void emitItableInitialization(TypeDeclaration typeDeclaration) {
        if (!typeDeclaration.implementsInterfaces()) {
            return;
        }
        this.emitBeginCodeComment(typeDeclaration, "itable.init");
        TypeDeclaration[] interfacesByItableIndex = this.getInterfacesByItableIndex(typeDeclaration);
        this.builder.newLine();
        this.builder.append(String.format("(global %s (ref %s)", this.environment.getWasmItableGlobalName(typeDeclaration), this.environment.getWasmItableTypeName(typeDeclaration)));
        this.builder.indent();
        this.builder.newLine();
        this.builder.append(String.format("(struct.new %s", this.environment.getWasmItableTypeName(typeDeclaration)));
        this.builder.indent();
        Arrays.stream(interfacesByItableIndex).forEach(i -> {
            this.builder.newLine();
            if (i == null) {
                this.builder.append(" (ref.null struct)");
                return;
            }
            this.builder.append(String.format(" (global.get %s)", this.environment.getWasmInterfaceVtableGlobalName((TypeDeclaration)i, typeDeclaration)));
        });
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
        this.emitEndCodeComment(typeDeclaration, "itable.init");
    }

    private TypeDeclaration[] getInterfacesByItableIndex(TypeDeclaration typeDeclaration) {
        Set superInterfaces = typeDeclaration.getAllSuperInterfaces();
        int numSlots = this.environment.getItableSize();
        TypeDeclaration[] interfacesByItableIndex = new TypeDeclaration[numSlots];
        for (TypeDeclaration superInterface : superInterfaces) {
            int itableIndex = this.environment.getItableIndexForInterface(superInterface);
            if (interfacesByItableIndex[itableIndex] != null && !superInterface.getAllSuperInterfaces().contains(interfacesByItableIndex[itableIndex])) continue;
            interfacesByItableIndex[itableIndex] = superInterface;
        }
        return interfacesByItableIndex;
    }

    private void emitItableType(TypeDeclaration typeDeclaration, TypeDeclaration[] interfacesByItableIndex) {
        this.builder.newLine();
        this.builder.append(String.format("(type %s (sub %s (struct", this.environment.getWasmItableTypeName(typeDeclaration), this.environment.getWasmItableTypeName(typeDeclaration.getSuperTypeDeclaration())));
        this.builder.indent();
        for (int index = 0; index < this.environment.getItableSize(); ++index) {
            this.builder.newLine();
            if (interfacesByItableIndex[index] == null) {
                this.builder.append("(field (ref null struct))");
                continue;
            }
            this.builder.append(String.format("(field (ref %s))", this.environment.getWasmVtableTypeName(interfacesByItableIndex[index])));
        }
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")))");
    }

    public void emitItableInterfaceGetters(Library library) {
        library.streamTypes().filter(Type::isInterface).map(Type::getDeclaration).forEach(this::emitItableInterfaceGetter);
    }

    private void emitItableInterfaceGetter(TypeDeclaration typeDeclaration) {
        int fieldIndex = this.environment.getItableIndexForInterface(typeDeclaration);
        this.emitItableInterfaceGetter(this.environment.getWasmItableInterfaceGetter(typeDeclaration), fieldIndex == -1 ? null : String.valueOf(fieldIndex));
    }

    public void emitItableInterfaceGetter(String methodName, String fieldName) {
        this.builder.newLine();
        this.builder.append(String.format("(func %s (param $object (ref null $java.lang.Object)) (result (ref null struct)) ", methodName));
        this.builder.indent();
        this.builder.newLine();
        if (fieldName == null) {
            this.builder.append("(ref.null struct)");
        } else {
            this.builder.append(String.format("(struct.get $itable %s (struct.get $java.lang.Object $itable (local.get $object)))", fieldName));
        }
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
    }

    private void emitWasmStruct(Type type, Function<DeclaredTypeDescriptor, String> structNamer, Runnable fieldsRenderer) {
        WasmTypeLayout wasmType = this.environment.getWasmTypeLayout(type.getDeclaration());
        boolean hasSuperType = wasmType.getWasmSupertypeLayout() != null;
        this.builder.newLine();
        this.builder.append(String.format("(type %s (sub ", structNamer.apply(type.getTypeDescriptor())));
        if (hasSuperType) {
            this.builder.append(String.format("%s ", structNamer.apply(wasmType.getWasmSupertypeLayout().getTypeDescriptor())));
        }
        this.builder.append("(struct");
        this.builder.indent();
        fieldsRenderer.run();
        this.builder.newLine();
        this.builder.append(")");
        this.builder.append(")");
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
    }

    void emitNativeArrayTypes(List<ArrayTypeDescriptor> arrayTypes) {
        this.emitBeginCodeComment("Native Array types");
        arrayTypes.forEach(this::emitNativeArrayType);
        this.emitEndCodeComment("Native Array types");
    }

    void emitNativeArrayType(ArrayTypeDescriptor arrayTypeDescriptor) {
        String wasmArrayTypeName = this.environment.getWasmTypeName((TypeDescriptor)arrayTypeDescriptor);
        this.builder.newLine();
        this.builder.append(String.format("(type %s (array (mut %s)))", wasmArrayTypeName, this.environment.getWasmFieldType(arrayTypeDescriptor.getComponentTypeDescriptor())));
    }

    void emitEmptyArraySingletons(List<ArrayTypeDescriptor> arrayTypes) {
        this.emitBeginCodeComment("Empty array singletons");
        arrayTypes.forEach(this::emitEmptyArraySingleton);
        this.emitEndCodeComment("Empty array singletons");
    }

    void emitEmptyArraySingleton(ArrayTypeDescriptor arrayTypeDescriptor) {
        String wasmArrayTypeName = this.environment.getWasmTypeName((TypeDescriptor)arrayTypeDescriptor);
        this.builder.newLine();
        this.builder.append(String.format("(global %s (ref %s)", this.environment.getWasmEmptyArrayGlobalName(arrayTypeDescriptor), wasmArrayTypeName));
        this.builder.indent();
        this.builder.newLine();
        this.builder.append(String.format("(array.new_default %s (i32.const 0))", wasmArrayTypeName));
        this.builder.unindent();
        this.builder.newLine();
        this.builder.append(")");
        this.builder.newLine();
    }

    void emitForEachType(Library library, Consumer<Type> emitter, String comment) {
        library.streamTypes().sorted(Comparator.comparing(t -> t.getDeclaration().getTypeHierarchyDepth())).forEach(type -> {
            this.emitBeginCodeComment((Type)type, comment);
            emitter.accept((Type)type);
            this.emitEndCodeComment((Type)type, comment);
        });
    }

    private void emitBeginCodeComment(Type type, String section) {
        this.emitBeginCodeComment(type.getDeclaration(), section);
    }

    private void emitBeginCodeComment(TypeDeclaration typeDeclaration, String section) {
        this.emitBeginCodeComment(String.format("%s [%s]", typeDeclaration.getQualifiedSourceName(), section));
    }

    private void emitBeginCodeComment(String commentId) {
        this.builder.newLine();
        this.builder.append(";;; Code for " + commentId);
    }

    private void emitEndCodeComment(Type type, String section) {
        this.emitEndCodeComment(type.getDeclaration(), section);
    }

    private void emitEndCodeComment(TypeDeclaration typeDeclaration, String section) {
        this.emitEndCodeComment(String.format("%s [%s]", typeDeclaration.getQualifiedSourceName(), section));
    }

    private void emitEndCodeComment(String commentId) {
        this.builder.newLine();
        this.builder.append(";;; End of code for " + commentId);
    }
}

