/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.backend;

import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.OutputUtils;
import com.google.j2cl.common.Problems;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.backend.BackendOptions;
import com.google.j2cl.transpiler.backend.closure.OutputGeneratorStage;
import com.google.j2cl.transpiler.backend.kotlin.KotlinGeneratorStage;
import com.google.j2cl.transpiler.backend.wasm.WasmGeneratorStage;
import com.google.j2cl.transpiler.passes.AddAbstractMethodStubs;
import com.google.j2cl.transpiler.passes.AddBridgeMethods;
import com.google.j2cl.transpiler.passes.AddDisambiguatingOverloadResolutionCastsJ2kt;
import com.google.j2cl.transpiler.passes.AddDisambiguatingSuperMethodForwardingStubs;
import com.google.j2cl.transpiler.passes.AddEntryPointBridgesWasm;
import com.google.j2cl.transpiler.passes.AddEnumImplicitMethods;
import com.google.j2cl.transpiler.passes.AddJavaLangObjectForwardingMethods;
import com.google.j2cl.transpiler.passes.AddNothingReturnStatements;
import com.google.j2cl.transpiler.passes.AddVisibilityMethodBridgesJ2kt;
import com.google.j2cl.transpiler.passes.ConvertMethodReferencesToLambdas;
import com.google.j2cl.transpiler.passes.CreateImplicitConstructors;
import com.google.j2cl.transpiler.passes.DevirtualizeBoxedTypesAndJsFunctionImplementations;
import com.google.j2cl.transpiler.passes.DevirtualizeMethodCalls;
import com.google.j2cl.transpiler.passes.ErasePackagedJsEnumVarargs;
import com.google.j2cl.transpiler.passes.ExpandCompoundAssignments;
import com.google.j2cl.transpiler.passes.ExtractNonIdempotentExpressions;
import com.google.j2cl.transpiler.passes.FilloutMissingSourceMapInformation;
import com.google.j2cl.transpiler.passes.ImplementArraysAsClasses;
import com.google.j2cl.transpiler.passes.ImplementAssertStatements;
import com.google.j2cl.transpiler.passes.ImplementBitLevelOperatorsJ2kt;
import com.google.j2cl.transpiler.passes.ImplementClassMetadataViaConstructors;
import com.google.j2cl.transpiler.passes.ImplementClassMetadataViaGetters;
import com.google.j2cl.transpiler.passes.ImplementDivisionOperations;
import com.google.j2cl.transpiler.passes.ImplementFinallyViaControlFlow;
import com.google.j2cl.transpiler.passes.ImplementFloatingPointRemainderOperation;
import com.google.j2cl.transpiler.passes.ImplementInstanceInitialization;
import com.google.j2cl.transpiler.passes.ImplementInstanceOfs;
import com.google.j2cl.transpiler.passes.ImplementJsFunctionCopyMethod;
import com.google.j2cl.transpiler.passes.ImplementLambdaExpressionsViaImplementorClasses;
import com.google.j2cl.transpiler.passes.ImplementLambdaExpressionsViaJsFunctionAdaptor;
import com.google.j2cl.transpiler.passes.ImplementNotNullOperator;
import com.google.j2cl.transpiler.passes.ImplementStaticInitializationViaClinitFunctionRedirection;
import com.google.j2cl.transpiler.passes.ImplementStaticInitializationViaConditionChecks;
import com.google.j2cl.transpiler.passes.ImplementStringCompileTimeConstants;
import com.google.j2cl.transpiler.passes.ImplementStringConcatenation;
import com.google.j2cl.transpiler.passes.ImplementSynchronizedStatements;
import com.google.j2cl.transpiler.passes.ImplementSystemGetProperty;
import com.google.j2cl.transpiler.passes.InsertBitwiseOperatorBooleanCoercions;
import com.google.j2cl.transpiler.passes.InsertBoxingConversions;
import com.google.j2cl.transpiler.passes.InsertCastForLowerBounds;
import com.google.j2cl.transpiler.passes.InsertCastOnArrayAccess;
import com.google.j2cl.transpiler.passes.InsertCastOnNewInstances;
import com.google.j2cl.transpiler.passes.InsertCastsForBoxedTypes;
import com.google.j2cl.transpiler.passes.InsertCastsOnNullabilityMismatch;
import com.google.j2cl.transpiler.passes.InsertErasureTypeSafetyCasts;
import com.google.j2cl.transpiler.passes.InsertExceptionConversions;
import com.google.j2cl.transpiler.passes.InsertExceptionConversionsWasm;
import com.google.j2cl.transpiler.passes.InsertExplicitArrayCoercionCasts;
import com.google.j2cl.transpiler.passes.InsertExplicitSuperCalls;
import com.google.j2cl.transpiler.passes.InsertExternConversionsWasm;
import com.google.j2cl.transpiler.passes.InsertIntegerCoercions;
import com.google.j2cl.transpiler.passes.InsertJsDocCastsToTypeBounds;
import com.google.j2cl.transpiler.passes.InsertJsEnumBoxingAndUnboxingConversions;
import com.google.j2cl.transpiler.passes.InsertJsFunctionImplementationConversionCasts;
import com.google.j2cl.transpiler.passes.InsertNarrowingPrimitiveConversions;
import com.google.j2cl.transpiler.passes.InsertNarrowingPrimitiveConversionsJ2kt;
import com.google.j2cl.transpiler.passes.InsertNarrowingReferenceConversions;
import com.google.j2cl.transpiler.passes.InsertNotNullAssertions;
import com.google.j2cl.transpiler.passes.InsertQualifierProjectionCasts;
import com.google.j2cl.transpiler.passes.InsertRawTypeCasts;
import com.google.j2cl.transpiler.passes.InsertStringConversions;
import com.google.j2cl.transpiler.passes.InsertStringConversionsJ2kt;
import com.google.j2cl.transpiler.passes.InsertTypeAnnotationOnGenericReturnTypes;
import com.google.j2cl.transpiler.passes.InsertUnboxingConversions;
import com.google.j2cl.transpiler.passes.InsertWideningPrimitiveConversions;
import com.google.j2cl.transpiler.passes.InsertWideningPrimitiveConversionsJ2kt;
import com.google.j2cl.transpiler.passes.J2ktRestrictionsChecker;
import com.google.j2cl.transpiler.passes.JsInteropRestrictionsChecker;
import com.google.j2cl.transpiler.passes.MakeVariablesFinal;
import com.google.j2cl.transpiler.passes.MoveNestedClassesToTop;
import com.google.j2cl.transpiler.passes.MoveVariableDeclarationsToEnclosingBlock;
import com.google.j2cl.transpiler.passes.NormalizationPass;
import com.google.j2cl.transpiler.passes.NormalizeArrayAccesses;
import com.google.j2cl.transpiler.passes.NormalizeArrayCreations;
import com.google.j2cl.transpiler.passes.NormalizeArrayCreationsJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeArrayCreationsWasm;
import com.google.j2cl.transpiler.passes.NormalizeArrayLiterals;
import com.google.j2cl.transpiler.passes.NormalizeCasts;
import com.google.j2cl.transpiler.passes.NormalizeCatchClauses;
import com.google.j2cl.transpiler.passes.NormalizeConstructors;
import com.google.j2cl.transpiler.passes.NormalizeControlStatements;
import com.google.j2cl.transpiler.passes.NormalizeEnumClasses;
import com.google.j2cl.transpiler.passes.NormalizeEquality;
import com.google.j2cl.transpiler.passes.NormalizeFieldInitialization;
import com.google.j2cl.transpiler.passes.NormalizeFieldInitializationJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeForEachIterable;
import com.google.j2cl.transpiler.passes.NormalizeForEachStatement;
import com.google.j2cl.transpiler.passes.NormalizeForEachStatementJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeForStatements;
import com.google.j2cl.transpiler.passes.NormalizeFunctionExpressions;
import com.google.j2cl.transpiler.passes.NormalizeInstanceCompileTimeConstants;
import com.google.j2cl.transpiler.passes.NormalizeInstanceOfs;
import com.google.j2cl.transpiler.passes.NormalizeInstantiationThroughFactoryMethods;
import com.google.j2cl.transpiler.passes.NormalizeInterfaceMethods;
import com.google.j2cl.transpiler.passes.NormalizeInterfaces;
import com.google.j2cl.transpiler.passes.NormalizeJsAwaitMethodInvocations;
import com.google.j2cl.transpiler.passes.NormalizeJsDocCastExpressions;
import com.google.j2cl.transpiler.passes.NormalizeJsEnumInstanceOfAndCasts;
import com.google.j2cl.transpiler.passes.NormalizeJsEnums;
import com.google.j2cl.transpiler.passes.NormalizeJsFunctionPropertyInvocations;
import com.google.j2cl.transpiler.passes.NormalizeJsVarargs;
import com.google.j2cl.transpiler.passes.NormalizeLabeledStatements;
import com.google.j2cl.transpiler.passes.NormalizeLabels;
import com.google.j2cl.transpiler.passes.NormalizeLambdaExpressionsJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeLiterals;
import com.google.j2cl.transpiler.passes.NormalizeLongs;
import com.google.j2cl.transpiler.passes.NormalizeMethodParametersJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeMinValueIntegralLiterals;
import com.google.j2cl.transpiler.passes.NormalizeMultiExpressions;
import com.google.j2cl.transpiler.passes.NormalizeNativePropertyAccesses;
import com.google.j2cl.transpiler.passes.NormalizeNullLiterals;
import com.google.j2cl.transpiler.passes.NormalizeNumberLiterals;
import com.google.j2cl.transpiler.passes.NormalizeOverlayMembers;
import com.google.j2cl.transpiler.passes.NormalizePrimitiveCastsJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeShifts;
import com.google.j2cl.transpiler.passes.NormalizeStaticMemberQualifiers;
import com.google.j2cl.transpiler.passes.NormalizeStaticNativeMemberReferences;
import com.google.j2cl.transpiler.passes.NormalizeSuperMemberReferences;
import com.google.j2cl.transpiler.passes.NormalizeSwitchStatements;
import com.google.j2cl.transpiler.passes.NormalizeSwitchStatementsJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeSynchronizedMethods;
import com.google.j2cl.transpiler.passes.NormalizeSystemGetPropertyCalls;
import com.google.j2cl.transpiler.passes.NormalizeTryWithResources;
import com.google.j2cl.transpiler.passes.NormalizeVarargInvocationsJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeVarargParametersJ2kt;
import com.google.j2cl.transpiler.passes.NormalizeVariableInitialization;
import com.google.j2cl.transpiler.passes.OptimizeAnonymousInnerClassesToFunctionExpressions;
import com.google.j2cl.transpiler.passes.OptimizeAutoValue;
import com.google.j2cl.transpiler.passes.OptimizeEnums;
import com.google.j2cl.transpiler.passes.OptimizeImplicitConstructors;
import com.google.j2cl.transpiler.passes.OptimizeImplicitSuperCalls;
import com.google.j2cl.transpiler.passes.OptimizeKotlinCompanions;
import com.google.j2cl.transpiler.passes.OptimizeXplatForEach;
import com.google.j2cl.transpiler.passes.PropagateCompileTimeConstants;
import com.google.j2cl.transpiler.passes.PropagateConstants;
import com.google.j2cl.transpiler.passes.PropagateJsEnumConstants;
import com.google.j2cl.transpiler.passes.PropagateNullabilityJ2kt;
import com.google.j2cl.transpiler.passes.RecoverShortcutBooleanOperator;
import com.google.j2cl.transpiler.passes.RemoveCustomIsInstanceMethods;
import com.google.j2cl.transpiler.passes.RemoveNativeTypes;
import com.google.j2cl.transpiler.passes.RemoveNestedBlocks;
import com.google.j2cl.transpiler.passes.RemoveNoopStatements;
import com.google.j2cl.transpiler.passes.RemoveUnnecessaryLabels;
import com.google.j2cl.transpiler.passes.RemoveUnneededCasts;
import com.google.j2cl.transpiler.passes.RemoveUnneededJsDocCasts;
import com.google.j2cl.transpiler.passes.RemoveUnneededNotNullChecks;
import com.google.j2cl.transpiler.passes.RemoveUnreachableCode;
import com.google.j2cl.transpiler.passes.RemoveWasmAnnotatedMethodBodies;
import com.google.j2cl.transpiler.passes.ResolveCaptures;
import com.google.j2cl.transpiler.passes.ResolveImplicitInstanceQualifiers;
import com.google.j2cl.transpiler.passes.ResolveImplicitStaticQualifiers;
import com.google.j2cl.transpiler.passes.RestoreVariableScoping;
import com.google.j2cl.transpiler.passes.RewriteAssignmentExpressions;
import com.google.j2cl.transpiler.passes.RewriteJsEnumNullChecks;
import com.google.j2cl.transpiler.passes.RewriteReferenceEqualityOperations;
import com.google.j2cl.transpiler.passes.RewriteShortcutOperators;
import com.google.j2cl.transpiler.passes.RewriteUnaryExpressions;
import com.google.j2cl.transpiler.passes.StaticallyEvaluateStringComparison;
import com.google.j2cl.transpiler.passes.StaticallyEvaluateStringConcatenation;
import com.google.j2cl.transpiler.passes.VerifyNormalizedUnits;
import com.google.j2cl.transpiler.passes.VerifyParamAndArgCounts;
import com.google.j2cl.transpiler.passes.VerifyReferenceScoping;
import com.google.j2cl.transpiler.passes.VerifySingleAstReference;
import java.nio.file.Path;
import java.util.function.Supplier;

public enum Backend {
    CLOSURE{

        @Override
        public void generateOutputs(BackendOptions options, Library library, Problems problems) {
            new OutputGeneratorStage(options.getNativeSources(), options.getOutput(), options.getLibraryInfoOutput(), options.getEmitReadableLibraryInfo(), options.getEmitReadableSourceMap(), options.getGenerateKytheIndexingMetadata(), problems).generateOutputs(library);
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getDesugaringPassFactories() {
            return ImmutableList.of(MakeVariablesFinal::new, ConvertMethodReferencesToLambdas::new, ErasePackagedJsEnumVarargs::new, ResolveImplicitInstanceQualifiers::new, OptimizeXplatForEach::new, NormalizeForEachIterable::new, () -> new NormalizeForEachStatement(true), RestoreVariableScoping::new, NormalizeSuperMemberReferences::new, RecoverShortcutBooleanOperator::new);
        }

        @Override
        public void checkRestrictions(BackendOptions options, Library library, Problems problems) {
            JsInteropRestrictionsChecker.check((Library)library, (Problems)problems, (boolean)false, (boolean)options.isNullMarkedSupported(), (boolean)options.getOptimizeAutoValue());
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getPassFactories(BackendOptions options) {
            return ImmutableList.of(VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new, OptimizeAnonymousInnerClassesToFunctionExpressions::new, ImplementLambdaExpressionsViaJsFunctionAdaptor::new, NormalizeFunctionExpressions::new, AddBridgeMethods::new, () -> new OptimizeAutoValue(options.getOptimizeAutoValue()), OptimizeKotlinCompanions::new, CreateImplicitConstructors::new, InsertExplicitSuperCalls::new, ResolveCaptures::new, (Object[])new Supplier[]{MoveNestedClassesToTop::new, OptimizeEnums::new, AddEnumImplicitMethods::new, DevirtualizeBoxedTypesAndJsFunctionImplementations::new, NormalizeTryWithResources::new, NormalizeCatchClauses::new, InsertCastOnNewInstances::new, NormalizeEnumClasses::new, NormalizeJsEnums::new, NormalizeOverlayMembers::new, RemoveNativeTypes::new, NormalizeInterfaceMethods::new, NormalizeArrayLiterals::new, NormalizeShifts::new, NormalizeStaticMemberQualifiers::new, DevirtualizeMethodCalls::new, NormalizeControlStatements::new, NormalizeMultiExpressions::new, ExpandCompoundAssignments::new, InsertErasureTypeSafetyCasts::new, InsertStringConversions::new, InsertNarrowingReferenceConversions::new, InsertUnboxingConversions::new, () -> new InsertBoxingConversions(false), InsertNarrowingPrimitiveConversions::new, InsertWideningPrimitiveConversions::new, NormalizeLongs::new, InsertIntegerCoercions::new, InsertBitwiseOperatorBooleanCoercions::new, NormalizeJsFunctionPropertyInvocations::new, InsertJsEnumBoxingAndUnboxingConversions::new, RemoveUnneededCasts::new, NormalizeSwitchStatements::new, NormalizeArrayAccesses::new, ImplementAssertStatements::new, ImplementSynchronizedStatements::new, NormalizeFieldInitialization::new, ImplementInstanceInitialization::new, NormalizeConstructors::new, NormalizeCasts::new, NormalizeInstanceOfs::new, NormalizeEquality::new, NormalizeStaticNativeMemberReferences::new, InsertJsFunctionImplementationConversionCasts::new, InsertJsDocCastsToTypeBounds::new, NormalizeJsVarargs::new, NormalizeArrayCreations::new, InsertExceptionConversions::new, NormalizeLiterals::new, InsertTypeAnnotationOnGenericReturnTypes::new, ImplementStaticInitializationViaClinitFunctionRedirection::new, ImplementInstanceOfs::new, ImplementJsFunctionCopyMethod::new, ImplementClassMetadataViaConstructors::new, NormalizeMultiExpressions::new, MoveVariableDeclarationsToEnclosingBlock::new, RemoveUnneededJsDocCasts::new, NormalizeJsDocCastExpressions::new, NormalizeJsAwaitMethodInvocations::new, RemoveUnneededNotNullChecks::new, ImplementNotNullOperator::new, NormalizeLabels::new, RemoveUnnecessaryLabels::new, RemoveUnreachableCode::new, RemoveNoopStatements::new, ResolveImplicitStaticQualifiers::new, AddAbstractMethodStubs::new, AddNothingReturnStatements::new, FilloutMissingSourceMapInformation::new, VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new, VerifyNormalizedUnits::new});
        }
    }
    ,
    WASM{

        @Override
        public void generateOutputs(BackendOptions options, Library library, Problems problems) {
            WasmGeneratorStage.generateMonolithicOutput((Library)library, (OutputUtils.Output)options.getOutput(), (Path)options.getLibraryInfoOutput(), (Problems)problems);
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getDesugaringPassFactories() {
            return ImmutableList.of(MakeVariablesFinal::new, ConvertMethodReferencesToLambdas::new, ErasePackagedJsEnumVarargs::new, ResolveImplicitInstanceQualifiers::new, NormalizeForEachIterable::new, () -> new NormalizeForEachStatement(false), NormalizeSuperMemberReferences::new, RemoveWasmAnnotatedMethodBodies::new);
        }

        @Override
        public void checkRestrictions(BackendOptions options, Library library, Problems problems) {
            JsInteropRestrictionsChecker.check((Library)library, (Problems)problems, (boolean)true, (boolean)options.isNullMarkedSupported(), (boolean)options.getOptimizeAutoValue());
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getPassFactories(BackendOptions options) {
            return ImmutableList.of(VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new, ImplementLambdaExpressionsViaImplementorClasses::new, CreateImplicitConstructors::new, InsertExplicitSuperCalls::new, ResolveCaptures::new, MoveNestedClassesToTop::new, AddBridgeMethods::new, AddEnumImplicitMethods::new, NormalizeTryWithResources::new, NormalizeCatchClauses::new, (Object[])new Supplier[]{() -> new NormalizeEnumClasses(false), NormalizeJsEnums::new, NormalizeOverlayMembers::new, NormalizeInstanceCompileTimeConstants::new, () -> new NormalizeShifts(false), NormalizeStaticMemberQualifiers::new, NormalizeMultiExpressions::new, () -> new ImplementAssertStatements(true), () -> new ImplementSystemGetProperty(options.getDefinesForWasm()), () -> new ExpandCompoundAssignments(true), InsertErasureTypeSafetyCasts::new, RewriteUnaryExpressions::new, NormalizeSwitchStatements::new, PropagateConstants::new, StaticallyEvaluateStringConcatenation::new, StaticallyEvaluateStringComparison::new, () -> new InsertStringConversions(false), ImplementStringConcatenation::new, InsertJsEnumBoxingAndUnboxingConversions::new, PropagateJsEnumConstants::new, InsertNarrowingReferenceConversions::new, () -> new InsertUnboxingConversions(true), () -> new InsertBoxingConversions(true), () -> new InsertNarrowingPrimitiveConversions(false), () -> new InsertWideningPrimitiveConversions(true), NormalizeJsEnumInstanceOfAndCasts::new, RewriteReferenceEqualityOperations::new, RewriteJsEnumNullChecks::new, ImplementDivisionOperations::new, ImplementFloatingPointRemainderOperation::new, RewriteShortcutOperators::new, NormalizeFieldInitialization::new, ImplementInstanceInitialization::new, NormalizeLabels::new, NormalizeInstantiationThroughFactoryMethods::new, ImplementStaticInitializationViaConditionChecks::new, ImplementClassMetadataViaGetters::new, ImplementStringCompileTimeConstants::new, NormalizeArrayCreationsWasm::new, InsertCastOnArrayAccess::new, NormalizeMultiExpressions::new, RewriteAssignmentExpressions::new, NormalizeNativePropertyAccesses::new, ExtractNonIdempotentExpressions::new, NormalizeMultiExpressions::new, () -> new AddEntryPointBridgesWasm(options.getWasmEntryPointPatterns()), ImplementFinallyViaControlFlow::new, ImplementArraysAsClasses::new, InsertExceptionConversions::new, InsertExceptionConversionsWasm::new, InsertExternConversionsWasm::new, RemoveCustomIsInstanceMethods::new, RemoveNoopStatements::new, NormalizeNullLiterals::new, RewriteReferenceEqualityOperations::new, VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new, () -> new VerifyNormalizedUnits(true)});
        }

        @Override
        public boolean isWasm() {
            return true;
        }
    }
    ,
    WASM_MODULAR{

        @Override
        public void generateOutputs(BackendOptions options, Library library, Problems problems) {
            WasmGeneratorStage.generateModularOutput((Library)library, (OutputUtils.Output)options.getOutput(), (Path)options.getLibraryInfoOutput(), (Problems)problems);
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getDesugaringPassFactories() {
            return ImmutableList.of(MakeVariablesFinal::new, ConvertMethodReferencesToLambdas::new, ErasePackagedJsEnumVarargs::new, ResolveImplicitInstanceQualifiers::new, NormalizeForEachIterable::new, () -> new NormalizeForEachStatement(false), NormalizeSuperMemberReferences::new, RemoveWasmAnnotatedMethodBodies::new);
        }

        @Override
        public void checkRestrictions(BackendOptions options, Library library, Problems problems) {
            JsInteropRestrictionsChecker.check((Library)library, (Problems)problems, (boolean)true, (boolean)options.isNullMarkedSupported(), (boolean)options.getOptimizeAutoValue());
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getPassFactories(BackendOptions options) {
            return ImmutableList.of(VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new, ImplementLambdaExpressionsViaImplementorClasses::new, CreateImplicitConstructors::new, InsertExplicitSuperCalls::new, ResolveCaptures::new, MoveNestedClassesToTop::new, AddBridgeMethods::new, AddEnumImplicitMethods::new, NormalizeSystemGetPropertyCalls::new, NormalizeTryWithResources::new, (Object[])new Supplier[]{NormalizeCatchClauses::new, () -> new NormalizeEnumClasses(false), NormalizeJsEnums::new, NormalizeOverlayMembers::new, NormalizeInstanceCompileTimeConstants::new, () -> new NormalizeShifts(false), NormalizeStaticMemberQualifiers::new, NormalizeMultiExpressions::new, () -> new ExpandCompoundAssignments(true), InsertErasureTypeSafetyCasts::new, RewriteUnaryExpressions::new, NormalizeSwitchStatements::new, PropagateCompileTimeConstants::new, StaticallyEvaluateStringConcatenation::new, StaticallyEvaluateStringComparison::new, () -> new InsertStringConversions(false), ImplementStringConcatenation::new, InsertJsEnumBoxingAndUnboxingConversions::new, InsertNarrowingReferenceConversions::new, () -> new InsertUnboxingConversions(true), () -> new InsertBoxingConversions(true), () -> new InsertNarrowingPrimitiveConversions(false), () -> new InsertWideningPrimitiveConversions(true), NormalizeJsEnumInstanceOfAndCasts::new, RewriteReferenceEqualityOperations::new, RewriteJsEnumNullChecks::new, ImplementDivisionOperations::new, ImplementFloatingPointRemainderOperation::new, RewriteShortcutOperators::new, NormalizeFieldInitialization::new, ImplementInstanceInitialization::new, NormalizeLabels::new, NormalizeInstantiationThroughFactoryMethods::new, ImplementStaticInitializationViaConditionChecks::new, ImplementClassMetadataViaGetters::new, NormalizeArrayCreationsWasm::new, InsertCastOnArrayAccess::new, () -> new ImplementAssertStatements(true), NormalizeMultiExpressions::new, RewriteAssignmentExpressions::new, NormalizeNativePropertyAccesses::new, ExtractNonIdempotentExpressions::new, NormalizeMultiExpressions::new, ImplementFinallyViaControlFlow::new, ImplementArraysAsClasses::new, InsertExceptionConversions::new, InsertExceptionConversionsWasm::new, InsertExternConversionsWasm::new, RemoveCustomIsInstanceMethods::new, RemoveNoopStatements::new, NormalizeNullLiterals::new, RewriteReferenceEqualityOperations::new, VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new});
        }

        @Override
        public boolean isWasm() {
            return true;
        }
    }
    ,
    KOTLIN{

        @Override
        public void generateOutputs(BackendOptions options, Library library, Problems problems) {
            new KotlinGeneratorStage(new Object[]{options.getOutput(), problems}).generateOutputs(new Object[]{library});
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getDesugaringPassFactories() {
            return ImmutableList.of(MakeVariablesFinal::new, ConvertMethodReferencesToLambdas::new, ResolveImplicitInstanceQualifiers::new);
        }

        @Override
        public void checkRestrictions(BackendOptions options, Library library, Problems problems) {
            J2ktRestrictionsChecker.check((Library)library, (Problems)problems);
        }

        @Override
        public ImmutableList<Supplier<NormalizationPass>> getPassFactories(BackendOptions options) {
            return ImmutableList.of(VerifySingleAstReference::new, VerifyParamAndArgCounts::new, VerifyReferenceScoping::new, NormalizeMinValueIntegralLiterals::new, CreateImplicitConstructors::new, InsertExplicitSuperCalls::new, NormalizeLambdaExpressionsJ2kt::new, AddJavaLangObjectForwardingMethods::new, AddDisambiguatingSuperMethodForwardingStubs::new, AddDisambiguatingOverloadResolutionCastsJ2kt::new, AddVisibilityMethodBridgesJ2kt::new, NormalizeSynchronizedMethods::new, (Object[])new Supplier[]{PropagateNullabilityJ2kt::new, NormalizeInterfaces::new, NormalizeTryWithResources::new, NormalizeForEachIterable::new, NormalizeForEachStatementJ2kt::new, NormalizeStaticMemberQualifiers::new, () -> new MoveVariableDeclarationsToEnclosingBlock(true), NormalizeMultiExpressions::new, () -> new ExpandCompoundAssignments(true), RewriteAssignmentExpressions::new, () -> new InsertUnboxingConversions(true), () -> new InsertBoxingConversions(true), InsertWideningPrimitiveConversionsJ2kt::new, InsertNarrowingPrimitiveConversionsJ2kt::new, NormalizeVarargParametersJ2kt::new, NormalizeFieldInitializationJ2kt::new, NormalizeVariableInitialization::new, NormalizeLabels::new, NormalizeForStatements::new, NormalizeSwitchStatementsJ2kt::new, NormalizeLabeledStatements::new, () -> new NormalizeShifts(true), NormalizeNumberLiterals::new, NormalizePrimitiveCastsJ2kt::new, ImplementBitLevelOperatorsJ2kt::new, InsertQualifierProjectionCasts::new, InsertNotNullAssertions::new, InsertCastsOnNullabilityMismatch::new, InsertCastForLowerBounds::new, InsertRawTypeCasts::new, InsertCastsForBoxedTypes::new, InsertStringConversionsJ2kt::new, MakeVariablesFinal::new, NormalizeMethodParametersJ2kt::new, InsertExplicitArrayCoercionCasts::new, NormalizeMultiExpressions::new, RemoveNestedBlocks::new, RemoveNoopStatements::new, NormalizeVarargInvocationsJ2kt::new, NormalizeArrayCreationsJ2kt::new, OptimizeImplicitSuperCalls::new, OptimizeImplicitConstructors::new, VerifySingleAstReference::new, VerifyReferenceScoping::new});
        }
    };


    public abstract ImmutableList<Supplier<NormalizationPass>> getDesugaringPassFactories();

    public abstract ImmutableList<Supplier<NormalizationPass>> getPassFactories(BackendOptions var1);

    public void checkRestrictions(BackendOptions options, Library library, Problems problems) {
    }

    public abstract void generateOutputs(BackendOptions var1, Library var2, Problems var3);

    public boolean isWasm() {
        return false;
    }
}

