/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.j2cl.common.Problems;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public abstract class CommandLineTool {
    @Option(name="-help", usage="print this message")
    protected boolean help = false;
    private final String toolName;

    protected CommandLineTool(String toolName) {
        this.toolName = toolName;
    }

    protected abstract void run(Problems var1);

    protected Problems processRequest(String[] args) {
        String usage;
        CmdLineParser parser;
        Problems problems;
        block5: {
            problems = new Problems();
            parser = new CmdLineParser((Object)this);
            usage = "Usage: " + this.toolName + " <options> <source files>";
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                if (this.help) break block5;
                String message = "%s\n%s\nuse -help for a list of possible options";
                problems.error(message, e.getMessage(), usage);
                return problems;
            }
        }
        if (this.help) {
            String message = "%s\nwhere possible options include:\n%s";
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            parser.printUsage((OutputStream)new PrintStream(outputStream));
            problems.info(message, usage, new String(outputStream.toByteArray(), StandardCharsets.UTF_8));
            return problems;
        }
        try {
            this.run(problems);
        }
        catch (Problems.Exit exit) {
            // empty catch block
        }
        return problems;
    }

    protected final int execute(String[] args) {
        Problems problems = this.processRequest(args);
        return problems.reportAndGetExitCode(System.err);
    }
}

