/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.auto.value.AutoValue;
import com.google.j2cl.common.AutoValue_EntryPointPattern;
import java.util.regex.Pattern;

@AutoValue
public abstract class EntryPointPattern {
    private static final String QUALIFIED_NAME_VALIDATION_REGEX = "([\\w$_.]|(\\.\\*))+";
    private static final String METHOD_NAME_VALIDATION_REGEX = "([\\w$_]|(\\.\\*))+";

    public abstract String getEntryPointPatternString();

    public boolean matchesClass(String qualifiedClassName) {
        return this.getEnclosingClassPattern().matcher(qualifiedClassName).matches();
    }

    public boolean matchesMethod(String qualifiedClassName, String methodName) {
        return this.getEnclosingClassPattern().matcher(qualifiedClassName).matches() && this.getMethodPattern().matcher(methodName).matches();
    }

    public static EntryPointPattern from(String string) {
        return new AutoValue_EntryPointPattern(string);
    }

    public boolean isValid() {
        return this.getEntryPointPatternString().matches("([\\w$_.]|(\\.\\*))+#([\\w$_]|(\\.\\*))+");
    }

    Pattern getEnclosingClassPattern() {
        String entryPointClassString = this.getEntryPointPatternString().substring(0, this.getEntryPointPatternString().lastIndexOf(35));
        return EntryPointPattern.getEntryPointAsPattern(entryPointClassString);
    }

    Pattern getMethodPattern() {
        String entryPointMethodString = this.getEntryPointPatternString().substring(this.getEntryPointPatternString().lastIndexOf(35) + 1);
        return EntryPointPattern.getEntryPointAsPattern(entryPointMethodString);
    }

    private static Pattern getEntryPointAsPattern(String entryPointString) {
        String simpleRegEx = entryPointString.replace(".", "\\.").replace("\\.*", ".*");
        return Pattern.compile(simpleRegEx);
    }
}

