/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.j2cl.common.AutoValue_FilePosition;

@AutoValue
public abstract class FilePosition
implements Comparable<FilePosition> {
    static final FilePosition NONE = FilePosition.newBuilder().setLine(-1).setColumn(-1).setByteOffset(-1).build();

    public abstract int getLine();

    public abstract int getColumn();

    public abstract int getByteOffset();

    @Override
    public int compareTo(FilePosition other) {
        if (this.getLine() != other.getLine()) {
            return this.getLine() - other.getLine();
        }
        return this.getColumn() - other.getColumn();
    }

    public static Builder newBuilder() {
        return new AutoValue_FilePosition.Builder();
    }

    public final boolean equals(Object that) {
        if (!(that instanceof FilePosition)) {
            return false;
        }
        FilePosition thatFilePosition = (FilePosition)that;
        boolean result = this.getLine() == thatFilePosition.getLine() && this.getColumn() == thatFilePosition.getColumn();
        Preconditions.checkState((result == (this.getByteOffset() == thatFilePosition.getByteOffset()) ? 1 : 0) != 0, (Object)"Line/column position does not match byte offset.");
        return result;
    }

    public final int hashCode() {
        return this.getLine() * 37 + this.getColumn();
    }

    public final String toString() {
        return "(" + this.getLine() + ":" + this.getColumn() + ")";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setLine(int var1);

        public abstract Builder setColumn(int var1);

        public abstract Builder setByteOffset(int var1);

        public abstract FilePosition build();
    }
}

