/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.j2cl.common.Problems;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class OutputUtils {
    private static final boolean DETERMINISTIC_TIMESTAMPS = Boolean.getBoolean("j2cl.deterministicTimestamps");

    public static Output initOutput(Path output, Problems problems) {
        return output.toString().endsWith(".zip") || output.toString().endsWith(".jar") ? OutputUtils.getZipOutput(output, problems) : OutputUtils.getDirOutput(output, problems);
    }

    private static Output getDirOutput(Path output, Problems problems) {
        if (Files.isRegularFile(output, new LinkOption[0])) {
            problems.fatal(Problems.FatalError.OUTPUT_LOCATION, output);
        }
        return new Output(problems, output);
    }

    private static Output getZipOutput(Path output, final Problems problems) {
        final FileSystem newFileSystem = OutputUtils.initZipOutput(output, problems);
        return new Output(problems, newFileSystem.getPath("/", new String[0])){

            @Override
            public void close() {
                super.close();
                try {
                    newFileSystem.close();
                }
                catch (IOException e) {
                    problems.fatal(Problems.FatalError.CANNOT_CLOSE_ZIP, e.getMessage());
                }
            }
        };
    }

    @Nullable
    private static FileSystem initZipOutput(Path output, Problems problems) {
        if (Files.isDirectory(output, new LinkOption[0])) {
            problems.fatal(Problems.FatalError.OUTPUT_LOCATION, output);
        }
        output.toFile().delete();
        output.toFile().getParentFile().mkdirs();
        try {
            return FileSystems.newFileSystem(URI.create("jar:" + output.toAbsolutePath().toUri()), ImmutableMap.of((Object)"create", (Object)"true"));
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_CREATE_ZIP, output, e.getMessage());
            return null;
        }
    }

    private static void writeToFile(Path outputPath, ImmutableList<String> chunks, Problems problems) {
        try {
            OutputUtils.createDirectories(outputPath.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String chunk : chunks) {
                    writer.append(chunk);
                }
            }
            OutputUtils.maybeResetAllTimeStamps(outputPath);
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_WRITE_FILE, e.toString());
        }
    }

    public static void writeToFile(Path outputPath, byte[] content, Problems problems) {
        try {
            OutputUtils.createDirectories(outputPath.getParent());
            Files.write(outputPath, content, new OpenOption[0]);
            OutputUtils.maybeResetAllTimeStamps(outputPath);
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_WRITE_FILE, e.toString());
        }
    }

    private static void copyFile(Path from, Path to, Problems problems) {
        try {
            OutputUtils.createDirectories(to.getParent());
            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            OutputUtils.maybeResetAllTimeStamps(to);
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_COPY_FILE, e.toString());
        }
    }

    private static void createDirectories(Path outputPath) throws IOException {
        if (!DETERMINISTIC_TIMESTAMPS) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
            return;
        }
        if (outputPath == null || Files.exists(outputPath, new LinkOption[0])) {
            return;
        }
        OutputUtils.createDirectories(outputPath.getParent());
        Files.createDirectory(outputPath, new FileAttribute[0]);
        OutputUtils.maybeResetAllTimeStamps(outputPath);
    }

    private static void maybeResetAllTimeStamps(Path path) throws IOException {
        if (!DETERMINISTIC_TIMESTAMPS) {
            return;
        }
        Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileTime.fromMillis(0L), FileTime.fromMillis(0L), FileTime.fromMillis(0L));
    }

    public static String getPackageRelativePath(String packageName, String filename) {
        return Paths.get(packageName.replace('.', '/'), filename).toString();
    }

    private OutputUtils() {
    }

    public static class Output
    implements AutoCloseable {
        private final ExecutorService fileService = Executors.newSingleThreadExecutor();
        private final Problems problems;
        private final Path root;

        private Output(Problems problems, Path root) {
            this.problems = problems;
            this.root = root;
        }

        public void write(String path, byte[] content) {
            Path outputPath = this.root.resolve(path);
            this.fileService.execute(() -> OutputUtils.writeToFile(outputPath, content, this.problems));
        }

        public void write(String path, String content) {
            this.write(path, (ImmutableList<String>)ImmutableList.of((Object)content));
        }

        public void write(String path, ImmutableList<String> contentChunks) {
            Path outputPath = this.root.resolve(path);
            this.fileService.execute(() -> OutputUtils.writeToFile(outputPath, contentChunks, this.problems));
        }

        public void copyFile(String fromAbsolute, String to) {
            Path fromPath = Paths.get(fromAbsolute, new String[0]);
            Path toPath = this.root.resolve(to);
            this.fileService.execute(() -> OutputUtils.copyFile(fromPath, toPath, this.problems));
        }

        @Override
        public void close() {
            try {
                this.fileService.shutdown();
                this.fileService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

