/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.j2cl.common.SourcePosition;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Problems {
    private final SetMultimap<Severity, String> problemsBySeverity = Multimaps.synchronizedSetMultimap((SetMultimap)LinkedHashMultimap.create());

    public void fatal(FatalError fatalError, Object ... args) {
        Preconditions.checkArgument((fatalError.getNumberOfArguments() == args.length ? 1 : 0) != 0);
        this.problem(Severity.ERROR, "Error: " + String.format(fatalError.getMessage(), args));
        this.abort();
    }

    public void fatal(int lineNumber, String filePath, FatalError fatalError, Object ... args) {
        Preconditions.checkArgument((fatalError.getNumberOfArguments() == args.length ? 1 : 0) != 0);
        this.problem(Severity.ERROR, lineNumber, filePath, String.format(fatalError.getMessage(), args));
        this.abort();
    }

    @FormatMethod
    public void error(SourcePosition sourcePosition, @FormatString String detailMessage, Object ... args) {
        this.problem(Severity.ERROR, sourcePosition, detailMessage, args);
    }

    @FormatMethod
    public void error(int lineNumber, String filePath, @FormatString String detailMessage, Object ... args) {
        this.problem(Severity.ERROR, lineNumber, filePath, detailMessage, args);
    }

    @FormatMethod
    public void error(String detailMessage, Object ... args) {
        this.problem(Severity.ERROR, "Error: " + String.format(detailMessage, args));
    }

    @FormatMethod
    public void warning(SourcePosition sourcePosition, String detailMessage, Object ... args) {
        this.problem(Severity.WARNING, sourcePosition, detailMessage, args);
    }

    @FormatMethod
    public void warning(String detailMessage, Object ... args) {
        this.problem(Severity.WARNING, String.format(detailMessage, args));
    }

    @FormatMethod
    private void problem(Severity severity, SourcePosition sourcePosition, String detailMessage, Object ... args) {
        Preconditions.checkArgument((sourcePosition != null ? 1 : 0) != 0);
        if (sourcePosition == SourcePosition.NONE) {
            this.problem(severity, String.format(detailMessage, args));
        } else {
            this.problem(severity, sourcePosition.getStartFilePosition().getLine() + 1, sourcePosition.getFilePath(), detailMessage, args);
        }
    }

    @FormatMethod
    private void problem(Severity severity, int lineNumber, String filePath, @FormatString String detailMessage, Object ... args) {
        String message = args.length == 0 ? detailMessage : String.format(detailMessage, args);
        this.problem(severity, lineNumber, filePath, message);
    }

    private void problem(Severity severity, int lineNumber, String filePath, String message) {
        this.problem(severity, String.format("%s:%s:%s: %s", severity.getMessagePrefix(), filePath.substring(filePath.lastIndexOf(47) + 1), lineNumber, message));
    }

    private void problem(Severity severity, String message) {
        this.problemsBySeverity.put((Object)severity, (Object)message);
    }

    @FormatMethod
    public void info(String detailMessage, Object ... args) {
        this.problem(Severity.INFO, String.format(detailMessage, args));
    }

    public int reportAndGetExitCode(PrintStream output) {
        return this.reportAndGetExitCode(new PrintWriter(output, true));
    }

    public int reportAndGetExitCode(PrintWriter output) {
        for (Map.Entry severityMessagePair : this.problemsBySeverity.entries()) {
            output.println((String)severityMessagePair.getValue());
        }
        if (this.hasErrors() || this.hasWarnings()) {
            output.printf("%d error(s), %d warning(s).\n", this.problemsBySeverity.get((Object)Severity.ERROR).size(), this.problemsBySeverity.get((Object)Severity.WARNING).size());
        }
        return this.hasErrors() ? 1 : 0;
    }

    public boolean hasWarnings() {
        return this.problemsBySeverity.containsKey((Object)Severity.WARNING);
    }

    public boolean hasErrors() {
        return this.problemsBySeverity.containsKey((Object)Severity.ERROR);
    }

    public boolean hasProblems() {
        return !this.problemsBySeverity.isEmpty();
    }

    public void abortIfHasErrors() {
        if (this.hasErrors()) {
            this.abort();
        }
    }

    private void abort() {
        throw new Exit();
    }

    public List<String> getErrors() {
        return this.getMessages(Severity.ERROR);
    }

    public List<String> getWarnings() {
        return this.getMessages(Severity.WARNING);
    }

    public List<String> getInfoMessages() {
        return this.getMessages(Severity.INFO);
    }

    public List<String> getMessages() {
        return this.getMessages(EnumSet.allOf(Severity.class));
    }

    private List<String> getMessages(Severity severity) {
        return this.getMessages(Collections.singleton(severity));
    }

    private List<String> getMessages(Collection<Severity> severities) {
        return this.problemsBySeverity.entries().stream().filter(e -> severities.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public static class Exit
    extends Error {
    }

    public static enum Severity {
        ERROR("Error"),
        WARNING("Warning"),
        INFO("Info");

        private final String messagePrefix;

        private Severity(String messagePrefix) {
            this.messagePrefix = messagePrefix;
        }

        public String getMessagePrefix() {
            return this.messagePrefix;
        }
    }

    public static enum FatalError {
        FILE_NOT_FOUND("File '%s' not found.", 1),
        UNKNOWN_INPUT_TYPE("Cannot recognize input type for file '%s'.", 1),
        OUTPUT_LOCATION("Output location '%s' must be a directory or .zip file.", 1),
        CANNOT_EXTRACT_ZIP("Cannot extract zip '%s'.", 1),
        CANNOT_CREATE_ZIP("Cannot create zip '%s': %s.", 2),
        CANNOT_CLOSE_ZIP("Cannot close zip: %s.", 1),
        CANNOT_CREATE_TEMP_DIR("Cannot create temporary directory: %s.", 1),
        CANNOT_OPEN_FILE("Cannot open file: %s.", 1),
        CANNOT_WRITE_FILE("Cannot write file: %s.", 1),
        CANNOT_COPY_FILE("Cannot copy file: %s.", 1),
        PACKAGE_INFO_PARSE("Resource '%s' was found but it failed to parse.", 1),
        CLASS_PATH_URL("Class path entry '%s' is not a valid url.", 1),
        INCOMPATIBLE_ANNOTATION_FOUND_IN_COMPILE("Unexpected @%s annotation found. Please run this library through the incompatible annotated code stripper tool.", 1),
        LIBRARY_INFO_OUTPUT_ARG_MISSING("-libraryinfooutput option is mandatory", 0),
        INVALID_JAVA_FRONTEND("%s is not a valid Java frontend.", 1);

        private final String message;
        private final int numberOfArguments;

        private FatalError(String message, int numberOfArguments) {
            this.message = message;
            this.numberOfArguments = numberOfArguments;
        }

        public String getMessage() {
            return this.message;
        }

        private int getNumberOfArguments() {
            return this.numberOfArguments;
        }
    }
}

