/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.j2cl.common.$AutoValue_SourcePosition;
import com.google.j2cl.common.FilePosition;
import java.io.File;
import javax.annotation.Nullable;

@AutoValue
public abstract class SourcePosition
implements Comparable<SourcePosition> {
    public static final SourcePosition NONE = SourcePosition.newBuilder().setStartFilePosition(FilePosition.NONE).setEndFilePosition(FilePosition.NONE).build();

    public abstract FilePosition getStartFilePosition();

    public abstract FilePosition getEndFilePosition();

    @Nullable
    public abstract String getFilePath();

    @Nullable
    public abstract String getName();

    @Nullable
    public abstract String getPackageRelativePath();

    @Override
    public int compareTo(SourcePosition o) {
        int pathComparisonResult;
        if (this.getFilePath() != null && (pathComparisonResult = this.getFilePath().compareTo(o.getFilePath())) != 0) {
            return pathComparisonResult;
        }
        return this.getStartFilePosition().compareTo(o.getStartFilePosition());
    }

    @Nullable
    public String getFileName() {
        String filePath = this.getFilePath();
        return filePath == null ? filePath : new File(filePath).getName();
    }

    abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new $AutoValue_SourcePosition.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setStartFilePosition(FilePosition var1);

        public abstract Builder setEndFilePosition(FilePosition var1);

        public abstract Builder setFilePath(String var1);

        public abstract Builder setPackageRelativePath(String var1);

        public abstract Builder setName(String var1);

        abstract SourcePosition autoBuild();

        public SourcePosition build() {
            SourcePosition sourcePosition = this.autoBuild();
            Preconditions.checkState((sourcePosition.getStartFilePosition().compareTo(sourcePosition.getEndFilePosition()) <= 0 ? 1 : 0) != 0);
            return sourcePosition;
        }

        public static Builder from(SourcePosition sourcePosition) {
            return sourcePosition.toBuilder();
        }
    }
}

