/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.AutoValue_SourceUtils_FileInfo;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.ZipFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class SourceUtils {
    private static final String TEMP_ROOT = "j2cl_sources";

    @Nullable
    public static Stream<FileInfo> getAllSources(List<String> sources, Problems problems) {
        Path sourcesDir;
        try {
            Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
            sourcesDir = Files.createDirectory(tempDir.resolve(TEMP_ROOT), new FileAttribute[0]);
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_CREATE_TEMP_DIR, e.getMessage());
            return null;
        }
        return sources.stream().flatMap(f -> f.endsWith("jar") || f.endsWith("zip") ? SourceUtils.extractZip(f, sourcesDir, problems).stream() : Stream.of(FileInfo.create(f, f, SourceUtils.getJavaPath(f)))).sorted().distinct();
    }

    @Nullable
    private static ImmutableList<FileInfo> extractZip(String zipPath, Path sourcesDir, Problems problems) {
        try {
            return ZipFiles.unzipFile(new File(zipPath), sourcesDir.toFile());
        }
        catch (IOException e) {
            problems.fatal(Problems.FatalError.CANNOT_EXTRACT_ZIP, zipPath);
            return null;
        }
    }

    public static String getJavaPath(String path) {
        String javaRelativePath = SourceUtils.getRelativePath(path, "java", "javatests");
        if (javaRelativePath.equals(path)) {
            javaRelativePath = SourceUtils.getRelativePath(path, TEMP_ROOT);
        }
        return SourceUtils.getRelativePath(javaRelativePath, "super", "super-j2cl");
    }

    private static String getRelativePath(String path, String ... roots) {
        int index = Integer.MAX_VALUE;
        for (String root : roots) {
            index = Math.min(index, SourceUtils.indexAfterRoot(path, root));
        }
        return index < path.length() ? path.substring(index) : path;
    }

    private static int indexAfterRoot(String path, String root) {
        String rootPath = root + "/";
        if (path.startsWith(rootPath)) {
            return rootPath.length();
        }
        int index = path.indexOf(rootPath = "/" + rootPath);
        return index == -1 ? path.length() : index + rootPath.length();
    }

    public static void checkSourceFiles(Problems problems, List<String> sourceFiles, String ... validExtensions) {
        for (String sourceFile : sourceFiles) {
            if (Arrays.stream(validExtensions).noneMatch(sourceFile::endsWith)) {
                problems.fatal(Problems.FatalError.UNKNOWN_INPUT_TYPE, sourceFile);
            }
            if (Files.isRegularFile(Paths.get(sourceFile, new String[0]), new LinkOption[0])) continue;
            problems.fatal(Problems.FatalError.FILE_NOT_FOUND, sourceFile);
        }
    }

    private SourceUtils() {
    }

    @AutoValue
    public static abstract class FileInfo
    implements Comparable<FileInfo> {
        public static FileInfo create(String sourcePath, String originalPath) {
            return FileInfo.create(sourcePath, originalPath, originalPath);
        }

        public static FileInfo create(String sourcePath, String originalPath, String targetPath) {
            return new AutoValue_SourceUtils_FileInfo(sourcePath, originalPath, targetPath);
        }

        public abstract String sourcePath();

        public abstract String originalPath();

        public abstract String targetPath();

        @Override
        public int compareTo(FileInfo o) {
            return this.targetPath().compareTo(o.targetPath());
        }
    }
}

