/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.common.base.Preconditions;
import com.google.j2cl.common.InternalCompilerError;
import java.util.stream.Collectors;

public final class StringUtils {
    public static String capitalize(String string) {
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String unescapeWtf16(String string) {
        StringBuilder unescapedStringBuilder = new StringBuilder();
        char[] charArray = string.toCharArray();
        block9: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\\') {
                switch (charArray[++i]) {
                    case 't': {
                        unescapedStringBuilder.append('\t');
                        continue block9;
                    }
                    case 'n': {
                        unescapedStringBuilder.append('\n');
                        continue block9;
                    }
                    case 'r': {
                        unescapedStringBuilder.append('\r');
                        continue block9;
                    }
                    case '\"': {
                        unescapedStringBuilder.append('\"');
                        continue block9;
                    }
                    case '\'': {
                        unescapedStringBuilder.append('\'');
                        continue block9;
                    }
                    case '\\': {
                        unescapedStringBuilder.append('\\');
                        continue block9;
                    }
                    case 'u': {
                        unescapedStringBuilder.append(StringUtils.unescapeUnicode(charArray, i));
                        i += 4;
                        continue block9;
                    }
                    default: {
                        throw new InternalCompilerError("Bad escaping " + string);
                    }
                }
            }
            unescapedStringBuilder.append(c);
        }
        return unescapedStringBuilder.toString();
    }

    private static char unescapeUnicode(char[] charArray, int i) {
        char value = '\u0000';
        for (int j = 0; j < 4; ++j) {
            int digit;
            if ((digit = Character.digit(charArray[++i], 16)) < 0) {
                throw new InternalCompilerError("Bad escaping " + new String(charArray));
            }
            value = (char)(value * 16 + digit);
        }
        return value;
    }

    public static String escapeAsWtf16(String string) {
        return string.chars().mapToObj(StringUtils::escapeAsWtf16).collect(Collectors.joining());
    }

    public static String escapeAsWtf16(int c) {
        return StringUtils.escape(c, false);
    }

    public static String escapeAsUtf8(String string) {
        StringBuilder escaped = new StringBuilder();
        string.codePoints().forEach(codepoint -> {
            if (codepoint < 128) {
                escaped.append(StringUtils.escapeAsUtf8(codepoint));
            } else if (codepoint < 2048) {
                escaped.append(StringUtils.escapeAsUtf8(0xC0 | codepoint >> 6));
                escaped.append(StringUtils.escapeAsUtf8(0x80 | codepoint & 0x3F));
            } else if (codepoint < 65536) {
                escaped.append(StringUtils.escapeAsUtf8(0xE0 | codepoint >> 12));
                escaped.append(StringUtils.escapeAsUtf8(0x80 | codepoint >> 6 & 0x3F));
                escaped.append(StringUtils.escapeAsUtf8(0x80 | codepoint & 0x3F));
            } else {
                escaped.append(StringUtils.escapeAsUtf8(0xF0 | codepoint >> 18));
                escaped.append(StringUtils.escapeAsUtf8(0x80 | codepoint >> 12 & 0x3F));
                escaped.append(StringUtils.escapeAsUtf8(0x80 | codepoint >> 6 & 0x3F));
                escaped.append(StringUtils.escapeAsUtf8(0x80 | codepoint & 0x3F));
            }
        });
        return escaped.toString();
    }

    public static String escapeAsUtf8(int c) {
        return StringUtils.escape(c, true);
    }

    private static String escape(int c, boolean forUtf8) {
        switch (c) {
            case 9: {
                return "\\t";
            }
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 34: {
                return "\\\"";
            }
            case 39: {
                return "\\'";
            }
            case 92: {
                return "\\\\";
            }
        }
        if (c >= 32 && c < 127) {
            return String.valueOf((char)c);
        }
        if (forUtf8) {
            Preconditions.checkArgument((c >= 0 && c <= 255 ? 1 : 0) != 0);
            return String.format("\\%02X", (byte)c);
        }
        return String.format("\\u%04X", c);
    }

    private StringUtils() {
    }
}

