/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.j2cl.common.SourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ZipFiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableList<SourceUtils.FileInfo> unzipFile(File zipFile, File targetDirectory) throws IOException {
        Preconditions.checkNotNull((Object)zipFile);
        Preconditions.checkNotNull((Object)targetDirectory);
        Preconditions.checkArgument((boolean)targetDirectory.isDirectory(), (String)"%s is not a valid directory", (Object)targetDirectory.getAbsolutePath());
        ImmutableList.Builder results = new ImmutableList.Builder();
        try (ZipFile zipFileObj = new ZipFile(zipFile);){
            for (ZipEntry entry : ZipFiles.entries(zipFileObj)) {
                ZipFiles.checkName(entry.getName());
                File targetFile = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (targetFile.isDirectory() || targetFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory: " + targetFile.getAbsolutePath());
                }
                File parentFile = targetFile.getParentFile();
                if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                    throw new IOException("Failed to create directory: " + parentFile.getAbsolutePath());
                }
                ZipFiles.asByteSource(zipFileObj, entry).copyTo(Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]));
                results.add((Object)SourceUtils.FileInfo.create(targetFile.toString(), entry.getName()));
            }
        }
        return results.build();
    }

    private static ByteSource asByteSource(ZipFile file, ZipEntry entry) {
        return new ZipEntryByteSource(file, entry);
    }

    public static FluentIterable<ZipEntry> entries(final ZipFile file) {
        Preconditions.checkNotNull((Object)file);
        return new FluentIterable<ZipEntry>(){

            public Iterator<ZipEntry> iterator() {
                return Iterators.forEnumeration(file.entries());
            }
        };
    }

    private static void checkName(String name) throws IOException {
        if (name.contains("..")) {
            for (File file = new File(name); file != null; file = file.getParentFile()) {
                if (!file.getName().equals("..")) continue;
                throw new IOException("Cannot unzip file containing an entry with \"..\" in the name: " + name);
            }
        }
    }

    private ZipFiles() {
    }

    private static final class ZipEntryByteSource
    extends ByteSource {
        private final ZipFile file;
        private final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = (ZipFile)Preconditions.checkNotNull((Object)file);
            this.entry = (ZipEntry)Preconditions.checkNotNull((Object)entry);
        }

        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public String toString() {
            return "ZipFiles.asByteSource(" + this.file + ", " + this.entry + ")";
        }
    }
}

