/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.common;

import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.FormatMethod;
import com.google.j2cl.common.InternalCompilerError;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.VariableDeclarationExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class AbstractCompilationUnitBuilder {
    private final List<Type> typeStack = new ArrayList<Type>();
    private String currentSourceFile;
    private CompilationUnit currentCompilationUnit;

    protected String getCurrentSourceFile() {
        return this.currentSourceFile;
    }

    protected void setCurrentSourceFile(String currentSourceFile) {
        this.currentSourceFile = currentSourceFile;
    }

    protected CompilationUnit getCurrentCompilationUnit() {
        return this.currentCompilationUnit;
    }

    protected void setCurrentCompilationUnit(CompilationUnit currentCompilationUnit) {
        this.currentCompilationUnit = currentCompilationUnit;
    }

    protected <T> T processEnclosedBy(Type type, Supplier<T> supplier) {
        this.typeStack.add(type);
        T converted = supplier.get();
        this.typeStack.remove(this.typeStack.size() - 1);
        return converted;
    }

    protected Type getCurrentType() {
        return (Type)Iterables.getLast(this.typeStack, null);
    }

    protected static VariableDeclarationExpression toResource(Expression expression) {
        if (expression instanceof VariableDeclarationExpression) {
            return (VariableDeclarationExpression)expression;
        }
        return VariableDeclarationExpression.newBuilder().addVariableDeclaration(Variable.newBuilder().setName("$resource").setTypeDescriptor(expression.getTypeDescriptor()).setFinal(true).build(), expression).build();
    }

    @FormatMethod
    protected Error internalCompilerError(Throwable e, String format, Object ... params) {
        return new InternalCompilerError(e, this.internalCompilerErrorMessage(format, params));
    }

    @FormatMethod
    protected Error internalCompilerError(String format, Object ... params) {
        return new InternalCompilerError(this.internalCompilerErrorMessage(format, params));
    }

    @FormatMethod
    protected String internalCompilerErrorMessage(String format, Object ... params) {
        return String.format(format, params) + ", in file: " + this.currentSourceFile;
    }
}

