/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.common;

import com.google.common.collect.ImmutableSet;

public class Nullability {
    public static final ImmutableSet<String> RECOGNIZED_NULL_MARKED_ANNOTATIONS_QUALIFIED_NAMES = ImmutableSet.of((Object)"org.jspecify.nullness.NullMarked", (Object)"org.jspecify.annotations.NullMarked", (Object)"com.google.protobuf.Internal.ProtoNonnullApi");
    private static final ImmutableSet<String> RECOGNIZED_NULLABLE_ANNOTATIONS_QUALIFIED_NAMES = ImmutableSet.of((Object)"jsinterop.annotations.JsNullable", (Object)"org.jspecify.nullness.Nullable", (Object)"org.jspecify.annotations.Nullable", (Object)"android.annotation.Nullable", (Object)"android.support.annotation.Nullable", (Object)"androidx.annotation.Nullable", (Object[])new String[]{"androidx.annotation.RecentlyNullable", "com.sun.istack.internal.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "edu.umd.cs.findbugs.annotations.CheckForNull", "edu.umd.cs.findbugs.annotations.PossiblyNull", "edu.umd.cs.findbugs.annotations.UnknownNullnes", "io.reactivex.annotations.Nullable", "io.reactivex.rxjava3.annotations.Nullable", "javax.annotation.Nullable", "javax.annotation.CheckForNull", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType", "org.checkerframework.checker.nullness.qual.MonotonicNonNull", "org.checkerframework.checker.nullness.qual.Nullable", "org.codehaus.commons.nullanalysis.Nullable", "org.eclipse.jdt.annotation.Nullable", "org.eclipse.jgit.annotations.Nullable", "org.jetbrains.annotations.Nullable", "org.jmlspecs.annotation.Nullable", "org.netbeans.api.annotations.common.NullAllowed", "org.netbeans.api.annotations.common.CheckForNull", "org.netbeans.api.annotations.common.NullUnknown", "org.springframework.lang.Nullable", "android.support.annotation.RecentlyNullable", "com.android.annotations.Nullable", "com.beust.jcommander.internal.Nullable", "com.google.api.server.spi.config.Nullable", "com.google.firebase.database.annotations.Nullable", "com.google.firebase.internal.Nullable", "com.google.gerrit.common.Nullable", "com.google.protobuf.Internal.ProtoMethodAcceptsNullParameter", "com.google.protobuf.Internal.ProtoMethodMayReturnNull", "com.google.protobuf.Internal.ProtoPassThroughNullness", "com.mongodb.lang.Nullable", "com.sun.istack.Nullable", "com.unboundid.util.Nullable", "io.micrometer.core.lang.Nullable", "io.micronaut.core.annotation.Nullable", "io.vertx.codegen.annotations.Nullable", "jakarta.annotation.Nullable", "junitparams.converters.Nullable", "libcore.util.Nullable", "net.bytebuddy.agent.utility.nullability.AlwaysNull", "net.bytebuddy.agent.utility.nullability.MaybeNull", "net.bytebuddy.utility.nullability.AlwaysNull", "net.bytebuddy.utility.nullability.MaybeNull", "org.apache.avro.reflect.Nullable", "org.apache.cxf.jaxrs.ext.Nullable", "org.apache.shindig.common.Nullable", "org.json.Nullable", "reactor.util.annotation.Nullable"});
    private static final ImmutableSet<String> RECOGNIZED_NON_NULL_ANNOTATIONS_QUALIFIED_NAMES = ImmutableSet.of((Object)"jsinterop.annotations.JsNonNull", (Object)"org.jspecify.nullness.NonNull", (Object)"org.jspecify.annotations.NonNull", (Object)"android.annotation.NonNull", (Object)"android.support.annotation.NonNull", (Object)"androidx.annotation.NonNull", (Object[])new String[]{"androidx.annotation.RecentlyNonNull", "com.sun.istack.internal.NotNull", "edu.umd.cs.findbugs.annotations.NonNull", "io.reactivex.annotations.NonNull", "io.reactivex.rxjava3.annotations.NonNull", "javax.annotation.Nonnull", "javax.validation.constraints.NotNull", "lombok.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType", "org.checkerframework.checker.nullness.qual.NonNull", "org.codehaus.commons.nullanalysis.NotNull", "org.eclipse.jdt.annotation.NonNull", "org.eclipse.jgit.annotations.NonNull", "org.jetbrains.annotations.NotNull", "org.jmlspecs.annotation.NonNull", "org.netbeans.api.annotations.common.NonNull", "org.springframework.lang.NonNull", "com.android.annotations.NonNull", "com.google.firebase.database.annotations.NotNull", "com.google.firebase.internal.NonNull", "com.sun.istack.NotNull", "com.unboundid.util.NotNull", "io.micrometer.core.lang.NonNull", "io.micronaut.core.annotation.NonNull", "jakarta.annotation.Nonnull", "libcore.util.NonNull", "net.bytebuddy.agent.utility.nullability.NeverNull", "net.bytebuddy.utility.nullability.NeverNull", "org.antlr.v4.runtime.misc.NotNull", "org.eclipse.lsp4j.jsonrpc.validation.NonNull", "org.json.NonNull", "reactor.util.annotation.NonNull"});

    public static boolean isNullMarkedAnnotation(String qualifiedName) {
        return RECOGNIZED_NULL_MARKED_ANNOTATIONS_QUALIFIED_NAMES.contains((Object)qualifiedName);
    }

    public static boolean isNullableAnnotation(String qualifiedName) {
        return RECOGNIZED_NULLABLE_ANNOTATIONS_QUALIFIED_NAMES.contains((Object)qualifiedName);
    }

    public static boolean isNonNullAnnotation(String qualifiedName) {
        return RECOGNIZED_NON_NULL_ANNOTATIONS_QUALIFIED_NAMES.contains((Object)qualifiedName);
    }

    private Nullability() {
    }
}

