/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.common;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.j2cl.common.OutputUtils;
import com.google.j2cl.common.Problems;
import com.google.j2cl.transpiler.frontend.common.AutoValue_PackageInfoCache_PackageReport;
import com.google.j2objc.annotations.ObjectiveCName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import jsinterop.annotations.JsPackage;
import org.jspecify.annotations.NullMarked;

public class PackageInfoCache {
    public static final String SOURCE_CLASS_PATH_ENTRY = "[source]";
    public static final PackageReport DEFAULT_PACKAGE_REPORT = PackageReport.newBuilder().build();
    private static final ThreadLocal<PackageInfoCache> packageInfoCacheStorage = new ThreadLocal();
    private final Problems problems;
    private final Map<String, PackageReport> packageReportBySpecificPackagePath = new HashMap<String, PackageReport>();
    private final Map<String, PackageReport> packageReportByTypeName = new HashMap<String, PackageReport>();
    private final ClassLoader resourcesClassLoader;

    @VisibleForTesting
    public static void clear() {
        packageInfoCacheStorage.remove();
    }

    public static PackageInfoCache get() {
        return (PackageInfoCache)Preconditions.checkNotNull((Object)packageInfoCacheStorage.get());
    }

    public static void init(List<String> classPathEntries, Problems problems) {
        Preconditions.checkState((packageInfoCacheStorage.get() == null ? 1 : 0) != 0, (Object)"PackageInfoCache should only be initialized once per thread.");
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        for (String classPathEntry : classPathEntries) {
            try {
                classPathUrls.add(new URL("file:" + classPathEntry));
            }
            catch (MalformedURLException e) {
                problems.fatal(Problems.FatalError.CANNOT_OPEN_FILE, new Object[]{e.toString()});
            }
        }
        URLClassLoader resourcesClassLoader = new URLClassLoader((URL[])Iterables.toArray(classPathUrls, URL.class), null);
        packageInfoCacheStorage.set(new PackageInfoCache(resourcesClassLoader, problems));
    }

    private static String toSpecificPackagePath(String classPathEntry, String packagePath) {
        return classPathEntry + ":" + packagePath;
    }

    private PackageInfoCache(ClassLoader resourcesClassLoader, Problems problems) {
        this.resourcesClassLoader = resourcesClassLoader;
        this.problems = problems;
    }

    public String getJsNamespace(String topLevelTypeSourceName) {
        return this.getPackageReport(topLevelTypeSourceName).getJsNamespace();
    }

    public String getObjectiveCName(String topLevelTypeSourceName) {
        return this.getPackageReport(topLevelTypeSourceName).getObjectiveCName();
    }

    public boolean isNullMarked(String topLevelTypeSourceName) {
        return this.getPackageReport(topLevelTypeSourceName).isNullMarked();
    }

    public void markAsSource(String topLevelTypeSourceName) {
        this.propagateSpecificInfo(SOURCE_CLASS_PATH_ENTRY, topLevelTypeSourceName);
    }

    public void setPackageProperties(String classPathEntry, String packagePath, String packageJsNamespace, String objectiveCName, boolean isNullMarked) {
        this.setReportForPackage(classPathEntry, packagePath, PackageReport.newBuilder().setJsNamespace(packageJsNamespace).setObjectiveCName(objectiveCName).setNullMarked(isNullMarked).build());
    }

    private Annotation[] findBytecodePackageAnnotations(String classPathEntry, String packagePath) {
        Preconditions.checkNotNull((Object)classPathEntry);
        String packageInfoRelativeFilePath = OutputUtils.getPackageRelativePath((String)packagePath, (String)"package-info.class");
        String packageInfoSourceName = packagePath + ".package-info";
        Annotation[] annotations = new Annotation[]{};
        try {
            URLClassLoader entryClassLoader = new URLClassLoader(new URL[]{new URL(classPathEntry)}, this.resourcesClassLoader);
            URL packageInfoResource = entryClassLoader.findResource(packageInfoRelativeFilePath);
            if (packageInfoResource == null) {
                return annotations;
            }
            Class<?> packageInfoClass = entryClassLoader.loadClass(packageInfoSourceName);
            annotations = packageInfoClass.getAnnotations();
        }
        catch (ClassNotFoundException e) {
            this.problems.fatal(Problems.FatalError.PACKAGE_INFO_PARSE, new Object[]{packageInfoRelativeFilePath});
        }
        catch (MalformedURLException e) {
            this.problems.fatal(Problems.FatalError.CLASS_PATH_URL, new Object[]{classPathEntry});
        }
        return annotations;
    }

    @Nullable
    private String findOriginClassPathEntry(String typeName) {
        String classFilePath = typeName.replace('.', '/') + ".class";
        URL typeResource = this.resourcesClassLoader.getResource(classFilePath);
        if (typeResource == null) {
            return null;
        }
        if (typeResource.getProtocol().equals("jrt")) {
            return null;
        }
        String resourcePath = typeResource.getFile();
        String originClassPathEntry = resourcePath.substring(0, resourcePath.length() - classFilePath.length());
        if (originClassPathEntry.endsWith("/")) {
            originClassPathEntry = originClassPathEntry.substring(0, originClassPathEntry.length() - 1);
        }
        if (originClassPathEntry.endsWith("!")) {
            originClassPathEntry = originClassPathEntry.substring(0, originClassPathEntry.length() - 1);
        }
        return originClassPathEntry;
    }

    private String getPackage(String topLevelTypeSourceName) {
        int lastDotIndex = topLevelTypeSourceName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return topLevelTypeSourceName;
        }
        return topLevelTypeSourceName.substring(0, lastDotIndex);
    }

    private PackageReport getPackageReport(String topLevelTypeSourceName) {
        if (this.packageReportByTypeName.containsKey(topLevelTypeSourceName)) {
            return this.packageReportByTypeName.get(topLevelTypeSourceName);
        }
        String originClassPathEntry = this.findOriginClassPathEntry(topLevelTypeSourceName);
        String packagePath = this.getPackage(topLevelTypeSourceName);
        String specificPackagePath = PackageInfoCache.toSpecificPackagePath(originClassPathEntry, packagePath);
        if (originClassPathEntry == null) {
            return DEFAULT_PACKAGE_REPORT;
        }
        if (!this.packageReportBySpecificPackagePath.containsKey(specificPackagePath)) {
            this.parsePackageInfo(originClassPathEntry, packagePath, topLevelTypeSourceName);
        }
        if (this.packageReportBySpecificPackagePath.containsKey(specificPackagePath)) {
            PackageReport packageReport = this.packageReportBySpecificPackagePath.get(specificPackagePath);
            this.packageReportByTypeName.put(topLevelTypeSourceName, packageReport);
            return packageReport;
        }
        return DEFAULT_PACKAGE_REPORT;
    }

    private void parsePackageInfo(String classPathEntry, String packagePath, String topLevelTypeSourceName) {
        Annotation[] packageAnnotations = this.findBytecodePackageAnnotations(classPathEntry, packagePath);
        this.setPackageProperties(classPathEntry, packagePath, PackageInfoCache.getPackageJsNamespace(packageAnnotations), PackageInfoCache.getPackageObjectiveCName(packageAnnotations), PackageInfoCache.hasNullMarkedAnnotation(packageAnnotations));
        this.propagateSpecificInfo(classPathEntry, topLevelTypeSourceName);
    }

    @Nullable
    private static String getPackageJsNamespace(Annotation[] packageAnnotations) {
        return PackageInfoCache.getAnnotationField(packageAnnotations, JsPackage.class, "namespace");
    }

    @Nullable
    private static String getPackageObjectiveCName(Annotation[] packageAnnotations) {
        return PackageInfoCache.getAnnotationField(packageAnnotations, ObjectiveCName.class, "value");
    }

    private static boolean hasNullMarkedAnnotation(Annotation[] packageAnnotations) {
        return PackageInfoCache.getAnnotation(packageAnnotations, NullMarked.class) != null;
    }

    @Nullable
    private static String getAnnotationField(Annotation[] annotations, Class<?> annotationClass, String field) {
        Annotation annotation = PackageInfoCache.getAnnotation(annotations, annotationClass);
        if (annotation == null) {
            return null;
        }
        try {
            Method fieldAccessor = annotation.annotationType().getMethod(field, new Class[0]);
            return (String)fieldAccessor.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static Annotation getAnnotation(Annotation[] annotations, Class<?> annotationClass) {
        if (annotations == null) {
            return null;
        }
        return Arrays.stream(annotations).filter(a -> a.annotationType().getName().equals(annotationClass.getName())).findFirst().orElse(null);
    }

    private void propagateSpecificInfo(String classPathEntry, String topLevelTypeSourceName) {
        PackageReport packageReport = this.packageReportBySpecificPackagePath.getOrDefault(PackageInfoCache.toSpecificPackagePath(classPathEntry, this.getPackage(topLevelTypeSourceName)), DEFAULT_PACKAGE_REPORT);
        this.packageReportByTypeName.put(topLevelTypeSourceName, packageReport);
    }

    private void setReportForPackage(String classPathEntry, String packagePath, PackageReport packageReport) {
        if (packageReport == null) {
            packageReport = DEFAULT_PACKAGE_REPORT;
        }
        String specificPackagePath = PackageInfoCache.toSpecificPackagePath(classPathEntry, packagePath);
        this.packageReportBySpecificPackagePath.put(specificPackagePath, packageReport);
    }

    @AutoValue
    public static abstract class PackageReport {
        @Nullable
        public abstract String getJsNamespace();

        @Nullable
        public abstract String getObjectiveCName();

        public abstract boolean isNullMarked();

        public static Builder newBuilder() {
            return new AutoValue_PackageInfoCache_PackageReport.Builder().setNullMarked(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setJsNamespace(String var1);

            public abstract Builder setObjectiveCName(String var1);

            public abstract Builder setNullMarked(boolean var1);

            abstract PackageReport autoBuild();

            public PackageReport build() {
                return this.autoBuild();
            }
        }
    }
}

