/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.j2cl.common.FilePosition;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.ast.ArrayAccess;
import com.google.j2cl.transpiler.ast.ArrayCreationReference;
import com.google.j2cl.transpiler.ast.ArrayLength;
import com.google.j2cl.transpiler.ast.ArrayLiteral;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.AssertStatement;
import com.google.j2cl.transpiler.ast.AstUtils;
import com.google.j2cl.transpiler.ast.BinaryExpression;
import com.google.j2cl.transpiler.ast.Block;
import com.google.j2cl.transpiler.ast.BooleanLiteral;
import com.google.j2cl.transpiler.ast.BreakStatement;
import com.google.j2cl.transpiler.ast.CastExpression;
import com.google.j2cl.transpiler.ast.CatchClause;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.ConditionalExpression;
import com.google.j2cl.transpiler.ast.ContinueStatement;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.DoWhileStatement;
import com.google.j2cl.transpiler.ast.Expression;
import com.google.j2cl.transpiler.ast.Field;
import com.google.j2cl.transpiler.ast.FieldAccess;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.ForEachStatement;
import com.google.j2cl.transpiler.ast.ForStatement;
import com.google.j2cl.transpiler.ast.FunctionExpression;
import com.google.j2cl.transpiler.ast.IfStatement;
import com.google.j2cl.transpiler.ast.InstanceOfExpression;
import com.google.j2cl.transpiler.ast.JavaScriptConstructorReference;
import com.google.j2cl.transpiler.ast.Label;
import com.google.j2cl.transpiler.ast.LabelReference;
import com.google.j2cl.transpiler.ast.LabeledStatement;
import com.google.j2cl.transpiler.ast.Literal;
import com.google.j2cl.transpiler.ast.Member;
import com.google.j2cl.transpiler.ast.MemberDescriptor;
import com.google.j2cl.transpiler.ast.Method;
import com.google.j2cl.transpiler.ast.MethodCall;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.MethodReference;
import com.google.j2cl.transpiler.ast.NewArray;
import com.google.j2cl.transpiler.ast.NewInstance;
import com.google.j2cl.transpiler.ast.NumberLiteral;
import com.google.j2cl.transpiler.ast.Operator;
import com.google.j2cl.transpiler.ast.PostfixExpression;
import com.google.j2cl.transpiler.ast.PrefixExpression;
import com.google.j2cl.transpiler.ast.PrimitiveTypeDescriptor;
import com.google.j2cl.transpiler.ast.ReturnStatement;
import com.google.j2cl.transpiler.ast.RuntimeMethods;
import com.google.j2cl.transpiler.ast.Statement;
import com.google.j2cl.transpiler.ast.StringLiteral;
import com.google.j2cl.transpiler.ast.SuperReference;
import com.google.j2cl.transpiler.ast.SwitchCase;
import com.google.j2cl.transpiler.ast.SwitchStatement;
import com.google.j2cl.transpiler.ast.SynchronizedStatement;
import com.google.j2cl.transpiler.ast.ThisReference;
import com.google.j2cl.transpiler.ast.ThrowStatement;
import com.google.j2cl.transpiler.ast.TryStatement;
import com.google.j2cl.transpiler.ast.Type;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.TypeLiteral;
import com.google.j2cl.transpiler.ast.UnaryExpression;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.VariableDeclarationExpression;
import com.google.j2cl.transpiler.ast.VariableDeclarationFragment;
import com.google.j2cl.transpiler.ast.WhileStatement;
import com.google.j2cl.transpiler.frontend.common.AbstractCompilationUnitBuilder;
import com.google.j2cl.transpiler.frontend.common.Nullability;
import com.google.j2cl.transpiler.frontend.common.PackageInfoCache;
import com.google.j2cl.transpiler.frontend.javac.AnnotationUtils;
import com.google.j2cl.transpiler.frontend.javac.JavaEnvironment;
import com.google.j2cl.transpiler.frontend.javac.JsInteropAnnotationUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public class CompilationUnitBuilder
extends AbstractCompilationUnitBuilder {
    private final JavaEnvironment environment;
    private final Map<VariableElement, Variable> variableByVariableElement = new HashMap<VariableElement, Variable>();
    private final Map<String, Label> labelsInScope = new HashMap<String, Label>();
    private JCTree.JCCompilationUnit javacUnit;

    private CompilationUnitBuilder(JavaEnvironment environment) {
        this.environment = environment;
    }

    @Nullable
    private Type createType(Symbol.ClassSymbol typeElement, JCTree sourcePositionNode) {
        if (typeElement == null) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.environment.createDeclarationForType(typeElement);
        return new Type(typeDeclaration.isAnonymous() ? this.getSourcePosition(sourcePositionNode) : this.getNamePosition(sourcePositionNode), typeDeclaration);
    }

    private <T> T convertAndAddType(Symbol.ClassSymbol typeElement, java.util.List<JCTree> bodyDeclarations, JCTree sourcePositionNode, Function<Type, T> typeProcessor) {
        Type type = this.createType(typeElement, sourcePositionNode);
        this.getCurrentCompilationUnit().addType(type);
        return (T)this.processEnclosedBy(type, () -> {
            this.convertTypeBody(type, bodyDeclarations);
            return typeProcessor.apply(type);
        });
    }

    private Type convertClassDeclaration(JCTree.JCClassDecl classDecl) {
        return this.convertClassDeclaration(classDecl, classDecl);
    }

    private Type convertClassDeclaration(JCTree.JCClassDecl classDecl, JCTree sourcePositionNode) {
        return this.convertAndAddType(classDecl.sym, classDecl.getMembers(), sourcePositionNode, type -> null);
    }

    private void convertTypeBody(Type type, java.util.List<JCTree> bodyDeclarations) {
        for (JCTree bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl fieldDeclaration = (JCTree.JCVariableDecl)bodyDeclaration;
                type.addMember((Member)this.convertFieldDeclaration(fieldDeclaration));
                continue;
            }
            if (bodyDeclaration instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl methodDeclaration = (JCTree.JCMethodDecl)bodyDeclaration;
                if ((methodDeclaration.mods.flags & 0x1000000000L) != 0L && (methodDeclaration.mods.flags & 0x20000000L) == 0L) continue;
                type.addMember((Member)this.convertMethodDeclaration(methodDeclaration));
                continue;
            }
            if (bodyDeclaration instanceof JCTree.JCBlock) {
                JCTree.JCBlock initializer = (JCTree.JCBlock)bodyDeclaration;
                Block block = this.convertBlock(initializer);
                if (initializer.isStatic()) {
                    type.addStaticInitializerBlock(block);
                    continue;
                }
                type.addInstanceInitializerBlock(block);
                continue;
            }
            if (bodyDeclaration instanceof JCTree.JCClassDecl) {
                JCTree.JCClassDecl nestedTypeDeclaration = (JCTree.JCClassDecl)bodyDeclaration;
                this.convertClassDeclaration(nestedTypeDeclaration);
                continue;
            }
            throw this.internalCompilerError("Unimplemented translation for BodyDeclaration type: %s.", new Object[]{bodyDeclaration.getClass().getName()});
        }
    }

    private Field convertFieldDeclaration(JCTree.JCVariableDecl fieldDeclaration) {
        Symbol.VarSymbol variableElement = fieldDeclaration.sym;
        Object constantValue = variableElement.getConstantValue();
        Object initializer = constantValue == null ? this.convertExpressionOrNull(fieldDeclaration.getInitializer()) : this.convertConstantToLiteral(variableElement);
        return Field.Builder.from((FieldDescriptor)this.environment.createFieldDescriptor(variableElement, fieldDeclaration.type)).setInitializer((Expression)initializer).setSourcePosition(this.getSourcePosition(fieldDeclaration)).setNameSourcePosition(this.getNamePosition(fieldDeclaration)).build();
    }

    private Method convertMethodDeclaration(JCTree.JCMethodDecl methodDeclaration) {
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        for (JCTree.JCVariableDecl parameter : methodDeclaration.getParameters()) {
            parameters.add(this.createVariable(parameter, true));
        }
        Block body = methodDeclaration.getBody() == null ? Block.newBuilder().setSourcePosition(this.getSourcePosition(methodDeclaration)).build() : this.convertBlock(methodDeclaration.getBody());
        return this.newMethodBuilder(methodDeclaration.sym).setBodySourcePosition(body.getSourcePosition()).setSourcePosition(this.getNamePosition(methodDeclaration)).setParameters(parameters).addStatements(body.getStatements()).build();
    }

    private Block convertBlock(JCTree.JCBlock block) {
        return Block.newBuilder().setSourcePosition(this.getSourcePosition(block)).setStatements((Collection)block.getStatements().stream().map(this::convertStatement).filter((Predicate<Statement>)Predicates.notNull()).collect(ImmutableList.toImmutableList())).build();
    }

    private Variable createVariable(JCTree.JCVariableDecl variableDeclaration, boolean isParameter) {
        Symbol.VarSymbol variableElement = variableDeclaration.sym;
        Variable variable = this.environment.createVariable(this.getNamePosition(variableElement.getSimpleName().toString(), variableDeclaration), variableElement, isParameter);
        this.variableByVariableElement.put(variableElement, variable);
        return variable;
    }

    private Method.Builder newMethodBuilder(ExecutableElement methodElement) {
        MethodDescriptor methodDescriptor = this.environment.createDeclarationMethodDescriptor(methodElement);
        return Method.newBuilder().setMethodDescriptor(methodDescriptor);
    }

    private Literal convertConstantToLiteral(VariableElement variableElement) {
        return Literal.fromValue((Object)variableElement.getConstantValue(), (TypeDescriptor)this.environment.createTypeDescriptor(variableElement.asType()));
    }

    private AssertStatement convertAssert(JCTree.JCAssert statement) {
        return AssertStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setExpression(this.convertExpression(statement.getCondition())).setMessage(this.convertExpressionOrNull(statement.getDetail())).build();
    }

    private LabeledStatement convertLabeledStatement(JCTree.JCLabeledStatement statement) {
        Label label = Label.newBuilder().setName(statement.getLabel().toString()).build();
        Preconditions.checkState((this.labelsInScope.put(label.getName(), label) == null ? 1 : 0) != 0);
        LabeledStatement labeledStatment = LabeledStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setLabel(label).setStatement(this.convertStatement(statement.getStatement())).build();
        this.labelsInScope.remove(label.getName());
        return labeledStatment;
    }

    private BreakStatement convertBreak(JCTree.JCBreak statement) {
        return BreakStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setLabelReference(this.getLabelReferenceOrNull(statement.getLabel())).build();
    }

    private ContinueStatement convertContinue(JCTree.JCContinue statement) {
        return ContinueStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setLabelReference(this.getLabelReferenceOrNull(statement.getLabel())).build();
    }

    @Nullable
    private LabelReference getLabelReferenceOrNull(Name label) {
        return label == null ? null : this.labelsInScope.get(label.toString()).createReference();
    }

    private DoWhileStatement convertDoWhileLoop(JCTree.JCDoWhileLoop statement) {
        return (DoWhileStatement)((DoWhileStatement.Builder)((DoWhileStatement.Builder)((DoWhileStatement.Builder)DoWhileStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement))).setConditionExpression(this.convertConditionRemovingOuterParentheses(statement.getCondition()))).setBody(this.convertStatement(statement.getStatement()))).build();
    }

    private Statement convertExpressionStatement(JCTree.JCExpressionStatement statement) {
        return this.convertExpression(statement.getExpression()).makeStatement(this.getSourcePosition(statement));
    }

    private ForStatement convertForLoop(JCTree.JCForLoop statement) {
        return (ForStatement)((ForStatement.Builder)((ForStatement.Builder)((ForStatement.Builder)ForStatement.newBuilder().setInitializers(this.convertInitializers(statement.getInitializer())).setConditionExpression((Expression)(statement.getCondition() == null ? BooleanLiteral.get((boolean)true) : this.convertExpression(statement.getCondition())))).setBody(this.convertStatement(statement.getStatement()))).setUpdates(this.convertExpressions((java.util.List)statement.getUpdate().stream().map(JCTree.JCExpressionStatement::getExpression).collect(ImmutableList.toImmutableList()))).setSourcePosition(this.getSourcePosition(statement))).build();
    }

    private java.util.List<Expression> convertInitializers(java.util.List<JCTree.JCStatement> statements) {
        if (statements.stream().anyMatch(s -> s.getKind() == Tree.Kind.VARIABLE)) {
            return this.convertVariableDeclarations(statements);
        }
        return (java.util.List)statements.stream().map(this::convertInitializer).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<Expression> convertVariableDeclarations(java.util.List<JCTree.JCStatement> statements) {
        return ImmutableList.of((Object)VariableDeclarationExpression.newBuilder().addVariableDeclarationFragments((Collection)statements.stream().map(s -> this.createVariableDeclarationFragment((JCTree.JCVariableDecl)s)).collect(ImmutableList.toImmutableList())).build());
    }

    private Expression convertInitializer(JCTree.JCStatement statement) {
        switch (statement.getKind()) {
            case EXPRESSION_STATEMENT: {
                return this.convertExpression(((JCTree.JCExpressionStatement)statement).expr);
            }
        }
        throw new AssertionError();
    }

    private ForEachStatement convertEnhancedForLoop(JCTree.JCEnhancedForLoop statement) {
        return (ForEachStatement)((ForEachStatement.Builder)((ForEachStatement.Builder)ForEachStatement.newBuilder().setLoopVariable(this.createVariable(statement.getVariable(), false)).setIterableExpression(this.convertExpression(statement.getExpression())).setBody(this.convertStatement(statement.getStatement()))).setSourcePosition(this.getSourcePosition(statement))).build();
    }

    private IfStatement convertIf(JCTree.JCIf statement) {
        return IfStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setConditionExpression(this.convertConditionRemovingOuterParentheses(statement.getCondition())).setThenStatement(this.convertStatement(statement.getThenStatement())).setElseStatement(this.convertStatementOrNull(statement.getElseStatement())).build();
    }

    private WhileStatement convertWhileLoop(JCTree.JCWhileLoop statement) {
        return (WhileStatement)((WhileStatement.Builder)((WhileStatement.Builder)((WhileStatement.Builder)WhileStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement))).setConditionExpression(this.convertConditionRemovingOuterParentheses(statement.getCondition()))).setBody(this.convertStatement(statement.getStatement()))).build();
    }

    private SwitchStatement convertSwitch(JCTree.JCSwitch switchStatement) {
        return SwitchStatement.newBuilder().setSourcePosition(this.getSourcePosition(switchStatement)).setSwitchExpression(this.convertExpressionOrNull(switchStatement.getExpression())).setCases((Collection)switchStatement.getCases().stream().map(caseClause -> SwitchCase.newBuilder().setCaseExpression(this.convertExpressionOrNull(caseClause.getExpression())).setStatements(this.convertStatements(caseClause.getStatements())).build()).collect(ImmutableList.toImmutableList())).build();
    }

    private ThrowStatement convertThrow(JCTree.JCThrow statement) {
        return ThrowStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setExpression(this.convertExpression(statement.getExpression())).build();
    }

    private TryStatement convertTry(JCTree.JCTry statement) {
        java.util.List catchClauses = statement.getCatches();
        return TryStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setResourceDeclarations((java.util.List)statement.getResources().stream().map(this::toResource).collect(ImmutableList.toImmutableList())).setBody(this.convertBlock(statement.getBlock())).setCatchClauses((java.util.List)catchClauses.stream().map(this::convertCatchClause).collect(ImmutableList.toImmutableList())).setFinallyBlock((Block)this.convertStatementOrNull(statement.getFinallyBlock())).build();
    }

    private VariableDeclarationExpression toResource(JCTree resourceTree) {
        if (resourceTree.getTag() == JCTree.Tag.VARDEF) {
            return this.createVariableDeclarationExpression((JCTree.JCVariableDecl)resourceTree);
        }
        Preconditions.checkArgument((resourceTree.getTag() == JCTree.Tag.IDENT ? 1 : 0) != 0);
        return this.toResource((JCTree.JCIdent)resourceTree);
    }

    private VariableDeclarationExpression toResource(JCTree.JCIdent ident) {
        Expression expression = this.convertIdent(ident);
        return VariableDeclarationExpression.newBuilder().addVariableDeclaration(Variable.newBuilder().setName("$resource").setTypeDescriptor(expression.getTypeDescriptor()).setFinal(true).build(), expression).build();
    }

    private CatchClause convertCatchClause(JCTree.JCCatch catchClause) {
        return CatchClause.newBuilder().setExceptionVariable(this.createVariable(catchClause.getParameter(), false)).setBody(this.convertBlock(catchClause.getBlock())).build();
    }

    private ReturnStatement convertReturn(JCTree.JCReturn statement) {
        return ReturnStatement.newBuilder().setExpression(this.convertExpressionOrNull(statement.getExpression())).setSourcePosition(this.getSourcePosition(statement)).build();
    }

    private SynchronizedStatement convertSynchronized(JCTree.JCSynchronized statement) {
        return SynchronizedStatement.newBuilder().setSourcePosition(this.getSourcePosition(statement)).setExpression(this.convertExpression(statement.getExpression())).setBody(this.convertBlock(statement.getBlock())).build();
    }

    private Statement convertVariableDeclaration(JCTree.JCVariableDecl variableDeclaration) {
        return this.createVariableDeclarationExpression(variableDeclaration).makeStatement(this.getSourcePosition(variableDeclaration));
    }

    private VariableDeclarationExpression createVariableDeclarationExpression(JCTree.JCVariableDecl variableDeclaration) {
        return VariableDeclarationExpression.newBuilder().addVariableDeclarationFragments(new VariableDeclarationFragment[]{this.createVariableDeclarationFragment(variableDeclaration)}).build();
    }

    private VariableDeclarationFragment createVariableDeclarationFragment(JCTree.JCVariableDecl variableDeclaration) {
        Variable variable = this.createVariable(variableDeclaration, false);
        return VariableDeclarationFragment.newBuilder().setVariable(variable).setInitializer(this.convertExpressionOrNull(variableDeclaration.getInitializer())).build();
    }

    @Nullable
    private Statement convertStatement(JCTree.JCStatement jcStatement) {
        switch (jcStatement.getKind()) {
            case ASSERT: {
                return this.convertAssert((JCTree.JCAssert)jcStatement);
            }
            case BLOCK: {
                return this.convertBlock((JCTree.JCBlock)jcStatement);
            }
            case BREAK: {
                return this.convertBreak((JCTree.JCBreak)jcStatement);
            }
            case CLASS: {
                this.convertClassDeclaration((JCTree.JCClassDecl)jcStatement);
                return null;
            }
            case CONTINUE: {
                return this.convertContinue((JCTree.JCContinue)jcStatement);
            }
            case DO_WHILE_LOOP: {
                return this.convertDoWhileLoop((JCTree.JCDoWhileLoop)jcStatement);
            }
            case EMPTY_STATEMENT: {
                return Statement.createNoopStatement();
            }
            case ENHANCED_FOR_LOOP: {
                return this.convertEnhancedForLoop((JCTree.JCEnhancedForLoop)jcStatement);
            }
            case EXPRESSION_STATEMENT: {
                return this.convertExpressionStatement((JCTree.JCExpressionStatement)jcStatement);
            }
            case FOR_LOOP: {
                return this.convertForLoop((JCTree.JCForLoop)jcStatement);
            }
            case IF: {
                return this.convertIf((JCTree.JCIf)jcStatement);
            }
            case LABELED_STATEMENT: {
                return this.convertLabeledStatement((JCTree.JCLabeledStatement)jcStatement);
            }
            case RETURN: {
                return this.convertReturn((JCTree.JCReturn)jcStatement);
            }
            case SWITCH: {
                return this.convertSwitch((JCTree.JCSwitch)jcStatement);
            }
            case THROW: {
                return this.convertThrow((JCTree.JCThrow)jcStatement);
            }
            case TRY: {
                return this.convertTry((JCTree.JCTry)jcStatement);
            }
            case VARIABLE: {
                return this.convertVariableDeclaration((JCTree.JCVariableDecl)jcStatement);
            }
            case WHILE_LOOP: {
                return this.convertWhileLoop((JCTree.JCWhileLoop)jcStatement);
            }
            case SYNCHRONIZED: {
                return this.convertSynchronized((JCTree.JCSynchronized)jcStatement);
            }
        }
        throw new AssertionError((Object)("Unknown statement node type: " + jcStatement.getKind()));
    }

    @Nullable
    private Statement convertStatementOrNull(JCTree.JCStatement statement) {
        return statement != null ? this.convertStatement(statement) : null;
    }

    private ImmutableList<Statement> convertStatements(java.util.List<JCTree.JCStatement> statements) {
        return (ImmutableList)statements.stream().map(this::convertStatement).collect(ImmutableList.toImmutableList());
    }

    private SourcePosition getSourcePosition(JCTree node) {
        return this.getSourcePosition(null, node);
    }

    private SourcePosition getSourcePosition(String name, JCTree node) {
        int startCharacterPosition = node.getStartPosition();
        int endCharacterPosition = this.guessEndPosition(node);
        return this.getSourcePosition(name, startCharacterPosition, endCharacterPosition);
    }

    private SourcePosition getSourcePosition(String name, int startCharacterPosition, int endCharacterPosition) {
        int startLine = this.javacUnit.getLineMap().getLineNumber(startCharacterPosition) - 1;
        int startColumn = this.javacUnit.getLineMap().getColumnNumber(startCharacterPosition) - 1;
        int endLine = this.javacUnit.getLineMap().getLineNumber(endCharacterPosition) - 1;
        int endColumn = this.javacUnit.getLineMap().getColumnNumber(endCharacterPosition) - 1;
        return SourcePosition.newBuilder().setFilePath(this.javacUnit.getSourceFile().getName()).setPackageRelativePath(this.getCurrentCompilationUnit().getPackageRelativePath()).setName(name).setStartFilePosition(FilePosition.newBuilder().setLine(startLine).setColumn(startColumn).setByteOffset(startCharacterPosition).build()).setEndFilePosition(FilePosition.newBuilder().setLine(endLine).setColumn(endColumn).setByteOffset(endCharacterPosition + 1).build()).build();
    }

    private int guessEndPosition(JCTree node) {
        int startCharacterPosition = node.getStartPosition();
        int endCharacterPosition = node.getEndPosition(this.javacUnit.endPositions);
        if (endCharacterPosition == -1) {
            try {
                String src = this.javacUnit.sourcefile.getCharContent(true).toString();
                endCharacterPosition = startCharacterPosition;
                while (endCharacterPosition < src.length() && Character.isJavaIdentifierPart(src.charAt(endCharacterPosition++))) {
                }
            }
            catch (IOException e) {
                throw this.internalCompilerError(e, "Error getting endPosition for: %s.", new Object[]{node});
            }
        }
        return endCharacterPosition;
    }

    private SourcePosition getNamePosition(JCTree node) {
        return this.getNamePosition(null, node);
    }

    @Nullable
    private SourcePosition getNamePosition(String name, JCTree node) {
        int start = node.getPreferredPosition();
        if (start == -1) {
            return null;
        }
        try {
            String src = this.javacUnit.sourcefile.getCharContent(true).toString();
            Tree.Kind kind = node.getKind();
            if (kind == Tree.Kind.ANNOTATION_TYPE || kind == Tree.Kind.CLASS || kind == Tree.Kind.ENUM || kind == Tree.Kind.INTERFACE) {
                while (src.charAt(start++) != ' ') {
                }
            } else if (kind != Tree.Kind.METHOD && kind != Tree.Kind.VARIABLE) {
                return this.getSourcePosition(node);
            }
            if (!Character.isJavaIdentifierStart(src.charAt(start))) {
                return this.getSourcePosition(node);
            }
            int endPos = start + 1;
            while (Character.isJavaIdentifierPart(src.charAt(endPos))) {
                ++endPos;
            }
            return this.getSourcePosition(name, start, endPos);
        }
        catch (IOException e) {
            throw this.internalCompilerError(e, "Error getting name Position for: %s.", new Object[]{node});
        }
    }

    private ArrayAccess convertArrayAccess(JCTree.JCArrayAccess expression) {
        return ArrayAccess.newBuilder().setArrayExpression(this.convertExpression(expression.getExpression())).setIndexExpression(this.convertExpression(expression.getIndex())).build();
    }

    private BinaryExpression convertAssignment(JCTree.JCAssign expression) {
        return BinaryExpression.newBuilder().setLeftOperand(this.convertExpression(expression.getVariable())).setOperator(JavaEnvironment.getBinaryOperator(expression.getKind())).setRightOperand(this.convertExpression(expression.getExpression())).build();
    }

    private BinaryExpression convertAssignment(JCTree.JCAssignOp expression) {
        return BinaryExpression.newBuilder().setLeftOperand(this.convertExpression(expression.getVariable())).setOperator(JavaEnvironment.getBinaryOperator(expression.getKind())).setRightOperand(this.convertExpression(expression.getExpression())).build();
    }

    private BinaryExpression convertBinary(JCTree.JCBinary expression) {
        return BinaryExpression.newBuilder().setLeftOperand(this.convertExpression(expression.getLeftOperand())).setOperator(JavaEnvironment.getBinaryOperator(expression.getKind())).setRightOperand(this.convertExpression(expression.getRightOperand())).build();
    }

    private UnaryExpression convertPostfixUnary(JCTree.JCUnary expression) {
        return ((PostfixExpression.Builder)((PostfixExpression.Builder)PostfixExpression.newBuilder().setOperand(this.convertExpression(expression.getExpression()))).setOperator((Operator)JavaEnvironment.getPostfixOperator(expression.getKind()))).build();
    }

    private UnaryExpression convertPrefixUnary(JCTree.JCUnary expression) {
        return ((PrefixExpression.Builder)((PrefixExpression.Builder)PrefixExpression.newBuilder().setOperand(this.convertExpression(expression.getExpression()))).setOperator((Operator)JavaEnvironment.getPrefixOperator(expression.getKind()))).build();
    }

    private CastExpression convertCast(JCTree.JCTypeCast expression) {
        TypeDescriptor castTypeDescriptor = this.environment.createTypeDescriptor(expression.getType().type);
        return CastExpression.newBuilder().setExpression(this.convertExpression(expression.getExpression())).setCastTypeDescriptor(castTypeDescriptor).build();
    }

    private ConditionalExpression convertConditional(JCTree.JCConditional conditionalExpression) {
        return ConditionalExpression.newBuilder().setTypeDescriptor(this.environment.createTypeDescriptor(conditionalExpression.type)).setConditionExpression(this.convertExpression(conditionalExpression.getCondition())).setTrueExpression(this.convertExpression(conditionalExpression.getTrueExpression())).setFalseExpression(this.convertExpression(conditionalExpression.getFalseExpression())).build();
    }

    private InstanceOfExpression convertInstanceOf(JCTree.JCInstanceOf expression) {
        return InstanceOfExpression.newBuilder().setSourcePosition(this.getSourcePosition(expression)).setExpression(this.convertExpression(expression.getExpression())).setTestTypeDescriptor(this.environment.createTypeDescriptor(expression.getType().type)).build();
    }

    private Expression convertLambda(JCTree.JCLambda expression) {
        MethodDescriptor functionalMethodDescriptor = this.environment.getJsFunctionMethodDescriptor(expression.type);
        return FunctionExpression.newBuilder().setTypeDescriptor(this.getTargetType(expression)).setParameters((java.util.List)expression.getParameters().stream().map(variable -> this.createVariable((JCTree.JCVariableDecl)variable, true)).collect(ImmutableList.toImmutableList())).setStatements(this.convertLambdaBody(expression.getBody(), functionalMethodDescriptor.getReturnTypeDescriptor()).getStatements()).setSourcePosition(this.getSourcePosition(expression)).build();
    }

    private TypeDescriptor getTargetType(JCTree.JCFunctionalExpression expression) {
        return this.environment.createTypeDescriptor(expression.type);
    }

    private Block convertLambdaBody(JCTree lambdaBody, TypeDescriptor returnTypeDescriptor) {
        Block body;
        if (lambdaBody.getKind() == Tree.Kind.BLOCK) {
            body = this.convertBlock((JCTree.JCBlock)lambdaBody);
        } else {
            Preconditions.checkArgument((boolean)(lambdaBody instanceof JCTree.JCExpression));
            Expression lambdaMethodBody = this.convertExpression((JCTree.JCExpression)lambdaBody);
            Statement statement = AstUtils.createReturnOrExpressionStatement((SourcePosition)this.getSourcePosition(lambdaBody), (Expression)lambdaMethodBody, (TypeDescriptor)returnTypeDescriptor);
            body = Block.newBuilder().setSourcePosition(this.getSourcePosition(lambdaBody)).setStatements(new Statement[]{statement}).build();
        }
        return body;
    }

    private Expression convertMemberReference(JCTree.JCMemberReference memberReference) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)memberReference.sym;
        DeclaredTypeDescriptor expressionTypeDescriptor = this.environment.createDeclaredTypeDescriptor(memberReference.type);
        MethodDescriptor functionalMethodDescriptor = this.environment.getJsFunctionMethodDescriptor(memberReference.type);
        if (((Symbol)methodSymbol.getEnclosingElement()).getQualifiedName().contentEquals("Array")) {
            return ArrayCreationReference.newBuilder().setTargetTypeDescriptor(this.environment.createTypeDescriptor((TypeMirror)memberReference.getQualifierExpression().type, ArrayTypeDescriptor.class)).setInterfaceMethodDescriptor(functionalMethodDescriptor).setSourcePosition(this.getSourcePosition(memberReference)).build();
        }
        com.sun.tools.javac.code.Type returnType = methodSymbol.isConstructor() ? ((Symbol)methodSymbol.getEnclosingElement()).asType() : memberReference.referentType.getReturnType();
        MethodDescriptor targetMethodDescriptor = this.environment.createMethodDescriptor((ExecutableType)((Object)memberReference.referentType), returnType, (ExecutableElement)methodSymbol);
        Expression qualifier = this.convertExpressionOrNull(memberReference.getQualifierExpression());
        return MethodReference.newBuilder().setTypeDescriptor((TypeDescriptor)expressionTypeDescriptor).setReferencedMethodDescriptor(targetMethodDescriptor).setInterfaceMethodDescriptor(functionalMethodDescriptor).setQualifier(qualifier).setSourcePosition(this.getSourcePosition(memberReference)).build();
    }

    private NewArray convertNewArray(JCTree.JCNewArray expression) {
        ArrayTypeDescriptor typeDescriptor = this.environment.createTypeDescriptor((TypeMirror)expression.type, ArrayTypeDescriptor.class);
        java.util.List<Expression> dimensionExpressions = this.convertExpressions(expression.getDimensions());
        AstUtils.addNullPadding(dimensionExpressions, (int)typeDescriptor.getDimensions());
        ArrayLiteral arrayLiteral = expression.getInitializers() == null ? null : new ArrayLiteral(typeDescriptor, this.convertExpressions(expression.getInitializers()));
        return NewArray.newBuilder().setTypeDescriptor(typeDescriptor).setDimensionExpressions(dimensionExpressions).setInitializer((Expression)arrayLiteral).build();
    }

    private static StringLiteral convertStringLiteral(JCTree.JCLiteral literal) {
        return new StringLiteral((String)literal.getValue());
    }

    private static BooleanLiteral convertBooleanLiteral(JCTree.JCLiteral literal) {
        return BooleanLiteral.get((boolean)((Boolean)literal.getValue()));
    }

    private static NumberLiteral convertCharLiteral(JCTree.JCLiteral literal) {
        return NumberLiteral.fromChar((int)((Character)literal.getValue()).charValue());
    }

    private NumberLiteral convertNumberLiteral(JCTree.JCLiteral literal) {
        return new NumberLiteral((PrimitiveTypeDescriptor)this.environment.createTypeDescriptor(literal.type), (Number)literal.getValue());
    }

    @Nullable
    private Expression convertFieldAccess(JCTree.JCFieldAccess fieldAccess) {
        JCTree.JCExpression expression = fieldAccess.getExpression();
        if (fieldAccess.name.contentEquals("class")) {
            return new TypeLiteral(this.getSourcePosition(fieldAccess), this.environment.createTypeDescriptor(expression.type));
        }
        if (fieldAccess.name.contentEquals("this")) {
            return new ThisReference(this.environment.createDeclarationForType((Symbol.ClassSymbol)((JCTree.JCIdent)expression).sym).toUnparameterizedTypeDescriptor(), true);
        }
        if (fieldAccess.name.contentEquals("super")) {
            return new SuperReference(this.environment.createDeclarationForType((Symbol.ClassSymbol)((JCTree.JCIdent)expression).sym).toUnparameterizedTypeDescriptor());
        }
        if (fieldAccess.sym instanceof VariableElement) {
            Expression qualifier = this.convertExpression(expression);
            if (qualifier instanceof JavaScriptConstructorReference) {
                Preconditions.checkState((boolean)fieldAccess.sym.isStatic());
                qualifier = null;
            }
            if (fieldAccess.name.contentEquals("length") && qualifier.getTypeDescriptor().isArray()) {
                return ArrayLength.newBuilder().setArrayExpression(qualifier).build();
            }
            FieldDescriptor fieldDescriptor = this.environment.createFieldDescriptor((VariableElement)((Object)fieldAccess.sym), fieldAccess.type);
            return ((FieldAccess.Builder)((FieldAccess.Builder)FieldAccess.newBuilder().setQualifier(qualifier)).setTarget((MemberDescriptor)fieldDescriptor)).build();
        }
        return null;
    }

    private Expression convertNewClass(JCTree.JCNewClass expression) {
        Type anonymousInnerClass = expression.getClassBody() != null ? this.convertClassDeclaration(expression.getClassBody(), expression) : null;
        Symbol.MethodSymbol constructorBinding = (Symbol.MethodSymbol)expression.constructor;
        DeclaredTypeDescriptor targetType = this.environment.createDeclaredTypeDescriptor(expression.type);
        MethodDescriptor constructorMethodDescriptor = this.environment.createMethodDescriptor(targetType, (Symbol.MethodSymbol)constructorBinding.asMemberOf(expression.type, this.environment.internalTypes), (ExecutableElement)constructorBinding);
        Expression qualifier = this.convertExpressionOrNull(expression.getEnclosingExpression());
        java.util.List<Expression> arguments = this.convertArguments(constructorMethodDescriptor, expression.getArguments());
        DeclaredTypeDescriptor targetClassDescriptor = constructorMethodDescriptor.getEnclosingTypeDescriptor();
        if (targetClassDescriptor.getTypeDeclaration().isAnonymous() && qualifier != null) {
            arguments.add(0, qualifier);
            qualifier = null;
        }
        boolean needsQualifier = constructorMethodDescriptor.getEnclosingTypeDescriptor().getTypeDeclaration().isCapturingEnclosingInstance();
        Preconditions.checkArgument((qualifier == null || needsQualifier ? 1 : 0) != 0, (Object)"NewInstance of non nested class should have no qualifier.");
        return ((NewInstance.Builder)((NewInstance.Builder)NewInstance.Builder.from((MethodDescriptor)constructorMethodDescriptor).setAnonymousInnerClass(anonymousInnerClass).setQualifier(qualifier)).setArguments(arguments)).build();
    }

    private Expression convertMethodInvocation(JCTree.JCMethodInvocation methodInvocation) {
        JCTree.JCExpression jcQualifier = CompilationUnitBuilder.getExplicitQualifier(methodInvocation);
        Expression qualifier = this.convertExpressionOrNull(jcQualifier);
        Symbol.MethodSymbol methodSymbol = CompilationUnitBuilder.getMemberSymbol(methodInvocation.getMethodSelect());
        MethodDescriptor methodDescriptor = this.environment.createMethodDescriptor((ExecutableType)((Object)methodInvocation.getMethodSelect().type), methodInvocation.type, (ExecutableElement)methodSymbol);
        if (methodDescriptor.isConstructor() && methodDescriptor.isMemberOf(TypeDescriptors.get().javaLangEnum)) {
            Preconditions.checkArgument((methodDescriptor.getParameterDescriptors().size() == ((List)methodInvocation.getArguments()).size() + 2 ? 1 : 0) != 0);
            methodDescriptor = MethodDescriptor.Builder.from((MethodDescriptor)methodDescriptor).setParameterDescriptors(ImmutableList.of()).makeDeclaration().build();
        }
        java.util.List<Expression> arguments = this.convertArguments(methodDescriptor, methodInvocation.getArguments());
        if (CompilationUnitBuilder.isSuperConstructorCall(methodInvocation)) {
            return ((MethodCall.Builder)((MethodCall.Builder)MethodCall.Builder.from((MethodDescriptor)methodDescriptor).setQualifier(qualifier)).setArguments(arguments)).setSourcePosition(this.getSourcePosition(methodInvocation)).build();
        }
        boolean hasSuperQualifier = CompilationUnitBuilder.isSuperExpression(jcQualifier);
        boolean isStaticDispatch = CompilationUnitBuilder.isQualifiedSuperExpression(jcQualifier);
        if (hasSuperQualifier && (qualifier.getTypeDescriptor().isInterface() || methodDescriptor.isDefaultMethod())) {
            isStaticDispatch = true;
        }
        return ((MethodCall.Builder)((MethodCall.Builder)MethodCall.Builder.from((MethodDescriptor)methodDescriptor).setQualifier(qualifier)).setArguments(arguments)).setStaticDispatch(isStaticDispatch).setSourcePosition(this.getSourcePosition(methodInvocation)).build();
    }

    private java.util.List<Expression> convertArguments(MethodDescriptor methodDescriptor, java.util.List<JCTree.JCExpression> argumentExpressions) {
        java.util.List arguments = (java.util.List)argumentExpressions.stream().map(this::convertExpression).collect(ImmutableList.toImmutableList());
        return AstUtils.maybePackageVarargs((MethodDescriptor)methodDescriptor, (java.util.List)arguments);
    }

    @Nullable
    private static JCTree.JCExpression getExplicitQualifier(JCTree.JCMethodInvocation methodInvocation) {
        if (methodInvocation.getMethodSelect().getKind() != Tree.Kind.IDENTIFIER) {
            return CompilationUnitBuilder.getQualifier(methodInvocation.getMethodSelect());
        }
        Symbol.MethodSymbol memberSymbol = CompilationUnitBuilder.getMemberSymbol(methodInvocation.getMethodSelect());
        if (memberSymbol.isStatic()) {
            return null;
        }
        return CompilationUnitBuilder.getQualifier(methodInvocation.getMethodSelect());
    }

    private Expression convertIdent(JCTree.JCIdent identifier) {
        if (CompilationUnitBuilder.isThisExpression(identifier)) {
            return new ThisReference(this.getCurrentType().getTypeDescriptor());
        }
        if (CompilationUnitBuilder.isSuperExpression(identifier)) {
            return new SuperReference(this.getCurrentType().getTypeDescriptor());
        }
        Symbol symbol = identifier.sym;
        if (symbol instanceof Symbol.ClassSymbol) {
            return new JavaScriptConstructorReference(this.environment.createDeclarationForType((Symbol.ClassSymbol)identifier.sym));
        }
        if (symbol instanceof Symbol.MethodSymbol) {
            throw new AssertionError((Object)("Unexpected symbol class: " + symbol.getClass()));
        }
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
        if (symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.RESOURCE_VARIABLE || symbol.getKind() == ElementKind.PARAMETER || symbol.getKind() == ElementKind.EXCEPTION_PARAMETER) {
            Variable variable = this.variableByVariableElement.get(symbol);
            return variable.createReference();
        }
        FieldDescriptor fieldDescriptor = this.environment.createFieldDescriptor(varSymbol, identifier.type);
        return ((FieldAccess.Builder)FieldAccess.newBuilder().setTarget((MemberDescriptor)fieldDescriptor)).build();
    }

    private static boolean isSuperConstructorCall(JCTree.JCMethodInvocation methodInvocation) {
        return CompilationUnitBuilder.isSuperExpression(methodInvocation.getMethodSelect());
    }

    private static boolean isSuperExpression(JCTree.JCExpression expression) {
        if (expression instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)expression;
            return ident.getName().contentEquals("super");
        }
        return false;
    }

    private static boolean isQualifiedSuperExpression(JCTree.JCExpression expression) {
        return expression instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)expression).getIdentifier().contentEquals("super");
    }

    private static boolean isThisExpression(JCTree.JCExpression expression) {
        if (expression instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)expression;
            return ident.getName().contentEquals("this");
        }
        return false;
    }

    private static Symbol.MethodSymbol getMemberSymbol(JCTree.JCExpression node) {
        switch (node.getKind()) {
            case IDENTIFIER: {
                return (Symbol.MethodSymbol)((JCTree.JCIdent)node).sym.baseSymbol();
            }
            case MEMBER_SELECT: {
                return (Symbol.MethodSymbol)((JCTree.JCFieldAccess)node).sym;
            }
        }
        throw new AssertionError((Object)("Unexpected tree kind: " + node.getKind()));
    }

    @Nullable
    private static JCTree.JCExpression getQualifier(JCTree.JCExpression node) {
        switch (node.getKind()) {
            case IDENTIFIER: {
                return null;
            }
            case MEMBER_SELECT: {
                return ((JCTree.JCFieldAccess)node).getExpression();
            }
        }
        throw new AssertionError((Object)("Unexpected tree kind: " + node.getKind()));
    }

    private Expression convertConditionRemovingOuterParentheses(JCTree.JCExpression expression) {
        return this.convertExpression(((JCTree.JCParens)expression).getExpression());
    }

    private Expression convertParens(JCTree.JCParens expression) {
        return this.convertExpression(expression.getExpression());
    }

    @Nullable
    private Expression convertExpression(JCTree.JCExpression jcExpression) {
        switch (jcExpression.getKind()) {
            case ARRAY_ACCESS: {
                return this.convertArrayAccess((JCTree.JCArrayAccess)jcExpression);
            }
            case ASSIGNMENT: {
                return this.convertAssignment((JCTree.JCAssign)jcExpression);
            }
            case CONDITIONAL_EXPRESSION: {
                return this.convertConditional((JCTree.JCConditional)jcExpression);
            }
            case IDENTIFIER: {
                return this.convertIdent((JCTree.JCIdent)jcExpression);
            }
            case PARAMETERIZED_TYPE: {
                return null;
            }
            case INSTANCE_OF: {
                return this.convertInstanceOf((JCTree.JCInstanceOf)jcExpression);
            }
            case LAMBDA_EXPRESSION: {
                return this.convertLambda((JCTree.JCLambda)jcExpression);
            }
            case MEMBER_REFERENCE: {
                return this.convertMemberReference((JCTree.JCMemberReference)jcExpression);
            }
            case MEMBER_SELECT: {
                return this.convertFieldAccess((JCTree.JCFieldAccess)jcExpression);
            }
            case METHOD_INVOCATION: {
                return this.convertMethodInvocation((JCTree.JCMethodInvocation)jcExpression);
            }
            case NEW_ARRAY: {
                return this.convertNewArray((JCTree.JCNewArray)jcExpression);
            }
            case NEW_CLASS: {
                return this.convertNewClass((JCTree.JCNewClass)jcExpression);
            }
            case PARENTHESIZED: {
                return this.convertParens((JCTree.JCParens)jcExpression);
            }
            case TYPE_CAST: {
                return this.convertCast((JCTree.JCTypeCast)jcExpression);
            }
            case BOOLEAN_LITERAL: {
                return CompilationUnitBuilder.convertBooleanLiteral((JCTree.JCLiteral)jcExpression);
            }
            case CHAR_LITERAL: {
                return CompilationUnitBuilder.convertCharLiteral((JCTree.JCLiteral)jcExpression);
            }
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: {
                return this.convertNumberLiteral((JCTree.JCLiteral)jcExpression);
            }
            case STRING_LITERAL: {
                return CompilationUnitBuilder.convertStringLiteral((JCTree.JCLiteral)jcExpression);
            }
            case NULL_LITERAL: {
                return this.environment.createTypeDescriptor(jcExpression.type).getNullValue();
            }
            case AND: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                return this.convertBinary((JCTree.JCBinary)jcExpression);
            }
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                return this.convertPrefixUnary((JCTree.JCUnary)jcExpression);
            }
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: {
                return this.convertPostfixUnary((JCTree.JCUnary)jcExpression);
            }
            case AND_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case XOR_ASSIGNMENT: {
                return this.convertAssignment((JCTree.JCAssignOp)jcExpression);
            }
            case OTHER: {
                if (!jcExpression.hasTag(JCTree.Tag.NULLCHK)) break;
                return RuntimeMethods.createCheckNotNullCall((Expression)this.convertExpression(((JCTree.JCUnary)jcExpression).arg));
            }
        }
        throw new AssertionError((Object)("Unknown expression " + jcExpression + " (node type: " + jcExpression.getKind() + ")"));
    }

    @Nullable
    private Expression convertExpressionOrNull(JCTree.JCExpression expression) {
        return expression != null ? this.convertExpression(expression) : null;
    }

    private java.util.List<Expression> convertExpressions(java.util.List<JCTree.JCExpression> expressions) {
        return (java.util.List)expressions.stream().map(this::convertExpression).collect(ImmutableList.toImmutableList());
    }

    private CompilationUnit build(JCTree.JCCompilationUnit javacUnit) {
        this.javacUnit = javacUnit;
        if (javacUnit.getSourceFile().getName().endsWith("package-info.java") && javacUnit.getPackage() != null) {
            String packageName = javacUnit.getPackageName().toString();
            String packageJsNamespace = CompilationUnitBuilder.getPackageJsNamespace(javacUnit);
            boolean isNullMarked = CompilationUnitBuilder.isNullMarked(javacUnit);
            PackageInfoCache.get().setPackageProperties("[source]", packageName, packageJsNamespace, null, isNullMarked);
        }
        this.setCurrentCompilationUnit(CompilationUnit.createForFile((String)javacUnit.getSourceFile().getName(), (String)(javacUnit.getPackageName() == null ? "" : javacUnit.getPackageName().toString())));
        for (JCTree tree : javacUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            this.convertClassDeclaration((JCTree.JCClassDecl)tree);
        }
        return this.getCurrentCompilationUnit();
    }

    public static ImmutableList<CompilationUnit> build(java.util.List<CompilationUnitTree> compilationUnits, JavaEnvironment javaEnvironment) {
        CompilationUnitBuilder compilationUnitBuilder = new CompilationUnitBuilder(javaEnvironment);
        CompilationUnitBuilder.sortPackageInfoFirst(compilationUnits);
        return (ImmutableList)compilationUnits.stream().map(JCTree.JCCompilationUnit.class::cast).map(compilationUnitBuilder::build).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static String getPackageJsNamespace(JCTree.JCCompilationUnit javacUnit) {
        Symbol.PackageSymbol packge = javacUnit.packge;
        if (packge == null) {
            return null;
        }
        return JsInteropAnnotationUtils.getJsNamespace(packge);
    }

    private static boolean isNullMarked(JCTree.JCCompilationUnit javacUnit) {
        Symbol.PackageSymbol packge = javacUnit.packge;
        if (packge == null) {
            return false;
        }
        return packge.getAnnotationMirrors().stream().anyMatch(a -> Nullability.isNullMarkedAnnotation((String)AnnotationUtils.getAnnotationName(a)));
    }

    private static void sortPackageInfoFirst(java.util.List<CompilationUnitTree> compilationUnits) {
        Collections.sort(compilationUnits, (thisCompilationUnit, thatCompilationUnit) -> {
            String thisFilePath = thisCompilationUnit.getSourceFile().getName();
            String thatFilePath = thatCompilationUnit.getSourceFile().getName();
            boolean thisIsPackageInfo = thisFilePath.endsWith("package-info.java");
            boolean thatIsPackageInfo = thatFilePath.endsWith("package-info.java");
            return ComparisonChain.start().compareTrueFirst(thisIsPackageInfo, thatIsPackageInfo).compare((Comparable)((Object)thisFilePath), (Comparable)((Object)thatFilePath)).result();
        });
    }
}

