/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.j2cl.common.InternalCompilerError;
import com.google.j2cl.common.SourcePosition;
import com.google.j2cl.transpiler.ast.ArrayTypeDescriptor;
import com.google.j2cl.transpiler.ast.BinaryOperator;
import com.google.j2cl.transpiler.ast.DeclaredTypeDescriptor;
import com.google.j2cl.transpiler.ast.FieldDescriptor;
import com.google.j2cl.transpiler.ast.IntersectionTypeDescriptor;
import com.google.j2cl.transpiler.ast.JsEnumInfo;
import com.google.j2cl.transpiler.ast.JsInfo;
import com.google.j2cl.transpiler.ast.Literal;
import com.google.j2cl.transpiler.ast.MethodDescriptor;
import com.google.j2cl.transpiler.ast.PostfixOperator;
import com.google.j2cl.transpiler.ast.PrefixOperator;
import com.google.j2cl.transpiler.ast.PrimitiveTypes;
import com.google.j2cl.transpiler.ast.TypeDeclaration;
import com.google.j2cl.transpiler.ast.TypeDescriptor;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.ast.TypeVariable;
import com.google.j2cl.transpiler.ast.UnionTypeDescriptor;
import com.google.j2cl.transpiler.ast.Variable;
import com.google.j2cl.transpiler.ast.Visibility;
import com.google.j2cl.transpiler.frontend.common.Nullability;
import com.google.j2cl.transpiler.frontend.common.PackageInfoCache;
import com.google.j2cl.transpiler.frontend.javac.AnnotationUtils;
import com.google.j2cl.transpiler.frontend.javac.JsInteropAnnotationUtils;
import com.google.j2cl.transpiler.frontend.javac.JsInteropUtils;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

class JavaEnvironment {
    JavacTypes javacTypes;
    Types internalTypes;
    JavacElements elements;
    private final Map<DeclaredType, DeclaredTypeDescriptor> cachedDeclaredTypeDescriptorByDeclaredTypeInNullMarkedScope = new HashMap<DeclaredType, DeclaredTypeDescriptor>();
    private final Map<DeclaredType, DeclaredTypeDescriptor> cachedDeclaredTypeDescriptorByDeclaredTypeOutOfNullMarkedScope = new HashMap<DeclaredType, DeclaredTypeDescriptor>();

    JavaEnvironment(Context context, Collection<String> wellKnownQualifiedBinaryNames) {
        this.javacTypes = JavacTypes.instance(context);
        this.internalTypes = Types.instance(context);
        this.elements = JavacElements.instance(context);
        this.initWellKnownTypes(wellKnownQualifiedBinaryNames);
    }

    private void initWellKnownTypes(Collection<String> wellKnownQualifiedBinaryNames) {
        if (TypeDescriptors.isInitialized()) {
            return;
        }
        TypeDescriptors.SingletonBuilder builder = new TypeDescriptors.SingletonBuilder();
        wellKnownQualifiedBinaryNames.forEach(binaryName -> {
            String qualifiedSourceName = binaryName.replace('$', '.');
            TypeElement element = this.getTypeElement(qualifiedSourceName);
            if (element != null) {
                builder.addReferenceType(this.createDeclaredTypeDescriptor(element.asType()));
            }
        });
        builder.buildSingleton();
    }

    @Nullable
    static PrefixOperator getPrefixOperator(Tree.Kind operator) {
        switch (operator) {
            case PREFIX_INCREMENT: {
                return PrefixOperator.INCREMENT;
            }
            case PREFIX_DECREMENT: {
                return PrefixOperator.DECREMENT;
            }
            case UNARY_PLUS: {
                return PrefixOperator.PLUS;
            }
            case UNARY_MINUS: {
                return PrefixOperator.MINUS;
            }
            case BITWISE_COMPLEMENT: {
                return PrefixOperator.COMPLEMENT;
            }
            case LOGICAL_COMPLEMENT: {
                return PrefixOperator.NOT;
            }
        }
        return null;
    }

    @Nullable
    static PostfixOperator getPostfixOperator(Tree.Kind operator) {
        switch (operator) {
            case POSTFIX_INCREMENT: {
                return PostfixOperator.INCREMENT;
            }
            case POSTFIX_DECREMENT: {
                return PostfixOperator.DECREMENT;
            }
        }
        return null;
    }

    @Nullable
    static BinaryOperator getBinaryOperator(Tree.Kind operator) {
        switch (operator) {
            case ASSIGNMENT: {
                return BinaryOperator.ASSIGN;
            }
            case PLUS_ASSIGNMENT: {
                return BinaryOperator.PLUS_ASSIGN;
            }
            case MINUS_ASSIGNMENT: {
                return BinaryOperator.MINUS_ASSIGN;
            }
            case MULTIPLY_ASSIGNMENT: {
                return BinaryOperator.TIMES_ASSIGN;
            }
            case DIVIDE_ASSIGNMENT: {
                return BinaryOperator.DIVIDE_ASSIGN;
            }
            case AND_ASSIGNMENT: {
                return BinaryOperator.BIT_AND_ASSIGN;
            }
            case OR_ASSIGNMENT: {
                return BinaryOperator.BIT_OR_ASSIGN;
            }
            case XOR_ASSIGNMENT: {
                return BinaryOperator.BIT_XOR_ASSIGN;
            }
            case REMAINDER_ASSIGNMENT: {
                return BinaryOperator.REMAINDER_ASSIGN;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return BinaryOperator.LEFT_SHIFT_ASSIGN;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return BinaryOperator.RIGHT_SHIFT_SIGNED_ASSIGN;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return BinaryOperator.RIGHT_SHIFT_UNSIGNED_ASSIGN;
            }
            case AND: {
                return BinaryOperator.BIT_AND;
            }
            case CONDITIONAL_AND: {
                return BinaryOperator.CONDITIONAL_AND;
            }
            case CONDITIONAL_OR: {
                return BinaryOperator.CONDITIONAL_OR;
            }
            case DIVIDE: {
                return BinaryOperator.DIVIDE;
            }
            case EQUAL_TO: {
                return BinaryOperator.EQUALS;
            }
            case GREATER_THAN: {
                return BinaryOperator.GREATER;
            }
            case GREATER_THAN_EQUAL: {
                return BinaryOperator.GREATER_EQUALS;
            }
            case LEFT_SHIFT: {
                return BinaryOperator.LEFT_SHIFT;
            }
            case LESS_THAN: {
                return BinaryOperator.LESS;
            }
            case LESS_THAN_EQUAL: {
                return BinaryOperator.LESS_EQUALS;
            }
            case MINUS: {
                return BinaryOperator.MINUS;
            }
            case MULTIPLY: {
                return BinaryOperator.TIMES;
            }
            case NOT_EQUAL_TO: {
                return BinaryOperator.NOT_EQUALS;
            }
            case OR: {
                return BinaryOperator.BIT_OR;
            }
            case PLUS: {
                return BinaryOperator.PLUS;
            }
            case REMAINDER: {
                return BinaryOperator.REMAINDER;
            }
            case RIGHT_SHIFT: {
                return BinaryOperator.RIGHT_SHIFT_SIGNED;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return BinaryOperator.RIGHT_SHIFT_UNSIGNED;
            }
            case XOR: {
                return BinaryOperator.BIT_XOR;
            }
        }
        return null;
    }

    Variable createVariable(SourcePosition sourcePosition, VariableElement variableElement, boolean isParameter) {
        TypeMirror type = variableElement.asType();
        String name = variableElement.getSimpleName().toString();
        TypeDescriptor typeDescriptor = isParameter ? this.createTypeDescriptorWithNullability(type, variableElement.getAnnotationMirrors(), false) : this.createTypeDescriptor(type);
        boolean isFinal = JavaEnvironment.isFinal(variableElement);
        boolean isUnusableByJsSuppressed = JsInteropAnnotationUtils.isUnusableByJsSuppressed(variableElement);
        return Variable.newBuilder().setName(name).setTypeDescriptor(typeDescriptor).setFinal(isFinal).setParameter(isParameter).setUnusableByJsSuppressed(isUnusableByJsSuppressed).setSourcePosition(sourcePosition).build();
    }

    DeclaredTypeDescriptor createDeclaredTypeDescriptor(TypeMirror typeMirror) {
        return this.createDeclaredTypeDescriptor(typeMirror, false);
    }

    DeclaredTypeDescriptor createDeclaredTypeDescriptor(TypeMirror typeMirror, boolean inNullMarkedScope) {
        return this.createTypeDescriptor(typeMirror, inNullMarkedScope, DeclaredTypeDescriptor.class);
    }

    <T extends TypeDescriptor> T createTypeDescriptor(TypeMirror typeMirror, Class<T> clazz) {
        return this.createTypeDescriptor(typeMirror, false, clazz);
    }

    <T extends TypeDescriptor> T createTypeDescriptor(TypeMirror typeMirror, boolean inNullMarkedScope, Class<T> clazz) {
        return (T)((TypeDescriptor)clazz.cast(this.createTypeDescriptor(typeMirror, inNullMarkedScope)));
    }

    TypeDescriptor createTypeDescriptor(TypeMirror typeMirror) {
        return this.createTypeDescriptor(typeMirror, false);
    }

    TypeDescriptor createTypeDescriptor(TypeMirror typeMirror, boolean inNullMarkedScope) {
        return this.createTypeDescriptorWithNullability(typeMirror, (java.util.List<? extends AnnotationMirror>)ImmutableList.of(), inNullMarkedScope);
    }

    @Nullable
    private TypeDescriptor createTypeDescriptorWithNullability(TypeMirror typeMirror, java.util.List<? extends AnnotationMirror> elementAnnotations, boolean inNullMarkedScope) {
        if (typeMirror == null || typeMirror.getKind() == TypeKind.NONE) {
            return null;
        }
        if (typeMirror.getKind().isPrimitive() || typeMirror.getKind() == TypeKind.VOID) {
            return PrimitiveTypes.get((String)this.asElement(typeMirror).getSimpleName().toString());
        }
        if (typeMirror.getKind() == TypeKind.INTERSECTION) {
            return this.createIntersectionType((Type.IntersectionClassType)typeMirror);
        }
        if (typeMirror.getKind() == TypeKind.UNION) {
            return this.createUnionType((Type.UnionClassType)typeMirror);
        }
        if (typeMirror.getKind() == TypeKind.NULL) {
            return TypeDescriptors.get().javaLangObject;
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            return this.createTypeVariable((javax.lang.model.type.TypeVariable)typeMirror);
        }
        if (typeMirror.getKind() == TypeKind.WILDCARD) {
            return this.createWildcardTypeVariable(((WildcardType)typeMirror).getExtendsBound());
        }
        boolean isNullable = this.isNullable(typeMirror, elementAnnotations, inNullMarkedScope);
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)typeMirror;
            TypeDescriptor componentTypeDescriptor = this.createTypeDescriptor(arrayType.getComponentType(), inNullMarkedScope);
            return ArrayTypeDescriptor.newBuilder().setComponentTypeDescriptor(componentTypeDescriptor).setNullable(isNullable).build();
        }
        return JavaEnvironment.withNullability(this.createDeclaredType((Type.ClassType)typeMirror, inNullMarkedScope), isNullable);
    }

    private boolean isNullable(TypeMirror typeMirror, java.util.List<? extends AnnotationMirror> elementAnnotations, boolean inNullMarkedScope) {
        Preconditions.checkArgument((!typeMirror.getKind().isPrimitive() ? 1 : 0) != 0);
        if (this.asTypeElement(typeMirror).getQualifiedName().contentEquals("java.lang.Void")) {
            return true;
        }
        Iterable allAnnotations = Iterables.concat(elementAnnotations, typeMirror.getAnnotationMirrors());
        for (AnnotationMirror annotationMirror : allAnnotations) {
            if (JavaEnvironment.isNonNullAnnotation(annotationMirror)) {
                return false;
            }
            if (!JavaEnvironment.isNullableAnnotation(annotationMirror)) continue;
            return true;
        }
        return !inNullMarkedScope;
    }

    private static boolean isNonNullAnnotation(AnnotationMirror annotation) {
        Type annotationType = (Type)((Object)annotation.getAnnotationType());
        return Nullability.isNonNullAnnotation((String)annotationType.asElement().getQualifiedName().toString());
    }

    private static boolean isNullableAnnotation(AnnotationMirror annotation) {
        Type annotationType = (Type)((Object)annotation.getAnnotationType());
        return Nullability.isNullableAnnotation((String)annotationType.asElement().getQualifiedName().toString());
    }

    private TypeVariable createTypeVariable(javax.lang.model.type.TypeVariable typeVariable) {
        if (typeVariable instanceof Type.CapturedType) {
            return this.createWildcardTypeVariable(typeVariable.getUpperBound());
        }
        Supplier<TypeDescriptor> boundTypeDescriptorFactory = () -> this.createTypeDescriptor(typeVariable.getUpperBound());
        ImmutableList<String> classComponents = this.getClassComponents(typeVariable);
        return TypeVariable.newBuilder().setUpperBoundTypeDescriptorSupplier(boundTypeDescriptorFactory).setUniqueKey(String.join((CharSequence)"::", classComponents) + (typeVariable.getUpperBound() != null ? typeVariable.getUpperBound().toString() : "")).setName(typeVariable.asElement().getSimpleName().toString()).build();
    }

    private TypeVariable createWildcardTypeVariable(TypeMirror bound) {
        return TypeVariable.newBuilder().setUpperBoundTypeDescriptorSupplier(() -> this.createTypeDescriptor(bound)).setWildcard(true).setName("?").setUniqueKey("::?::" + (bound != null ? bound.toString() : "")).build();
    }

    private static DeclaredTypeDescriptor withNullability(DeclaredTypeDescriptor typeDescriptor, boolean nullable) {
        return nullable ? typeDescriptor.toNullable() : typeDescriptor.toNonNullable();
    }

    private static TypeElement toTopLevelTypeBinding(Element element) {
        if (element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return (TypeElement)element;
        }
        return JavaEnvironment.toTopLevelTypeBinding(element.getEnclosingElement());
    }

    private ImmutableList<String> getClassComponents(javax.lang.model.type.TypeVariable typeVariable) {
        Element enclosingElement = typeVariable.asElement().getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS || enclosingElement.getKind() == ElementKind.INTERFACE || enclosingElement.getKind() == ElementKind.ENUM) {
            return ImmutableList.builder().addAll(this.getClassComponents(enclosingElement)).add((Object)("C_" + typeVariable.asElement().getSimpleName())).build();
        }
        return ImmutableList.builder().addAll(this.getClassComponents(enclosingElement.getEnclosingElement())).add((Object)("M_" + enclosingElement.getSimpleName() + "_" + typeVariable.asElement().getSimpleName())).build();
    }

    private ImmutableList<String> getClassComponents(Element element) {
        if (!(element instanceof TypeElement)) {
            return ImmutableList.of();
        }
        TypeElement typeElement = (TypeElement)element;
        ArrayList<String> classComponents = new ArrayList<String>();
        TypeElement currentType = typeElement;
        while (currentType != null) {
            Element enclosingElement;
            String simpleName;
            if (currentType.getNestingKind() == NestingKind.LOCAL || currentType.getNestingKind() == NestingKind.ANONYMOUS) {
                String binaryName = JavaEnvironment.getBinaryNameFromTypeBinding(currentType);
                String declaringClassPrefix = JavaEnvironment.getBinaryNameFromTypeBinding(JavaEnvironment.getEnclosingType(currentType)) + "$";
                simpleName = binaryName.substring(declaringClassPrefix.length());
            } else {
                simpleName = this.asElement(this.erasure(currentType.asType())).getSimpleName().toString();
            }
            classComponents.add(0, simpleName);
            for (enclosingElement = currentType.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE && enclosingElement.getKind() != ElementKind.ENUM; enclosingElement = enclosingElement.getEnclosingElement()) {
            }
            currentType = (TypeElement)enclosingElement;
        }
        return ImmutableList.copyOf(classComponents);
    }

    private static String getBinaryNameFromTypeBinding(TypeElement typeElement) {
        return ((Symbol.ClassSymbol)typeElement).flatName().toString();
    }

    private boolean isEnumSyntheticMethod(ExecutableElement methodElement) {
        return JavaEnvironment.getEnclosingType(methodElement).getKind() == ElementKind.ENUM && (JavaEnvironment.isValuesMethod(methodElement) || this.isValueOfMethod(methodElement));
    }

    private static boolean isValuesMethod(ExecutableElement methodElement) {
        return methodElement.getSimpleName().contentEquals("values") && methodElement.getParameters().isEmpty();
    }

    private boolean isValueOfMethod(ExecutableElement methodElement) {
        return methodElement.getSimpleName().contentEquals("valueOf") && methodElement.getParameters().size() == 1 && this.asTypeElement(methodElement.getParameters().get(0).asType()).getQualifiedName().contentEquals("java.lang.String");
    }

    static boolean capturesEnclosingInstance(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.isAnonymous()) {
            return classSymbol.hasOuterInstance() || !JavaEnvironment.isStatic(classSymbol.getEnclosingElement());
        }
        return classSymbol.hasOuterInstance();
    }

    FieldDescriptor createFieldDescriptor(VariableElement variableElement) {
        return this.createFieldDescriptor(variableElement, variableElement.asType());
    }

    FieldDescriptor createFieldDescriptor(VariableElement variableElement, TypeMirror type) {
        boolean isCompileTimeConstant;
        boolean isStatic = JavaEnvironment.isStatic(variableElement);
        Visibility visibility = JavaEnvironment.getVisibility(variableElement);
        DeclaredTypeDescriptor enclosingTypeDescriptor = this.createDeclaredTypeDescriptor(JavaEnvironment.getEnclosingType(variableElement).asType());
        String fieldName = variableElement.getSimpleName().toString();
        TypeDescriptor thisTypeDescriptor = this.createTypeDescriptorWithNullability(type, variableElement.getAnnotationMirrors(), enclosingTypeDescriptor.getTypeDeclaration().isNullMarked());
        boolean isEnumConstant = ((Symbol.VarSymbol)variableElement).isEnum();
        if (isEnumConstant) {
            thisTypeDescriptor = thisTypeDescriptor.toNonNullable();
        }
        FieldDescriptor declarationFieldDescriptor = null;
        if (!this.javacTypes.isSameType(variableElement.asType(), type)) {
            declarationFieldDescriptor = this.createFieldDescriptor(variableElement, variableElement.asType());
        }
        JsInfo jsInfo = JsInteropUtils.getJsInfo(variableElement);
        Object constantValue = variableElement.getConstantValue();
        boolean bl = isCompileTimeConstant = constantValue != null;
        if (isCompileTimeConstant) {
            thisTypeDescriptor = thisTypeDescriptor.toNonNullable();
        }
        boolean isFinal = JavaEnvironment.isFinal(variableElement);
        return FieldDescriptor.newBuilder().setEnclosingTypeDescriptor(enclosingTypeDescriptor).setName(fieldName).setTypeDescriptor(thisTypeDescriptor).setStatic(isStatic).setVisibility(visibility).setOriginalJsInfo(jsInfo).setFinal(isFinal).setCompileTimeConstant(isCompileTimeConstant).setConstantValue(constantValue != null ? Literal.fromValue((Object)constantValue, (TypeDescriptor)thisTypeDescriptor) : null).setDeclarationDescriptor(declarationFieldDescriptor).setEnumConstant(isEnumConstant).setUnusableByJsSuppressed(JsInteropAnnotationUtils.isUnusableByJsSuppressed(variableElement)).setDeprecated(JavaEnvironment.isDeprecated(variableElement)).build();
    }

    MethodDescriptor createMethodDescriptor(ExecutableType methodType, Type returnType, ExecutableElement declarationMethodElement) {
        DeclaredTypeDescriptor enclosingTypeDescriptor = this.createDeclaredTypeDescriptor(declarationMethodElement.getEnclosingElement().asType());
        MethodDescriptor declarationMethodDescriptor = null;
        java.util.List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        if (this.isSpecialized(declarationMethodElement, parameterTypes, returnType)) {
            declarationMethodDescriptor = this.createDeclarationMethodDescriptor(declarationMethodElement);
        }
        TypeDescriptor returnTypeDescriptor = JavaEnvironment.applyReturnTypeNullabilityAnnotations(this.createTypeDescriptorWithNullability(returnType, declarationMethodElement.getAnnotationMirrors(), enclosingTypeDescriptor.getTypeDeclaration().isNullMarked()), declarationMethodElement);
        ImmutableList.Builder parametersBuilder = ImmutableList.builder();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            parametersBuilder.add((Object)JavaEnvironment.applyParameterNullabilityAnnotations(this.createTypeDescriptorWithNullability(parameterTypes.get(i), declarationMethodElement.getParameters().get(i).getAnnotationMirrors(), enclosingTypeDescriptor.getTypeDeclaration().isNullMarked()), declarationMethodElement, i));
        }
        return this.createDeclaredMethodDescriptor(enclosingTypeDescriptor.toNullable(), declarationMethodElement, declarationMethodDescriptor, (java.util.List<TypeDescriptor>)parametersBuilder.build(), returnTypeDescriptor);
    }

    MethodDescriptor createMethodDescriptor(DeclaredTypeDescriptor enclosingTypeDescriptor, ExecutableElement methodElement, ExecutableElement declarationMethodElement) {
        TypeMirror returnType;
        MethodDescriptor declarationMethodDescriptor = null;
        ImmutableList parameters = (ImmutableList)methodElement.getParameters().stream().map(Element::asType).collect(ImmutableList.toImmutableList());
        if (this.isSpecialized(declarationMethodElement, (java.util.List<? extends TypeMirror>)parameters, returnType = methodElement.getReturnType())) {
            declarationMethodDescriptor = this.createDeclarationMethodDescriptor(declarationMethodElement, enclosingTypeDescriptor.toUnparameterizedTypeDescriptor());
        }
        TypeDescriptor returnTypeDescriptor = JavaEnvironment.applyReturnTypeNullabilityAnnotations(this.createTypeDescriptorWithNullability(returnType, declarationMethodElement.getAnnotationMirrors(), enclosingTypeDescriptor.getTypeDeclaration().isNullMarked()), declarationMethodElement);
        ImmutableList.Builder parametersBuilder = ImmutableList.builder();
        for (int i = 0; i < parameters.size(); ++i) {
            parametersBuilder.add((Object)JavaEnvironment.applyParameterNullabilityAnnotations(this.createTypeDescriptorWithNullability((TypeMirror)parameters.get(i), declarationMethodElement.getParameters().get(i).getAnnotationMirrors(), enclosingTypeDescriptor.getTypeDeclaration().isNullMarked()), declarationMethodElement, i));
        }
        return this.createDeclaredMethodDescriptor(enclosingTypeDescriptor.toNullable(), declarationMethodElement, declarationMethodDescriptor, (java.util.List<TypeDescriptor>)parametersBuilder.build(), returnTypeDescriptor);
    }

    MethodDescriptor createDeclarationMethodDescriptor(ExecutableElement methodElement) {
        DeclaredTypeDescriptor enclosingTypeDescriptor = this.createDeclaredTypeDescriptor(methodElement.getEnclosingElement().asType());
        return this.createDeclarationMethodDescriptor(methodElement, enclosingTypeDescriptor);
    }

    MethodDescriptor createDeclarationMethodDescriptor(ExecutableElement methodElement, DeclaredTypeDescriptor enclosingTypeDescriptor) {
        return this.createMethodDescriptor(enclosingTypeDescriptor, methodElement, methodElement);
    }

    private static TypeDescriptor applyParameterNullabilityAnnotations(TypeDescriptor typeDescriptor, ExecutableElement declarationMethodElement, int index) {
        return JavaEnvironment.applyNullabilityAnnotations(typeDescriptor, declarationMethodElement, position -> position.parameter_index == index && position.type == TargetType.METHOD_FORMAL_PARAMETER);
    }

    private static TypeDescriptor applyReturnTypeNullabilityAnnotations(TypeDescriptor typeDescriptor, ExecutableElement declarationMethodElement) {
        return JavaEnvironment.applyNullabilityAnnotations(typeDescriptor, declarationMethodElement, position -> position.type == TargetType.METHOD_RETURN);
    }

    private static TypeDescriptor applyNullabilityAnnotations(TypeDescriptor typeDescriptor, Element declarationMethodElement, Predicate<TypeAnnotationPosition> positionSelector) {
        List<Attribute.TypeCompound> methodAnnotations = ((Symbol)declarationMethodElement).getRawTypeAttributes();
        for (Attribute.TypeCompound methodAnnotation : methodAnnotations) {
            TypeAnnotationPosition position = methodAnnotation.getPosition();
            if (!positionSelector.test(position)) continue;
            if (JavaEnvironment.isNonNullAnnotation(methodAnnotation)) {
                typeDescriptor = JavaEnvironment.applyNullabilityAnnotation(typeDescriptor, position.location, false);
                continue;
            }
            if (!JavaEnvironment.isNullableAnnotation(methodAnnotation)) continue;
            typeDescriptor = JavaEnvironment.applyNullabilityAnnotation(typeDescriptor, position.location, true);
        }
        return typeDescriptor;
    }

    private static TypeDescriptor applyNullabilityAnnotation(TypeDescriptor typeDescriptor, java.util.List<TypeAnnotationPosition.TypePathEntry> location, boolean isNullable) {
        if (location.isEmpty()) {
            if (TypeDescriptors.isJavaLangVoid((TypeDescriptor)typeDescriptor)) {
                return typeDescriptor;
            }
            return isNullable ? typeDescriptor.toNullable() : typeDescriptor.toNonNullable();
        }
        TypeAnnotationPosition.TypePathEntry currentEntry = location.get(0);
        java.util.List<TypeAnnotationPosition.TypePathEntry> rest = location.subList(1, location.size());
        switch (currentEntry.tag) {
            case TYPE_ARGUMENT: {
                DeclaredTypeDescriptor declaredTypeDescriptor = (DeclaredTypeDescriptor)typeDescriptor;
                ArrayList<TypeDescriptor> replacements = new ArrayList<TypeDescriptor>((Collection<TypeDescriptor>)declaredTypeDescriptor.getTypeArgumentDescriptors());
                if (currentEntry.arg < replacements.size()) {
                    replacements.set(currentEntry.arg, JavaEnvironment.applyNullabilityAnnotation((TypeDescriptor)replacements.get(currentEntry.arg), rest, isNullable));
                }
                return DeclaredTypeDescriptor.Builder.from((DeclaredTypeDescriptor)declaredTypeDescriptor).setTypeArgumentDescriptors(replacements).build();
            }
            case ARRAY: {
                ArrayTypeDescriptor arrayTypeDescriptor = (ArrayTypeDescriptor)typeDescriptor;
                return ArrayTypeDescriptor.newBuilder().setComponentTypeDescriptor(JavaEnvironment.applyNullabilityAnnotation(arrayTypeDescriptor.getComponentTypeDescriptor(), rest, isNullable)).setNullable(typeDescriptor.isNullable()).build();
            }
            case INNER_TYPE: {
                DeclaredTypeDescriptor innerType = (DeclaredTypeDescriptor)typeDescriptor;
                int innerDepth = JavaEnvironment.getInnerDepth(innerType);
                int innerCount = JavaEnvironment.countInner(rest) + 1;
                if (innerCount != innerDepth) {
                    return innerType;
                }
                return JavaEnvironment.applyNullabilityAnnotation(typeDescriptor, rest.subList(innerCount - 1, rest.size()), isNullable);
            }
            case WILDCARD: {
                TypeVariable typeVariable = (TypeVariable)typeDescriptor;
                return TypeVariable.createWildcardWithUpperBound((TypeDescriptor)JavaEnvironment.applyNullabilityAnnotation(typeVariable.getUpperBoundTypeDescriptor(), rest, isNullable));
            }
        }
        return typeDescriptor;
    }

    private static int countInner(java.util.List<TypeAnnotationPosition.TypePathEntry> rest) {
        return !rest.isEmpty() && rest.get((int)0).tag == TypeAnnotationPosition.TypePathEntryKind.INNER_TYPE ? JavaEnvironment.countInner(rest.subList(1, rest.size())) + 1 : 0;
    }

    private static int getInnerDepth(DeclaredTypeDescriptor innerType) {
        if (innerType.getTypeDeclaration().isCapturingEnclosingInstance()) {
            return JavaEnvironment.getInnerDepth(innerType.getEnclosingTypeDescriptor()) + 1;
        }
        return 0;
    }

    private boolean isSpecialized(ExecutableElement declarationMethodElement, java.util.List<? extends TypeMirror> parameters, TypeMirror returnType) {
        return !this.isSameType(returnType, declarationMethodElement.getReturnType()) || !Streams.zip(parameters.stream(), declarationMethodElement.getParameters().stream(), (thisType, thatType) -> this.isSameType((TypeMirror)thisType, thatType.asType())).allMatch(equals -> equals);
    }

    private boolean isSameType(TypeMirror thisType, TypeMirror thatType) {
        return this.internalTypes.isSameType((Type)thisType, (Type)thatType);
    }

    private MethodDescriptor createDeclaredMethodDescriptor(DeclaredTypeDescriptor enclosingTypeDescriptor, ExecutableElement declarationMethodElement, MethodDescriptor declarationMethodDescriptor, java.util.List<TypeDescriptor> parameters, TypeDescriptor returnTypeDescriptor) {
        ImmutableList typeParameterTypeDescriptors = (ImmutableList)declarationMethodElement.getTypeParameters().stream().map(Element::asType).map(this::createTypeDescriptor).map(TypeVariable.class::cast).collect(ImmutableList.toImmutableList());
        boolean isStatic = JavaEnvironment.isStatic(declarationMethodElement);
        Visibility visibility = JavaEnvironment.getVisibility(declarationMethodElement);
        boolean isDefault = JavaEnvironment.isDefaultMethod(declarationMethodElement);
        JsInfo jsInfo = JsInteropUtils.getJsInfo(declarationMethodElement);
        boolean isNative = JavaEnvironment.isNative(declarationMethodElement) || !jsInfo.isJsOverlay() && enclosingTypeDescriptor.isNative() && JavaEnvironment.isAbstract(declarationMethodElement);
        boolean isConstructor = declarationMethodElement.getKind() == ElementKind.CONSTRUCTOR;
        String methodName = declarationMethodElement.getSimpleName().toString();
        ImmutableList.Builder parameterDescriptorBuilder = ImmutableList.builder();
        for (int i = 0; i < parameters.size(); ++i) {
            parameterDescriptorBuilder.add((Object)MethodDescriptor.ParameterDescriptor.newBuilder().setTypeDescriptor(parameters.get(i)).setJsOptional(JsInteropUtils.isJsOptional(declarationMethodElement, i)).setVarargs(i == parameters.size() - 1 && declarationMethodElement.isVarArgs()).setDoNotAutobox(JsInteropUtils.isDoNotAutobox(declarationMethodElement, i)).build());
        }
        boolean hasUncheckedCast = JavaEnvironment.hasUncheckedCastAnnotation(declarationMethodElement);
        return MethodDescriptor.newBuilder().setEnclosingTypeDescriptor(enclosingTypeDescriptor).setName(isConstructor ? null : methodName).setParameterDescriptors(parameterDescriptorBuilder.build()).setDeclarationDescriptor(declarationMethodDescriptor).setReturnTypeDescriptor((TypeDescriptor)(isConstructor ? enclosingTypeDescriptor : returnTypeDescriptor)).setTypeParameterTypeDescriptors((Iterable)typeParameterTypeDescriptors).setOriginalJsInfo(jsInfo).setVisibility(visibility).setStatic(isStatic).setConstructor(isConstructor).setNative(isNative).setFinal(JavaEnvironment.isFinal(declarationMethodElement)).setDefaultMethod(isDefault).setAbstract(JavaEnvironment.isAbstract(declarationMethodElement)).setSynthetic(JavaEnvironment.isSynthetic(declarationMethodElement)).setEnumSyntheticMethod(this.isEnumSyntheticMethod(declarationMethodElement)).setSideEffectFree(JavaEnvironment.isAnnotatedWithHasNoSideEffects(declarationMethodElement)).setUnusableByJsSuppressed(JsInteropAnnotationUtils.isUnusableByJsSuppressed(declarationMethodElement)).setDeprecated(JavaEnvironment.isDeprecated(declarationMethodElement)).setUncheckedCast(hasUncheckedCast).build();
    }

    private static boolean hasUncheckedCastAnnotation(Element element) {
        return AnnotationUtils.hasAnnotation(element, "javaemul.internal.annotations.UncheckedCast");
    }

    private static boolean isAnnotatedWithHasNoSideEffects(Element element) {
        return AnnotationUtils.hasAnnotation(element, "javaemul.internal.annotations.HasNoSideEffects");
    }

    private boolean isJavaLangObjectOverride(Symbol.MethodSymbol method) {
        return this.getJavaLangObjectMethods().stream().anyMatch(om -> ((Object)method.getSimpleName()).equals(om.name) && this.javacTypes.isSubsignature((ExecutableType)method.asType(), (ExecutableType)om.asType()));
    }

    private ImmutableSet<Symbol.MethodSymbol> getJavaLangObjectMethods() {
        Type.ClassType javaLangObjectTypeBinding = (Type.ClassType)this.elements.getTypeElement("java.lang.Object").asType();
        return (ImmutableSet)this.getDeclaredMethods(javaLangObjectTypeBinding).stream().map(MethodDeclarationPair::getMethodSymbol).filter(JavaEnvironment::isPolymorphic).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isPolymorphic(Symbol.MethodSymbol method) {
        return !method.isConstructor() && !JavaEnvironment.isStatic(method) && !method.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public ImmutableList<TypeDescriptor> createTypeDescriptors(java.util.List<? extends TypeMirror> typeMirrors, boolean inNullMarkedScope) {
        return (ImmutableList)typeMirrors.stream().map(typeMirror -> this.createTypeDescriptor((TypeMirror)typeMirror, inNullMarkedScope)).collect(ImmutableList.toImmutableList());
    }

    public <T extends TypeDescriptor> ImmutableList<T> createTypeDescriptors(java.util.List<? extends TypeMirror> typeMirrors, boolean inNullMarkedScope, Class<T> clazz, Element declarationElement) {
        ImmutableList.Builder typeDescriptorsBuilder = ImmutableList.builder();
        for (int i = 0; i < typeMirrors.size(); ++i) {
            int index = i;
            typeDescriptorsBuilder.add((Object)((TypeDescriptor)clazz.cast(JavaEnvironment.applyNullabilityAnnotations(this.createTypeDescriptor(typeMirrors.get(i), inNullMarkedScope, clazz), declarationElement, position -> position.type == TargetType.CLASS_EXTENDS && position.type_index == index))));
        }
        return typeDescriptorsBuilder.build();
    }

    public <T extends TypeDescriptor> ImmutableList<T> createTypeDescriptors(java.util.List<? extends TypeMirror> typeMirrors, boolean inNullMarkedScope, Class<T> clazz) {
        return (ImmutableList)typeMirrors.stream().map(typeMirror -> this.createTypeDescriptor((TypeMirror)typeMirror, inNullMarkedScope, clazz)).collect(ImmutableList.toImmutableList());
    }

    private TypeElement getTypeElement(String qualifiedSourceName) {
        return this.elements.getTypeElement(qualifiedSourceName);
    }

    private Element asElement(TypeMirror typeMirror) {
        if (typeMirror instanceof Type.JCPrimitiveType) {
            return ((Type.JCPrimitiveType)typeMirror).asElement();
        }
        if (typeMirror instanceof Type) {
            return ((Type)typeMirror).tsym;
        }
        return this.javacTypes.asElement(typeMirror);
    }

    private TypeElement asTypeElement(TypeMirror typeMirror) {
        return (TypeElement)this.asElement(typeMirror);
    }

    private TypeMirror erasure(TypeMirror typeMirror) {
        return this.javacTypes.erasure(typeMirror);
    }

    private PackageElement getPackageOf(TypeElement typeElement) {
        return this.elements.getPackageOf(typeElement);
    }

    private TypeDescriptor createIntersectionType(Type.IntersectionClassType intersectionType) {
        ImmutableList<TypeDescriptor> intersectedTypeDescriptors = this.createTypeDescriptors(intersectionType.getBounds(), false, TypeDescriptor.class);
        return IntersectionTypeDescriptor.newBuilder().setIntersectionTypeDescriptors(intersectedTypeDescriptors).build();
    }

    private TypeDescriptor createUnionType(Type.UnionClassType unionType) {
        ImmutableList<TypeDescriptor> unionTypeDescriptors = this.createTypeDescriptors(unionType.getAlternatives(), false);
        return UnionTypeDescriptor.newBuilder().setUnionTypeDescriptors(unionTypeDescriptors).build();
    }

    private DeclaredTypeDescriptor createDeclaredType(DeclaredType classType, boolean inNullMarkedScope) {
        DeclaredTypeDescriptor cachedTypeDescriptor = this.getCachedTypeDescriptor(classType, inNullMarkedScope);
        if (cachedTypeDescriptor != null) {
            return cachedTypeDescriptor;
        }
        Supplier<ImmutableList> declaredMethods = () -> (ImmutableList)this.getDeclaredMethods((Type.ClassType)classType).stream().map(methodDeclarationPair -> this.createMethodDescriptor(this.createDeclaredTypeDescriptor(classType, inNullMarkedScope), methodDeclarationPair.getMethodSymbol(), (ExecutableElement)methodDeclarationPair.getDeclarationMethodSymbol())).collect(ImmutableList.toImmutableList());
        Supplier<ImmutableList> declaredFields = () -> (ImmutableList)((TypeElement)classType.asElement()).getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.ENUM_CONSTANT).map(VariableElement.class::cast).map(this::createFieldDescriptor).collect(ImmutableList.toImmutableList());
        TypeDeclaration typeDeclaration = this.createDeclarationForType((TypeElement)classType.asElement());
        DeclaredTypeDescriptor typeDescriptor = DeclaredTypeDescriptor.newBuilder().setTypeDeclaration(typeDeclaration).setEnclosingTypeDescriptor(this.createDeclaredTypeDescriptor(classType.getEnclosingType())).setSuperTypeDescriptorFactory(td -> td.isInterface() ? null : this.createDeclaredTypeDescriptor(this.javacTypes.directSupertypes(classType).stream().filter(Predicates.not(Type::isInterface)).findFirst().orElse(null), inNullMarkedScope)).setInterfaceTypeDescriptorsFactory(td -> this.createTypeDescriptors((java.util.List)this.javacTypes.directSupertypes(classType).stream().filter(Type::isInterface).collect(ImmutableList.toImmutableList()), inNullMarkedScope, DeclaredTypeDescriptor.class)).setSingleAbstractMethodDescriptorFactory(td -> {
            Symbol.MethodSymbol functionalInterfaceMethod = this.getFunctionalInterfaceMethod(classType);
            return this.createMethodDescriptor(td, (Symbol.MethodSymbol)functionalInterfaceMethod.asMemberOf((Type)((Symbol.ClassSymbol)classType.asElement()).asType(), this.internalTypes), (ExecutableElement)this.getFunctionalInterfaceMethodDecl(classType));
        }).setTypeArgumentDescriptors(this.createTypeDescriptors(JavaEnvironment.getTypeArguments(classType), inNullMarkedScope)).setDeclaredFieldDescriptorsFactory(declaredFields).setDeclaredMethodDescriptorsFactory(declaredMethods).build();
        this.putTypeDescriptorInCache(inNullMarkedScope, classType, typeDescriptor);
        return typeDescriptor;
    }

    private DeclaredTypeDescriptor getCachedTypeDescriptor(DeclaredType classType, boolean inNullMarkedScope) {
        Map<DeclaredType, DeclaredTypeDescriptor> cache = inNullMarkedScope ? this.cachedDeclaredTypeDescriptorByDeclaredTypeInNullMarkedScope : this.cachedDeclaredTypeDescriptorByDeclaredTypeOutOfNullMarkedScope;
        return cache.get(classType);
    }

    private void putTypeDescriptorInCache(boolean inNullMarkedScope, DeclaredType classType, DeclaredTypeDescriptor typeDescriptor) {
        Map<DeclaredType, DeclaredTypeDescriptor> cache = inNullMarkedScope ? this.cachedDeclaredTypeDescriptorByDeclaredTypeInNullMarkedScope : this.cachedDeclaredTypeDescriptorByDeclaredTypeOutOfNullMarkedScope;
        cache.put(classType, typeDescriptor);
    }

    private static java.util.List<TypeMirror> getTypeArguments(DeclaredType declaredType) {
        ArrayList<TypeMirror> typeArguments = new ArrayList<TypeMirror>();
        DeclaredType currentType = declaredType;
        do {
            typeArguments.addAll(currentType.getTypeArguments());
            Element enclosingElement = currentType.asElement().getEnclosingElement();
            if (enclosingElement.getKind() != ElementKind.METHOD && enclosingElement.getKind() != ElementKind.CONSTRUCTOR) continue;
            typeArguments.addAll((Collection)((Parameterizable)enclosingElement).getTypeParameters().stream().map(Element::asType).collect(ImmutableList.toImmutableList()));
        } while ((currentType = currentType.getEnclosingType() instanceof DeclaredType ? (DeclaredType)currentType.getEnclosingType() : null) != null);
        return typeArguments;
    }

    private ImmutableList<MethodDeclarationPair> getDeclaredMethods(Type.ClassType classType) {
        return (ImmutableList)((Symbol.TypeSymbol)classType.asElement()).getEnclosedElements().stream().filter(element -> !JavaEnvironment.isSynthetic(element) && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR)).map(Symbol.MethodSymbol.class::cast).map(methodSymbol -> new MethodDeclarationPair((Symbol.MethodSymbol)methodSymbol.asMemberOf(classType, this.internalTypes), (Symbol.MethodSymbol)methodSymbol)).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<MethodDeclarationPair> getMethods(Type.ClassType classType) {
        return (ImmutableList)this.elements.getAllMembers((TypeElement)classType.asElement()).stream().filter(element -> !JavaEnvironment.isSynthetic(element) && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR)).map(Symbol.MethodSymbol.class::cast).map(methodSymbol -> new MethodDeclarationPair((Symbol.MethodSymbol)methodSymbol.asMemberOf(classType, this.internalTypes), (Symbol.MethodSymbol)methodSymbol)).collect(ImmutableList.toImmutableList());
    }

    private static TypeDeclaration.Kind getKindFromTypeBinding(TypeElement typeElement) {
        if (JavaEnvironment.isEnum(typeElement) && !JavaEnvironment.isAnonymous(typeElement)) {
            return TypeDeclaration.Kind.ENUM;
        }
        if (JavaEnvironment.isClass(typeElement) || JavaEnvironment.isEnum(typeElement) && JavaEnvironment.isAnonymous(typeElement)) {
            return TypeDeclaration.Kind.CLASS;
        }
        if (JavaEnvironment.isInterface(typeElement)) {
            return TypeDeclaration.Kind.INTERFACE;
        }
        throw new InternalCompilerError("Type binding %s not handled.", new Object[]{typeElement});
    }

    private static String getJsName(TypeElement classSymbol) {
        return JsInteropAnnotationUtils.getJsName(classSymbol);
    }

    @Nullable
    private static String getJsNamespace(TypeElement classSymbol, PackageInfoCache packageInfoCache) {
        boolean isTopLevelType;
        String jsNamespace = JsInteropAnnotationUtils.getJsNamespace(classSymbol);
        if (jsNamespace != null) {
            return jsNamespace;
        }
        boolean bl = isTopLevelType = classSymbol.getEnclosingElement().getKind() == ElementKind.PACKAGE;
        if (isTopLevelType) {
            return packageInfoCache.getJsNamespace(JavaEnvironment.getBinaryNameFromTypeBinding(classSymbol));
        }
        return null;
    }

    @Nullable
    TypeDeclaration createDeclarationForType(TypeElement typeElement) {
        boolean isFromSource;
        if (typeElement == null) {
            return null;
        }
        PackageInfoCache packageInfoCache = PackageInfoCache.get();
        boolean bl = isFromSource = ((Symbol.ClassSymbol)typeElement).classfile == null;
        if (isFromSource) {
            TypeElement topLevelTypeBinding = JavaEnvironment.toTopLevelTypeBinding(typeElement);
            PackageInfoCache.get().markAsSource(JavaEnvironment.getBinaryNameFromTypeBinding(topLevelTypeBinding));
        }
        String packageName = this.getPackageOf(typeElement).getQualifiedName().toString();
        boolean isAbstract = JavaEnvironment.isAbstract(typeElement) && !JavaEnvironment.isInterface(typeElement);
        TypeDeclaration.Kind kind = JavaEnvironment.getKindFromTypeBinding(typeElement);
        boolean isFinal = JavaEnvironment.isFinal(typeElement) && kind != TypeDeclaration.Kind.ENUM;
        Supplier<ImmutableList> declaredMethods = () -> {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (Symbol.MethodSymbol methodElement : (ImmutableList)typeElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR).map(Symbol.MethodSymbol.class::cast).collect(ImmutableList.toImmutableList())) {
                MethodDescriptor methodDescriptor = this.createDeclarationMethodDescriptor(methodElement);
                listBuilder.add((Object)methodDescriptor);
            }
            return listBuilder.build();
        };
        Supplier<ImmutableList> declaredFields = () -> (ImmutableList)typeElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.ENUM_CONSTANT).map(VariableElement.class::cast).map(this::createFieldDescriptor).collect(ImmutableList.toImmutableList());
        JsEnumInfo jsEnumInfo = JsInteropUtils.getJsEnumInfo(typeElement);
        java.util.List<TypeParameterElement> typeParameterElements = JavaEnvironment.getTypeParameters(typeElement);
        boolean isNullMarked = JavaEnvironment.isNullMarked(typeElement, packageInfoCache);
        return TypeDeclaration.newBuilder().setClassComponents(this.getClassComponents(typeElement)).setEnclosingTypeDeclaration(this.createDeclarationForType(JavaEnvironment.getEnclosingType(typeElement))).setInterfaceTypeDescriptorsFactory(() -> this.createTypeDescriptors(typeElement.getInterfaces(), isNullMarked, DeclaredTypeDescriptor.class, typeElement)).setUnparameterizedTypeDescriptorFactory(() -> this.createDeclaredTypeDescriptor(typeElement.asType())).setHasAbstractModifier(isAbstract).setKind(kind).setAnnotation(JavaEnvironment.isAnnotation(typeElement)).setCapturingEnclosingInstance(JavaEnvironment.capturesEnclosingInstance((Symbol.ClassSymbol)typeElement)).setFinal(isFinal).setFunctionalInterface(this.isFunctionalInterface(typeElement.asType())).setJsFunctionInterface(JsInteropUtils.isJsFunction(typeElement)).setJsType(JsInteropUtils.isJsType(typeElement)).setJsEnumInfo(jsEnumInfo).setNative(JsInteropUtils.isJsNativeType(typeElement)).setAnonymous(JavaEnvironment.isAnonymous(typeElement)).setLocal(JavaEnvironment.isLocal(typeElement)).setSimpleJsName(JavaEnvironment.getJsName(typeElement)).setCustomizedJsNamespace(JavaEnvironment.getJsNamespace(typeElement, packageInfoCache)).setNullMarked(isNullMarked).setOriginalSimpleSourceName(typeElement.getSimpleName() != null ? typeElement.getSimpleName().toString() : null).setPackageName(packageName).setSuperTypeDescriptorFactory(() -> (DeclaredTypeDescriptor)JavaEnvironment.applyNullabilityAnnotations((TypeDescriptor)this.createDeclaredTypeDescriptor(typeElement.getSuperclass(), isNullMarked), typeElement, position -> position.type == TargetType.CLASS_EXTENDS && position.type_index == -1)).setTypeParameterDescriptors((Iterable)typeParameterElements.stream().map(Element::asType).map(javax.lang.model.type.TypeVariable.class::cast).map(this::createTypeVariable).collect(ImmutableList.toImmutableList())).setVisibility(JavaEnvironment.getVisibility(typeElement)).setDeclaredMethodDescriptorsFactory(declaredMethods).setDeclaredFieldDescriptorsFactory(declaredFields).setUnusableByJsSuppressed(JsInteropAnnotationUtils.isUnusableByJsSuppressed(typeElement)).setDeprecated(JavaEnvironment.isDeprecated(typeElement)).build();
    }

    private static boolean isNullMarked(TypeElement classSymbol, PackageInfoCache packageInfoCache) {
        if (packageInfoCache.isNullMarked(JavaEnvironment.getBinaryNameFromTypeBinding(JavaEnvironment.toTopLevelTypeBinding(classSymbol)))) {
            return true;
        }
        return JavaEnvironment.hasNullMarkedAnnotation(classSymbol);
    }

    private static boolean hasNullMarkedAnnotation(TypeElement classSymbol) {
        if (classSymbol.getAnnotationMirrors().stream().anyMatch(a -> Nullability.isNullMarkedAnnotation((String)AnnotationUtils.getAnnotationName(a)))) {
            return true;
        }
        Element enclosingElement = classSymbol.getEnclosingElement();
        return enclosingElement instanceof TypeElement && JavaEnvironment.hasNullMarkedAnnotation((TypeElement)enclosingElement);
    }

    private static java.util.List<TypeParameterElement> getTypeParameters(TypeElement typeElement) {
        ArrayList<TypeParameterElement> typeParameterElements = new ArrayList<TypeParameterElement>(typeElement.getTypeParameters());
        Element currentElement = typeElement;
        for (Element enclosingElement = typeElement.getEnclosingElement(); enclosingElement != null && !JavaEnvironment.isStatic(currentElement); enclosingElement = enclosingElement.getEnclosingElement()) {
            if (enclosingElement.getKind() != ElementKind.STATIC_INIT && enclosingElement.getKind() != ElementKind.INSTANCE_INIT && enclosingElement instanceof Parameterizable) {
                typeParameterElements.addAll(((Parameterizable)enclosingElement).getTypeParameters());
            }
            currentElement = enclosingElement;
        }
        return typeParameterElements;
    }

    public static TypeElement getEnclosingType(Element typeElement) {
        Element enclosing;
        for (enclosing = typeElement.getEnclosingElement(); enclosing != null && !(enclosing instanceof TypeElement); enclosing = enclosing.getEnclosingElement()) {
        }
        return (TypeElement)enclosing;
    }

    private static TypeElement getEnclosingType(TypeElement typeElement) {
        Element enclosing;
        for (enclosing = typeElement.getEnclosingElement(); enclosing != null && !(enclosing instanceof TypeElement); enclosing = enclosing.getEnclosingElement()) {
        }
        return (TypeElement)enclosing;
    }

    @Nullable
    private TypeMirror getFunctionalInterface(Type type) {
        if (type.isIntersection()) {
            return ((IntersectionType)((Object)type)).getBounds().stream().filter(this::isFunctionalInterface).findFirst().orElse(null);
        }
        Preconditions.checkArgument((boolean)this.isFunctionalInterface(type));
        return type;
    }

    MethodDescriptor getJsFunctionMethodDescriptor(TypeMirror type) {
        DeclaredTypeDescriptor expressionTypeDescriptor = this.createDeclaredTypeDescriptor(this.getFunctionalInterface((Type)type));
        return this.createMethodDescriptor(expressionTypeDescriptor, (Symbol.MethodSymbol)this.getFunctionalInterfaceMethod(type).asMemberOf((Type)type, this.internalTypes), (ExecutableElement)this.getFunctionalInterfaceMethod(type));
    }

    @Nullable
    private Symbol.MethodSymbol getFunctionalInterfaceMethodDecl(TypeMirror typeMirror) {
        return Optional.ofNullable(this.getFunctionalInterfaceMethodPair(typeMirror)).map(MethodDeclarationPair::getDeclarationMethodSymbol).orElse(null);
    }

    @Nullable
    private Symbol.MethodSymbol getFunctionalInterfaceMethod(TypeMirror typeMirror) {
        return Optional.ofNullable(this.getFunctionalInterfaceMethodPair(typeMirror)).map(MethodDeclarationPair::getMethodSymbol).orElse(null);
    }

    @Nullable
    private MethodDeclarationPair getFunctionalInterfaceMethodPair(TypeMirror typeMirror) {
        Type type = (Type)typeMirror;
        if (!this.internalTypes.isFunctionalInterface(type)) {
            return null;
        }
        if (type.isIntersection()) {
            return ((IntersectionType)((Object)type)).getBounds().stream().filter(this::isFunctionalInterface).map(this::getFunctionalInterfaceMethodPair).findFirst().orElse(null);
        }
        return this.getMethods((Type.ClassType)type).stream().filter(p -> JavaEnvironment.isAbstract(p.getDeclarationMethodSymbol()) && !this.isJavaLangObjectOverride(p.getDeclarationMethodSymbol())).findFirst().orElse(null);
    }

    private boolean isFunctionalInterface(TypeMirror type) {
        return this.internalTypes.isFunctionalInterface((Type)type) && ((Type)type).asElement().getKind() == ElementKind.INTERFACE;
    }

    private static boolean isEnum(TypeElement typeElement) {
        return typeElement.getKind() == ElementKind.ENUM;
    }

    private static boolean isAnnotation(TypeElement typeElement) {
        return typeElement.getKind() == ElementKind.ANNOTATION_TYPE;
    }

    private static boolean isAnonymous(TypeElement typeElement) {
        return typeElement.getNestingKind() == NestingKind.ANONYMOUS;
    }

    private static boolean isClass(TypeElement typeElement) {
        return typeElement.getKind() == ElementKind.CLASS;
    }

    private static boolean isInterface(TypeElement typeElement) {
        return typeElement.getKind() == ElementKind.INTERFACE || typeElement.getKind() == ElementKind.ANNOTATION_TYPE;
    }

    private static boolean isLocal(TypeElement typeElement) {
        return typeElement.getNestingKind() == NestingKind.LOCAL;
    }

    public static Visibility getVisibility(Element element) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return Visibility.PUBLIC;
        }
        if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return Visibility.PROTECTED;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE_PRIVATE;
    }

    private static boolean isDeprecated(AnnotatedConstruct binding) {
        return AnnotationUtils.hasAnnotation(binding, Deprecated.class.getName());
    }

    private static boolean isDefaultMethod(Element element) {
        return element.getModifiers().contains((Object)Modifier.DEFAULT);
    }

    private static boolean isAbstract(Element element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static boolean isNative(Element element) {
        return element.getModifiers().contains((Object)Modifier.NATIVE);
    }

    private static boolean isSynthetic(Element element) {
        return element instanceof Symbol && (((Symbol)element).flags() & 0x1000L) != 0L;
    }

    static final class MethodDeclarationPair {
        private final Symbol.MethodSymbol methodSymbol;
        private final Symbol.MethodSymbol declarationMethodSymbol;

        private MethodDeclarationPair(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol declarationMethodSymbol) {
            this.methodSymbol = methodSymbol;
            this.declarationMethodSymbol = declarationMethodSymbol;
        }

        public Symbol.MethodSymbol getMethodSymbol() {
            return this.methodSymbol;
        }

        public Symbol.MethodSymbol getDeclarationMethodSymbol() {
            return this.declarationMethodSymbol;
        }
    }
}

