/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.j2cl.common.Problems;
import com.google.j2cl.common.SourceUtils;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.TypeDescriptors;
import com.google.j2cl.transpiler.frontend.javac.AnnotatedNodeCollector;
import com.google.j2cl.transpiler.frontend.javac.CompilationUnitBuilder;
import com.google.j2cl.transpiler.frontend.javac.JavaEnvironment;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.file.JavacFileManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavacParser {
    private final Problems problems;
    private final ImmutableList<String> classpathEntries;

    public JavacParser(List<String> classpathEntries, Problems problems) {
        this.classpathEntries = ImmutableList.copyOf(classpathEntries);
        this.problems = problems;
    }

    @Nullable
    public List<CompilationUnit> parseFiles(List<SourceUtils.FileInfo> filePaths, boolean useTargetPath, ImmutableList<String> forbiddenAnnotations) {
        if (filePaths.isEmpty()) {
            return ImmutableList.of();
        }
        Map<String, String> targetPathBySourcePath = filePaths.stream().collect(Collectors.toMap(SourceUtils.FileInfo::sourcePath, SourceUtils.FileInfo::targetPath));
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            JavacFileManager fileManager = (JavacFileManager)compiler.getStandardFileManager(diagnostics, null, StandardCharsets.UTF_8);
            List searchpath = this.classpathEntries.stream().map(File::new).collect(Collectors.toList());
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, searchpath);
            fileManager.setLocation(StandardLocation.CLASS_PATH, searchpath);
            JavacTaskImpl task = (JavacTaskImpl)compiler.getTask(null, fileManager, diagnostics, (Iterable<String>)ImmutableList.of((Object)"--patch-module", (Object)"java.base=.", (Object)"--add-reads", (Object)"java.base=ALL-UNNAMED"), null, fileManager.getJavaFileObjectsFromFiles(targetPathBySourcePath.keySet().stream().map(File::new).collect(Collectors.toList())));
            ArrayList javacCompilationUnits = Lists.newArrayList(task.parse());
            task.analyze();
            if (this.hasErrors(diagnostics, javacCompilationUnits, forbiddenAnnotations)) {
                return ImmutableList.of();
            }
            JavaEnvironment javaEnvironment = new JavaEnvironment(task.getContext(), TypeDescriptors.getWellKnownTypeNames());
            return CompilationUnitBuilder.build(javacCompilationUnits, javaEnvironment);
        }
        catch (IOException e) {
            this.problems.fatal(Problems.FatalError.valueOf((String)e.getMessage()), new Object[0]);
            return null;
        }
    }

    private boolean hasErrors(DiagnosticCollector<JavaFileObject> diagnosticCollector, List<CompilationUnitTree> javacCompilationUnits, ImmutableList<String> forbiddenAnnotations) {
        boolean hasErrors = false;
        for (String forbiddenAnnotation : forbiddenAnnotations) {
            Set<String> filesWithGwtIncompatible = AnnotatedNodeCollector.filesWithAnnotation(javacCompilationUnits, forbiddenAnnotation);
            if (filesWithGwtIncompatible.isEmpty()) continue;
            this.problems.fatal(-1, filesWithGwtIncompatible.iterator().next(), Problems.FatalError.INCOMPATIBLE_ANNOTATION_FOUND_IN_COMPILE, new Object[]{forbiddenAnnotation});
        }
        for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            this.problems.error((int)diagnostic.getLineNumber(), ((JavaFileObject)diagnostic.getSource()).getName(), "%s", new Object[]{diagnostic.getMessage(Locale.US)});
            hasErrors = true;
        }
        return hasErrors;
    }
}

