/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class AnnotatedNodeCollector {
    public static Set<String> filesWithAnnotation(List<CompilationUnitTree> compilationUnits, final String annotationName) {
        final LinkedHashSet<String> filenames = new LinkedHashSet<String>();
        for (final CompilationUnitTree compilationUnit : compilationUnits) {
            compilationUnit.accept(new TreeScanner<Void, Void>(){

                @Override
                public Void visitCompilationUnit(CompilationUnitTree unit, Void unused) {
                    this.scan(unit.getTypeDecls(), null);
                    return null;
                }

                @Override
                public Void visitAnnotatedType(AnnotatedTypeTree node, Void unused) {
                    this.checkGwtIncompatibleAnnotations(node.getAnnotations());
                    return null;
                }

                @Override
                public Void visitClass(ClassTree node, Void unused) {
                    this.checkGwtIncompatibleAnnotations(node.getModifiers().getAnnotations());
                    return null;
                }

                @Override
                public Void visitMethod(MethodTree node, Void unused) {
                    this.checkGwtIncompatibleAnnotations(node.getModifiers().getAnnotations());
                    return null;
                }

                @Override
                public Void visitVariable(VariableTree node, Void unused) {
                    this.checkGwtIncompatibleAnnotations(node.getModifiers().getAnnotations());
                    return null;
                }

                private void checkGwtIncompatibleAnnotations(List<? extends AnnotationTree> annotations) {
                    if (annotations.stream().anyMatch(a -> AnnotatedNodeCollector.getLastComponent(a.getAnnotationType()).equals(annotationName))) {
                        filenames.add(compilationUnit.getSourceFile().getName());
                    }
                }
            }, null);
        }
        return filenames;
    }

    private static String getLastComponent(Tree name) {
        switch (name.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)name).getName().toString();
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)name).getIdentifier().toString();
            }
        }
        return "";
    }

    private AnnotatedNodeCollector() {
    }
}

