/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class AnnotationUtils {
    @Nullable
    public static AnnotationMirror findAnnotationBindingByName(List<? extends AnnotationMirror> annotations, String name) {
        if (annotations == null) {
            return null;
        }
        for (AnnotationMirror annotationMirror : annotations) {
            if (!AnnotationUtils.getAnnotationName(annotationMirror).equals(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static String getAnnotationName(AnnotationMirror annotationMirror) {
        return ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
    }

    @Nullable
    public static String getAnnotationParameterString(AnnotationMirror annotationMirror, String paramName) {
        if (annotationMirror == null) {
            return null;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> member : annotationMirror.getElementValues().entrySet()) {
            if (!member.getKey().getSimpleName().contentEquals(paramName)) continue;
            return (String)member.getValue().getValue();
        }
        return null;
    }

    @Nullable
    public static List<?> getAnnotationParameterArray(AnnotationMirror annotationMirror, String paramName) {
        if (annotationMirror == null) {
            return null;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> member : annotationMirror.getElementValues().entrySet()) {
            if (!member.getKey().getSimpleName().contentEquals(paramName) || !(member.getValue().getValue() instanceof List)) continue;
            return (List)member.getValue().getValue();
        }
        return null;
    }

    public static boolean getAnnotationParameterBoolean(AnnotationMirror annotationMirror, String paramName, boolean defaultValue) {
        if (annotationMirror == null) {
            return defaultValue;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> member : annotationMirror.getElementValues().entrySet()) {
            if (!member.getKey().getSimpleName().contentEquals(paramName)) continue;
            return (Boolean)member.getValue().getValue();
        }
        return defaultValue;
    }

    public static boolean hasAnnotation(AnnotatedConstruct construct, String annotationSourceName) {
        return AnnotationUtils.findAnnotationBindingByName(construct.getAnnotationMirrors(), annotationSourceName) != null;
    }

    private AnnotationUtils() {
    }
}

