/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.j2cl.common.InternalCompilerError;
import com.google.j2cl.transpiler.frontend.javac.AnnotationUtils;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.util.List;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class JsInteropAnnotationUtils {
    private JsInteropAnnotationUtils() {
    }

    public static AnnotationMirror getJsAsyncAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsAsync");
    }

    public static AnnotationMirror getJsConstructorAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsConstructor");
    }

    public static AnnotationMirror getJsEnumAnnotation(AnnotatedConstruct typeBinding) {
        return AnnotationUtils.findAnnotationBindingByName(typeBinding.getAnnotationMirrors(), "jsinterop.annotations.JsEnum");
    }

    public static AnnotationMirror getJsFunctionAnnotation(AnnotatedConstruct typeBinding) {
        return AnnotationUtils.findAnnotationBindingByName(typeBinding.getAnnotationMirrors(), "jsinterop.annotations.JsFunction");
    }

    public static AnnotationMirror getJsIgnoreAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsIgnore");
    }

    public static AnnotationMirror getJsTypeAnnotation(AnnotatedConstruct typeBinding) {
        return AnnotationUtils.findAnnotationBindingByName(typeBinding.getAnnotationMirrors(), "jsinterop.annotations.JsType");
    }

    public static AnnotationMirror getJsMethodAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsMethod");
    }

    public static AnnotationMirror getJsPackageAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsPackage");
    }

    public static AnnotationMirror getJsPropertyAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsProperty");
    }

    public static AnnotationMirror getJsOptionalAnnotation(ExecutableElement methodBinding, int parameterIndex) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getParameters().get(parameterIndex).getAnnotationMirrors(), "jsinterop.annotations.JsOptional");
    }

    public static AnnotationMirror getDoNotAutoboxAnnotation(ExecutableElement methodBinding, int parameterIndex) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getParameters().get(parameterIndex).getAnnotationMirrors(), "javaemul.internal.annotations.DoNotAutobox");
    }

    public static AnnotationMirror getJsOverlayAnnotation(AnnotatedConstruct methodBinding) {
        return AnnotationUtils.findAnnotationBindingByName(methodBinding.getAnnotationMirrors(), "jsinterop.annotations.JsOverlay");
    }

    public static Stream<Attribute.Compound> getDeclarationAndTypeAttributes(Symbol sym) {
        Symbol typeAnnotationOwner;
        switch (sym.getKind()) {
            case PARAMETER: {
                typeAnnotationOwner = sym.owner;
                break;
            }
            default: {
                typeAnnotationOwner = sym;
            }
        }
        return Streams.concat((Stream[])new Stream[]{sym.getRawAttributes().stream(), typeAnnotationOwner.getRawTypeAttributes().stream().filter(anno -> JsInteropAnnotationUtils.isAnnotationOnType(sym, anno.position))}).collect(Collectors.groupingBy(c -> c.type.asElement().getQualifiedName(), LinkedHashMap::new, ImmutableList.toImmutableList())).values().stream().map(c -> (Attribute.Compound)c.get(0));
    }

    private static boolean isAnnotationOnType(Symbol sym, TypeAnnotationPosition position) {
        if (!position.location.isEmpty()) {
            return false;
        }
        switch (sym.getKind()) {
            case LOCAL_VARIABLE: {
                return position.type == TargetType.LOCAL_VARIABLE;
            }
            case FIELD: {
                return position.type == TargetType.FIELD;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return position.type == TargetType.METHOD_RETURN;
            }
            case PARAMETER: {
                switch (position.type) {
                    case METHOD_FORMAL_PARAMETER: {
                        return ((List)((Symbol.MethodSymbol)sym.owner).getParameters()).indexOf(sym) == position.parameter_index;
                    }
                }
                return false;
            }
            case CLASS: {
                return false;
            }
        }
        throw new InternalCompilerError("Unsupported element kind in MoreAnnotation#isAnnotationOnType: %s.", new Object[]{sym.getKind()});
    }

    public static boolean isJsPackageAnnotation(AnnotationMirror annotation) {
        return ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().contentEquals("jsinterop.annotations.JsPackage");
    }

    public static boolean isJsNative(AnnotatedConstruct typeBinding) {
        return JsInteropAnnotationUtils.isJsNative(JsInteropAnnotationUtils.getJsTypeOrJsEnumAnnotation(typeBinding));
    }

    private static boolean isJsNative(AnnotationMirror annotationBinding) {
        return AnnotationUtils.getAnnotationParameterBoolean(annotationBinding, "isNative", false);
    }

    public static boolean isUnusableByJsSuppressed(AnnotatedConstruct binding) {
        AnnotationMirror suppressWarningsBinding = AnnotationUtils.findAnnotationBindingByName(binding.getAnnotationMirrors(), "java.lang.SuppressWarnings");
        if (suppressWarningsBinding == null) {
            return false;
        }
        java.util.List<?> suppressions = AnnotationUtils.getAnnotationParameterArray(suppressWarningsBinding, "value");
        return suppressions.stream().map(Object::toString).anyMatch("\"unusable-by-js\""::equals);
    }

    public static String getJsNamespace(AnnotatedConstruct typeBinding) {
        AnnotationMirror annotation = JsInteropAnnotationUtils.getJsTypeAnnotation(typeBinding);
        if (annotation == null) {
            annotation = JsInteropAnnotationUtils.getJsEnumAnnotation(typeBinding);
        }
        if (annotation == null) {
            annotation = JsInteropAnnotationUtils.getJsPackageAnnotation(typeBinding);
        }
        return JsInteropAnnotationUtils.getJsNamespace(annotation);
    }

    public static String getJsNamespace(AnnotationMirror annotationBinding) {
        return AnnotationUtils.getAnnotationParameterString(annotationBinding, "namespace");
    }

    public static String getJsName(AnnotatedConstruct typeBinding) {
        return JsInteropAnnotationUtils.getJsName(JsInteropAnnotationUtils.getJsTypeOrJsEnumAnnotation(typeBinding));
    }

    public static String getJsName(AnnotationMirror annotationBinding) {
        return AnnotationUtils.getAnnotationParameterString(annotationBinding, "name");
    }

    private static AnnotationMirror getJsTypeOrJsEnumAnnotation(AnnotatedConstruct typeBinding) {
        return Optional.ofNullable(JsInteropAnnotationUtils.getJsTypeAnnotation(typeBinding)).orElse(JsInteropAnnotationUtils.getJsEnumAnnotation(typeBinding));
    }

    public static boolean hasCustomValue(AnnotatedConstruct typeBinding) {
        return JsInteropAnnotationUtils.hasCustomValue(JsInteropAnnotationUtils.getJsEnumAnnotation(typeBinding));
    }

    private static boolean hasCustomValue(AnnotationMirror annotationBinding) {
        return AnnotationUtils.getAnnotationParameterBoolean(annotationBinding, "hasCustomValue", false);
    }
}

