/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend.javac;

import com.google.j2cl.transpiler.ast.JsEnumInfo;
import com.google.j2cl.transpiler.ast.JsInfo;
import com.google.j2cl.transpiler.ast.JsMemberType;
import com.google.j2cl.transpiler.frontend.javac.JsInteropAnnotationUtils;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

public final class JsInteropUtils {
    public static JsInfo getJsInfo(ExecutableElement member) {
        AnnotationMirror annotation = JsInteropAnnotationUtils.getJsMethodAnnotation(member);
        if (annotation == null) {
            annotation = JsInteropAnnotationUtils.getJsConstructorAnnotation(member);
        }
        if (annotation == null) {
            annotation = JsInteropAnnotationUtils.getJsPropertyAnnotation(member);
        }
        boolean isPropertyAccessor = JsInteropAnnotationUtils.getJsPropertyAnnotation(member) != null;
        return JsInteropUtils.getJsInfo(member, (TypeElement)member.getEnclosingElement(), annotation, isPropertyAccessor);
    }

    public static JsInfo getJsInfo(VariableElement member) {
        AnnotationMirror annotation = JsInteropAnnotationUtils.getJsPropertyAnnotation(member);
        return JsInteropUtils.getJsInfo(member, (TypeElement)member.getEnclosingElement(), annotation, false);
    }

    private static JsInfo getJsInfo(Element member, TypeElement declaringType, AnnotationMirror memberAnnotation, boolean isAccessor) {
        boolean jsOverlay = JsInteropUtils.isJsOverlay(member);
        boolean jsAsync = JsInteropUtils.isJsAsync(member);
        if (JsInteropAnnotationUtils.getJsIgnoreAnnotation(member) == null) {
            boolean memberOfNativeType;
            boolean publicMemberOfJsType = JsInteropUtils.isJsType(declaringType) && member.getModifiers().contains((Object)Modifier.PUBLIC);
            boolean isJsEnumConstant = JsInteropUtils.isJsEnum(declaringType) && member.getKind() == ElementKind.ENUM_CONSTANT;
            boolean bl = memberOfNativeType = JsInteropUtils.isJsNativeType(declaringType) && !JsInteropUtils.isJsEnum(declaringType);
            if (memberAnnotation != null || (publicMemberOfJsType || isJsEnumConstant || memberOfNativeType) && !jsOverlay) {
                return JsInfo.newBuilder().setJsMemberType(JsInteropUtils.getJsMemberType(member, isAccessor)).setJsName(JsInteropAnnotationUtils.getJsName(memberAnnotation)).setJsNamespace(JsInteropAnnotationUtils.getJsNamespace(memberAnnotation)).setJsOverlay(jsOverlay).setJsAsync(jsAsync).setHasJsMemberAnnotation(memberAnnotation != null).build();
            }
        }
        return JsInfo.newBuilder().setJsMemberType(JsMemberType.NONE).setJsOverlay(jsOverlay).setJsAsync(jsAsync).build();
    }

    @Nullable
    public static JsEnumInfo getJsEnumInfo(TypeElement type) {
        if (!JsInteropUtils.isJsEnum(type)) {
            return null;
        }
        boolean hasCustomValue = JsInteropAnnotationUtils.hasCustomValue(type);
        return JsEnumInfo.newBuilder().setHasCustomValue(hasCustomValue).setSupportsComparable(!hasCustomValue || JsInteropUtils.isJsNativeType(type)).setSupportsOrdinal(!hasCustomValue && !JsInteropUtils.isJsNativeType(type)).build();
    }

    private static JsMemberType getJsMemberType(Element member, boolean isPropertyAccessor) {
        if (member.getKind() == ElementKind.FIELD || member.getKind() == ElementKind.ENUM_CONSTANT) {
            return JsMemberType.PROPERTY;
        }
        if (member.getKind() == ElementKind.CONSTRUCTOR) {
            return JsMemberType.CONSTRUCTOR;
        }
        if (isPropertyAccessor) {
            return JsInteropUtils.getJsPropertyAccessorType((ExecutableElement)member);
        }
        return JsMemberType.METHOD;
    }

    private static JsMemberType getJsPropertyAccessorType(ExecutableElement method) {
        if (method.getParameters().size() == 1 && JsInteropUtils.returnsPrimitiveVoid(method)) {
            return JsMemberType.SETTER;
        }
        if (method.getParameters().isEmpty() && (!JsInteropUtils.returnsPrimitiveVoid(method) || JsInteropUtils.isDebugger(method))) {
            return JsMemberType.GETTER;
        }
        return JsMemberType.UNDEFINED_ACCESSOR;
    }

    private static boolean returnsPrimitiveVoid(ExecutableElement method) {
        return method.getReturnType().getKind() == TypeKind.VOID;
    }

    private static boolean isDebugger(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return method.getSimpleName().contentEquals("debugger") && modifiers.contains((Object)Modifier.NATIVE) && method.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isJsMember(ExecutableElement method) {
        return JsInteropUtils.getJsInfo(method).getJsMemberType() != JsMemberType.NONE;
    }

    public static boolean isJsAsync(AnnotatedConstruct method) {
        return JsInteropAnnotationUtils.getJsAsyncAnnotation(method) != null;
    }

    public static boolean isJsOverlay(AnnotatedConstruct method) {
        return JsInteropAnnotationUtils.getJsOverlayAnnotation(method) != null;
    }

    public static boolean isJsOptional(ExecutableElement method, int i) {
        return JsInteropAnnotationUtils.getJsOptionalAnnotation(method, i) != null;
    }

    public static boolean isDoNotAutobox(ExecutableElement method, int i) {
        return JsInteropAnnotationUtils.getDoNotAutoboxAnnotation(method, i) != null;
    }

    public static boolean isJsType(AnnotatedConstruct type) {
        return JsInteropAnnotationUtils.getJsTypeAnnotation(type) != null;
    }

    public static boolean isJsEnum(AnnotatedConstruct type) {
        return JsInteropAnnotationUtils.getJsEnumAnnotation(type) != null;
    }

    public static boolean isJsNativeType(AnnotatedConstruct type) {
        return JsInteropAnnotationUtils.isJsNative(type);
    }

    public static boolean isJsFunction(AnnotatedConstruct type) {
        return JsInteropAnnotationUtils.getJsFunctionAnnotation(type) != null;
    }

    private JsInteropUtils() {
    }
}

