/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.j2cl.common.Problems;
import com.google.j2cl.transpiler.ast.CompilationUnit;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.frontend.FrontendOptions;
import com.google.j2cl.transpiler.frontend.common.PackageInfoCache;
import com.google.j2cl.transpiler.frontend.javac.JavacParser;
import com.google.j2cl.transpiler.frontend.jdt.CompilationUnitBuilder;
import com.google.j2cl.transpiler.frontend.jdt.CompilationUnitsAndTypeBindings;
import com.google.j2cl.transpiler.frontend.jdt.JdtParser;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public enum Frontend {
    JDT{

        @Override
        public List<CompilationUnit> compile(FrontendOptions options, Problems problems) {
            JdtParser parser = new JdtParser(options.getClasspaths(), problems);
            CompilationUnitsAndTypeBindings compilationUnitsAndTypeBindings = parser.parseFiles(options.getSources(), options.getGenerateKytheIndexingMetadata(), options.getForbiddenAnnotations());
            problems.abortIfHasErrors();
            return CompilationUnitBuilder.build((CompilationUnitsAndTypeBindings)compilationUnitsAndTypeBindings, (JdtParser)parser);
        }

        @Override
        public boolean isJavaFrontend() {
            return true;
        }
    }
    ,
    JAVAC{

        @Override
        public List<CompilationUnit> compile(FrontendOptions options, Problems problems) {
            return new JavacParser(options.getClasspaths(), problems).parseFiles(options.getSources(), options.getGenerateKytheIndexingMetadata(), options.getForbiddenAnnotations());
        }

        @Override
        public boolean isJavaFrontend() {
            return true;
        }
    }
    ,
    KOTLIN{

        @Override
        public List<CompilationUnit> compile(FrontendOptions options, Problems problems) {
            try {
                Class<?> kotlinParser = Class.forName("com.google.j2cl.transpiler.frontend.kotlin.KotlinParser");
                Constructor parserCtor = (Constructor)Iterables.getOnlyElement(Arrays.asList(kotlinParser.getDeclaredConstructors()));
                Object parserInstance = parserCtor.newInstance(options.getClasspaths(), options.getKotlincOptions(), problems, options.getTargetLabel());
                List compilationUnits = (List)kotlinParser.getMethod("parseFiles", List.class).invoke(parserInstance, options.getSources());
                problems.abortIfHasErrors();
                return compilationUnits;
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isJavaFrontend() {
            return false;
        }
    };


    public Library getLibrary(FrontendOptions options, Problems problems) {
        PackageInfoCache.init(options.getClasspaths(), (Problems)problems);
        return Library.newBuilder().setCompilationUnits(this.compile(options, problems)).build();
    }

    abstract List<CompilationUnit> compile(FrontendOptions var1, Problems var2);

    public abstract boolean isJavaFrontend();
}

