/*
 * Decompiled with CFR 0.152.
 */
package com.google.j2cl.transpiler.frontend;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.j2cl.common.Problems;
import com.google.j2cl.transpiler.ast.Library;
import com.google.j2cl.transpiler.frontend.common.FrontendOptions;
import com.google.j2cl.transpiler.frontend.javac.JavacParser;
import com.google.j2cl.transpiler.frontend.jdt.CompilationUnitBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public enum Frontend {
    JDT{

        @Override
        public Library parse(FrontendOptions options, Problems problems) {
            return Library.newBuilder().setCompilationUnits(CompilationUnitBuilder.build((FrontendOptions)options, (Problems)problems)).build();
        }

        @Override
        public boolean isJavaFrontend() {
            return true;
        }
    }
    ,
    JAVAC{

        @Override
        public Library parse(FrontendOptions options, Problems problems) {
            return new JavacParser(problems).parseFiles(options);
        }

        @Override
        public boolean isJavaFrontend() {
            return true;
        }
    }
    ,
    KOTLIN{

        @Override
        public Library parse(FrontendOptions options, Problems problems) {
            try {
                Class<?> kotlinParser = Class.forName("com.google.j2cl.transpiler.frontend.kotlin.KotlinParser");
                Constructor parserCtor = (Constructor)Iterables.getOnlyElement(Arrays.asList(kotlinParser.getDeclaredConstructors()));
                return (Library)kotlinParser.getMethod("parseFiles", FrontendOptions.class).invoke(parserCtor.newInstance(problems), options);
            }
            catch (Exception e) {
                Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                Throwables.throwIfUnchecked((Throwable)cause);
                throw new RuntimeException(cause);
            }
        }

        @Override
        public boolean isJavaFrontend() {
            return false;
        }
    };


    public abstract Library parse(FrontendOptions var1, Problems var2);

    public abstract boolean isJavaFrontend();
}

