/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.lang.reflect.Type;
import javaemul.internal.Constructor;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsMethod;

public final class Class<T>
implements Type,
Serializable {
    private final Constructor ctor;
    private final int dimensionCount;

    @JsMethod
    public static native Class<?> $get(Constructor var0, int var1);

    @JsMethod
    public static native Class<?> $get(Constructor var0);

    @JsConstructor
    private Class(Constructor ctor, int dimensionCount) {
        this.ctor = ctor;
        this.dimensionCount = dimensionCount;
    }

    public String getName() {
        if (this.isArray()) {
            String className = this.ctor.isPrimitive() ? this.ctor.getPrimitiveShortName() : "L" + this.ctor.getClassName() + ";";
            return Class.repeatString("[", this.dimensionCount) + className;
        }
        return this.ctor.getClassName();
    }

    public String getCanonicalName() {
        return this.ctor.getClassName() + Class.repeatString("[]", this.dimensionCount);
    }

    public String getSimpleName() {
        return Class.stripToLastOccurrenceOf(Class.stripToLastOccurrenceOf(this.getCanonicalName(), "."), "$");
    }

    private static String stripToLastOccurrenceOf(String str, String token) {
        return str.substring(str.lastIndexOf(token) + 1);
    }

    public Class<?> getComponentType() {
        return this.isArray() ? Class.$get(this.ctor, this.dimensionCount - 1) : null;
    }

    public boolean isArray() {
        return this.dimensionCount != 0;
    }

    public boolean isEnum() {
        return !this.isArray() && this.ctor.isEnum();
    }

    public boolean isInterface() {
        return !this.isArray() && this.ctor.isInterface();
    }

    public boolean isPrimitive() {
        return !this.isArray() && this.ctor.isPrimitive();
    }

    public T[] getEnumConstants() {
        throw new UnsupportedOperationException();
    }

    public Class<? super T> getSuperclass() {
        Constructor superCtor = this.ctor.getSuperConstructor();
        return superCtor == null ? null : Class.$get(superCtor, 0);
    }

    public boolean desiredAssertionStatus() {
        return false;
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    private static String repeatString(String str, int count) {
        String rv = "";
        for (int i = 0; i < count; ++i) {
            rv = rv + str;
        }
        return rv;
    }

    public Class<?> $getBoxedClass() {
        return this.isPrimitive() ? Class.$get(this.ctor.getBoxedConstructor()) : this;
    }

    public Class<?> $getPrimitiveClass() {
        if (this.isArray()) {
            return null;
        }
        if (this.isPrimitive()) {
            return this;
        }
        Constructor primitiveCtor = this.ctor.getPrimitiveConstructor();
        if (primitiveCtor == null) {
            return null;
        }
        return Class.$get(primitiveCtor);
    }
}

