/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.JsUtils;
import javaemul.internal.LongUtils;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

final class IntegralToString {
    IntegralToString() {
    }

    public static String intToBinaryString(int value) {
        return IntegralToString.intToUnsignedString(value, 2);
    }

    public static String intToHexString(int value) {
        return IntegralToString.intToUnsignedString(value, 16);
    }

    public static String intToOctalString(int value) {
        return IntegralToString.intToUnsignedString(value, 8);
    }

    private static String intToUnsignedString(int value, int radix) {
        return IntegralToString.numberToString(IntegralToString.toDoubleFromUnsignedInt(value), radix);
    }

    public static String intToString(int value) {
        return "" + value;
    }

    public static String intToString(int value, int radix) {
        return IntegralToString.numberToString(value, radix);
    }

    @JsMethod
    private static native double toDoubleFromUnsignedInt(int var0);

    private static String numberToString(double value, int radix) {
        NativeNumber number = (NativeNumber)JsUtils.uncheckedCast(value);
        return number.toString(radix);
    }

    public static String longToBinaryString(long value) {
        return IntegralToString.toPowerOfTwoUnsignedString(value, 1);
    }

    public static String longToHexString(long value) {
        return IntegralToString.toPowerOfTwoUnsignedString(value, 4);
    }

    public static String longToOctalString(long value) {
        return IntegralToString.toPowerOfTwoUnsignedString(value, 3);
    }

    private static String toPowerOfTwoUnsignedString(long value, int shift) {
        int radix = 1 << shift;
        int highBits = LongUtils.getHighBits(value);
        if (highBits == 0) {
            return IntegralToString.intToUnsignedString(LongUtils.getLowBits(value), radix);
        }
        int mask = radix - 1;
        int bufSize = 64 / shift + 1;
        char[] buf = new char[bufSize];
        int pos = bufSize;
        do {
            buf[--pos] = Character.forDigit((int)value & mask);
        } while ((value >>>= shift) != 0L);
        return String.valueOf(buf, pos, bufSize - pos);
    }

    public static String longToString(long value) {
        return "" + value;
    }

    public static String longToString(long value, int intRadix) {
        return LongUtils.toString(value, intRadix);
    }

    @JsType(isNative=true, name="Number", namespace="<global>")
    private static interface NativeNumber {
        public String toString(int var1);
    }
}

