/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.Division;
import java.math.Elementary;
import java.util.Arrays;
import java.util.Random;

class Primality {
    private static final int[] BITS = new int[]{0, 0, 1854, 1233, 927, 747, 627, 543, 480, 431, 393, 361, 335, 314, 295, 279, 265, 253, 242, 232, 223, 216, 181, 169, 158, 150, 145, 140, 136, 132, 127, 123, 119, 114, 110, 105, 101, 96, 92, 87, 83, 78, 73, 69, 64, 59, 54, 49, 44, 38, 32, 26, 1};
    private static final int[][] offsetPrimes = new int[][]{null, null, {0, 2}, {2, 2}, {4, 2}, {6, 5}, {11, 7}, {18, 13}, {31, 23}, {54, 43}, {97, 75}};
    private static final int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021};
    private static final BigInteger[] BIprimes = new BigInteger[primes.length];

    static BigInteger consBigInteger(int bitLength, int certainty, Random rnd) {
        if (bitLength <= 10) {
            int[] rp = offsetPrimes[bitLength];
            return BIprimes[rp[0] + rnd.nextInt(rp[1])];
        }
        int shiftCount = -bitLength & 0x1F;
        int last = bitLength + 31 >> 5;
        BigInteger n = new BigInteger(1, last, new int[last]);
        --last;
        do {
            for (int i = 0; i < n.numberLength; ++i) {
                n.digits[i] = rnd.nextInt();
            }
            int n2 = last;
            n.digits[n2] = n.digits[n2] | Integer.MIN_VALUE;
            int n3 = last;
            n.digits[n3] = n.digits[n3] >>> shiftCount;
            n.digits[0] = n.digits[0] | 1;
        } while (!Primality.isProbablePrime(n, certainty));
        return n;
    }

    static boolean isProbablePrime(BigInteger n, int certainty) {
        int i;
        if (certainty <= 0 || n.numberLength == 1 && n.digits[0] == 2) {
            return true;
        }
        if (!n.testBit(0)) {
            return false;
        }
        if (n.numberLength == 1 && (n.digits[0] & 0xFFFFFC00) == 0) {
            return Arrays.binarySearch(primes, n.digits[0]) >= 0;
        }
        for (i = 1; i < primes.length; ++i) {
            if (Division.remainderArrayByInt(n.digits, n.numberLength, primes[i]) != 0) continue;
            return false;
        }
        int bitLength = n.bitLength();
        i = 2;
        while (bitLength < BITS[i]) {
            ++i;
        }
        certainty = Math.min(i, 1 + (certainty - 1 >> 1));
        return Primality.millerRabin(n, certainty);
    }

    static BigInteger nextProbablePrime(BigInteger n) {
        int i;
        int gapSize = 1024;
        int[] modules = new int[primes.length];
        boolean[] isDivisible = new boolean[gapSize];
        if (n.numberLength == 1 && n.digits[0] >= 0 && n.digits[0] < primes[primes.length - 1]) {
            int i2 = 0;
            while (n.digits[0] >= primes[i2]) {
                ++i2;
            }
            return BIprimes[i2];
        }
        BigInteger startPoint = new BigInteger(1, n.numberLength, new int[n.numberLength + 1]);
        System.arraycopy(n.digits, 0, startPoint.digits, 0, n.numberLength);
        if (n.testBit(0)) {
            Elementary.inplaceAdd(startPoint, 2);
        } else {
            startPoint.digits[0] = startPoint.digits[0] | 1;
        }
        int j = startPoint.bitLength();
        int certainty = 2;
        while (j < BITS[certainty]) {
            ++certainty;
        }
        for (i = 0; i < primes.length; ++i) {
            modules[i] = Division.remainder(startPoint, primes[i]) - gapSize;
        }
        while (true) {
            Arrays.fill(isDivisible, false);
            for (i = 0; i < primes.length; ++i) {
                modules[i] = (modules[i] + gapSize) % primes[i];
                int n2 = j = modules[i] == 0 ? 0 : primes[i] - modules[i];
                while (j < gapSize) {
                    isDivisible[j] = true;
                    j += primes[i];
                }
            }
            for (j = 0; j < gapSize; ++j) {
                if (isDivisible[j]) continue;
                BigInteger probPrime = startPoint.copy();
                Elementary.inplaceAdd(probPrime, j);
                if (!Primality.millerRabin(probPrime, certainty)) continue;
                return probPrime;
            }
            Elementary.inplaceAdd(startPoint, gapSize);
        }
    }

    private static boolean millerRabin(BigInteger n, int t) {
        BigInteger nMinus1 = n.subtract(BigInteger.ONE);
        int bitLength = nMinus1.bitLength();
        int k = nMinus1.getLowestSetBit();
        BigInteger q = nMinus1.shiftRight(k);
        Random rnd = new Random();
        for (int i = 0; i < t; ++i) {
            BigInteger x;
            if (i < primes.length) {
                x = BIprimes[i];
            } else {
                while ((x = new BigInteger(bitLength, rnd)).compareTo(n) >= 0 || x.sign == 0 || x.isOne()) {
                }
            }
            BigInteger y = x.modPow(q, n);
            if (y.isOne() || y.equals(nMinus1)) continue;
            for (int j = 1; j < k; ++j) {
                if (y.equals(nMinus1) || !(y = y.multiply(y).mod(n)).isOne()) continue;
                return false;
            }
            if (y.equals(nMinus1)) continue;
            return false;
        }
        return true;
    }

    private Primality() {
    }

    static {
        for (int i = 0; i < primes.length; ++i) {
            Primality.BIprimes[i] = BigInteger.valueOf(primes[i]);
        }
    }
}

