/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringJoiner;
import javaemul.internal.InternalPreconditions;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        InternalPreconditions.checkNotNull(c);
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.advanceToFind(o, false);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        InternalPreconditions.checkNotNull(c);
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object o) {
        return this.advanceToFind(o, true);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        InternalPreconditions.checkNotNull(c);
        boolean changed = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!c.contains(o)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        InternalPreconditions.checkNotNull(c);
        boolean changed = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        return Collection.super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Collection.super.toArray(a);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (Object e : this) {
            joiner.add(e == this ? "(this Collection)" : String.valueOf(e));
        }
        return joiner.toString();
    }

    private boolean advanceToFind(Object o, boolean remove) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!Objects.equals(o, e)) continue;
            if (remove) {
                iter.remove();
            }
            return true;
        }
        return false;
    }
}

