/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javaemul.internal.InternalPreconditions;

public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private boolean accessOrder;
    private final ChainEntry head = new ChainEntry();
    private final HashMap<K, ChainEntry> map = new HashMap();

    public LinkedHashMap() {
        this.resetChainEntries();
    }

    public LinkedHashMap(int ignored) {
        this(ignored, 0.0f);
    }

    public LinkedHashMap(int ignored, float alsoIgnored) {
        super(ignored, alsoIgnored);
        this.resetChainEntries();
    }

    public LinkedHashMap(int ignored, float alsoIgnored, boolean accessOrder) {
        super(ignored, alsoIgnored);
        this.accessOrder = accessOrder;
        this.resetChainEntries();
    }

    public LinkedHashMap(Map<? extends K, ? extends V> toBeCopied) {
        this.resetChainEntries();
        this.putAll(toBeCopied);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.resetChainEntries();
    }

    private void resetChainEntries() {
        this.head.prev = this.head;
        this.head.next = this.head;
    }

    @Override
    public Object clone() {
        return new LinkedHashMap<K, V>(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ChainEntry node = this.head.next;
        while (node != this.head) {
            if (Objects.equals(node.getValue(), value)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object key) {
        ChainEntry entry = (ChainEntry)this.map.get(key);
        if (entry != null) {
            this.recordAccess(entry);
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        ChainEntry old = (ChainEntry)this.map.get(key);
        if (old == null) {
            ChainEntry newEntry = new ChainEntry(key, value);
            this.map.put(key, (Object)newEntry);
            newEntry.addToEnd();
            ChainEntry eldest = this.head.next;
            if (this.removeEldestEntry(eldest)) {
                eldest.remove();
                this.map.remove(eldest.getKey());
            }
            return null;
        }
        Object oldValue = old.setValue((Object)value);
        this.recordAccess(old);
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        ChainEntry entry = (ChainEntry)this.map.remove(key);
        if (entry != null) {
            entry.remove();
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    private void recordAccess(ChainEntry entry) {
        if (this.accessOrder) {
            entry.remove();
            entry.addToEnd();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                return LinkedHashMap.this.containsEntry((Map.Entry)o);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object entry) {
            if (this.contains(entry)) {
                Object key = ((Map.Entry)entry).getKey();
                LinkedHashMap.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size();
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private ChainEntry last;
            private ChainEntry next;
            private int lastModCount;

            public EntryIterator() {
                this.next = LinkedHashMap.this.head.next;
                this.lastModCount = LinkedHashMap.this.map.modCount;
            }

            @Override
            public boolean hasNext() {
                return this.next != LinkedHashMap.this.head;
            }

            @Override
            public Map.Entry<K, V> next() {
                InternalPreconditions.checkConcurrentModification(LinkedHashMap.this.map.modCount, this.lastModCount);
                InternalPreconditions.checkCriticalElement(this.hasNext());
                this.last = this.next;
                this.next = this.next.next;
                return this.last;
            }

            @Override
            public void remove() {
                InternalPreconditions.checkState(this.last != null);
                InternalPreconditions.checkConcurrentModification(LinkedHashMap.this.map.modCount, this.lastModCount);
                this.last.remove();
                LinkedHashMap.this.map.remove(this.last.getKey());
                this.lastModCount = LinkedHashMap.this.map.modCount;
                this.last = null;
            }
        }
    }

    private class ChainEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private ChainEntry next;
        private ChainEntry prev;

        public ChainEntry() {
            this(null, null);
        }

        public ChainEntry(K key, V value) {
            super(key, value);
        }

        public void addToEnd() {
            ChainEntry tail = LinkedHashMap.this.head.prev;
            assert (LinkedHashMap.this.head != null && tail != null);
            assert (this.next == null && this.prev == null);
            this.prev = tail;
            this.next = LinkedHashMap.this.head;
            tail.next = LinkedHashMap.this.head.prev = this;
        }

        public void remove() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
        }
    }
}

