/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public final class StringJoiner {
    private final String delimiter;
    private final String prefix;
    private final String suffix;
    private StringBuilder builder;
    private String emptyValue;

    public StringJoiner(CharSequence delimiter) {
        this(delimiter, "", "");
    }

    public StringJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this.delimiter = delimiter.toString();
        this.prefix = prefix.toString();
        this.suffix = suffix.toString();
        this.emptyValue = this.prefix + this.suffix;
    }

    public StringJoiner add(CharSequence newElement) {
        this.initBuilderOrAddDelimiter();
        this.builder.append(newElement);
        return this;
    }

    public int length() {
        if (this.builder == null) {
            return this.emptyValue.length();
        }
        return this.builder.length() + this.suffix.length();
    }

    public StringJoiner merge(StringJoiner other) {
        if (other.builder != null) {
            int otherLength = other.builder.length();
            this.initBuilderOrAddDelimiter();
            this.builder.append(other.builder, other.prefix.length(), otherLength);
        }
        return this;
    }

    public StringJoiner setEmptyValue(CharSequence emptyValue) {
        this.emptyValue = emptyValue.toString();
        return this;
    }

    public String toString() {
        if (this.builder == null) {
            return this.emptyValue;
        }
        if (this.suffix.isEmpty()) {
            return this.builder.toString();
        }
        return this.builder.toString() + this.suffix;
    }

    private void initBuilderOrAddDelimiter() {
        if (this.builder == null) {
            this.builder = new StringBuilder(this.prefix);
        } else {
            this.builder.append(this.delimiter);
        }
    }
}

