/*
 * Decompiled with CFR 0.152.
 */
package java.util.function;

import java.util.Objects;
import javaemul.internal.InternalPreconditions;

@FunctionalInterface
public interface Predicate<T> {
    public static <T> Predicate<T> isEqual(Object targetRef) {
        return targetRef == null ? Objects::isNull : targetRef::equals;
    }

    public boolean test(T var1);

    default public Predicate<T> negate() {
        return t -> !this.test(t);
    }

    default public Predicate<T> and(Predicate<? super T> other) {
        InternalPreconditions.checkCriticalNotNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public Predicate<T> or(Predicate<? super T> other) {
        InternalPreconditions.checkCriticalNotNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> Predicate<T> not(Predicate<? super T> other) {
        return other.negate();
    }
}

