/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import java.util.Comparator;
import javaemul.internal.ArrayStamper;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.JsUtils;
import javaemul.internal.MergeSorter;
import javaemul.internal.annotations.DoNotAutobox;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

public final class ArrayHelper {
    public static final int ARRAY_PROCESS_BATCH_SIZE = 10000;

    public static <T> T clone(T array) {
        Object[] result = ArrayHelper.asNativeArray(array).slice();
        return (T)ArrayStamper.stampJavaTypeInfo(result, array);
    }

    public static <T> T clone(T array, int fromIndex, int toIndex) {
        int requestedLength = toIndex - fromIndex;
        Object[] result = ArrayHelper.unsafeClone(array, fromIndex, toIndex);
        int length = result.length;
        if (requestedLength > length) {
            Object initialValue = ArrayHelper.getElementInitialValue(array);
            if (initialValue == null) {
                ArrayHelper.setLength(result, requestedLength);
            } else {
                for (int i = length; i < requestedLength; ++i) {
                    result[i] = initialValue;
                }
            }
        }
        return (T)ArrayStamper.stampJavaTypeInfo(result, array);
    }

    public static Object[] unsafeClone(Object array, int fromIndex, int toIndex) {
        return ArrayHelper.asNativeArray(array).slice(fromIndex, toIndex);
    }

    public static <T> T[] createFrom(T[] array, int length) {
        return ArrayStamper.stampJavaTypeInfo(new NativeArray(length), array);
    }

    @JsMethod(name="Array.isArray", namespace="<global>")
    public static native boolean isArray(Object var0);

    public static int getLength(Object array) {
        return ArrayHelper.asNativeArray((Object)array).length;
    }

    public static <T> T setLength(T array, int length) {
        ArrayHelper.asNativeArray(array).length = length;
        return array;
    }

    public static <T> T grow(T array, int length) {
        return ArrayHelper.setLength(array, length);
    }

    public static void push(Object[] array, Object o) {
        ArrayHelper.asNativeArray(array).push(o);
    }

    public static void fill(Object array, @DoNotAutobox Object value, int fromIndex, int toIndex) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, ArrayHelper.getLength(array));
        ArrayHelper.asNativeArray(array).fill(value, fromIndex, toIndex);
    }

    public static void fill(Object array, @DoNotAutobox Object value) {
        ArrayHelper.asNativeArray(array).fill(value);
    }

    public static void removeFrom(Object[] array, int index, int deleteCount) {
        ArrayHelper.asNativeArray(array).splice(index, deleteCount, new Object[0]);
    }

    public static void insertTo(Object[] array, int index, Object value) {
        ArrayHelper.asNativeArray(array).splice(index, 0, value);
    }

    public static void copy(Object array, int srcOfs, Object dest, int destOfs, int len) {
        ArrayHelper.copy((Object[])JsUtils.uncheckedCast(array), srcOfs, (Object[])JsUtils.uncheckedCast(dest), destOfs, len);
    }

    private static void copy(Object[] src, int srcOfs, Object[] dest, int destOfs, int len) {
        InternalPreconditions.checkCriticalArrayCopyIndices(src, srcOfs, dest, destOfs, len);
        if (len == 0) {
            return;
        }
        if (src == dest && srcOfs < destOfs) {
            srcOfs += len;
            int destEnd = destOfs + len;
            while (destEnd > destOfs) {
                dest[--destEnd] = src[--srcOfs];
            }
        } else {
            int destEnd = destOfs + len;
            while (destOfs < destEnd) {
                dest[destOfs++] = src[srcOfs++];
            }
        }
    }

    public static <T> T concat(T a, T b) {
        T result = ArrayHelper.clone(a);
        ArrayHelper.setLength(result, ArrayHelper.getLength(a) + ArrayHelper.getLength(b));
        ArrayHelper.copy(b, 0, result, ArrayHelper.getLength(a), ArrayHelper.getLength(b));
        return result;
    }

    public static boolean equals(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Double.valueOf(array1[i]).equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] array1, float[] array2) {
        return ArrayHelper.equals((double[])JsUtils.uncheckedCast(array1), (double[])JsUtils.uncheckedCast(array2));
    }

    public static int binarySearch(double[] sortedArray, int fromIndex, int toIndex, double key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + (high - low >> 1);
            double midVal = sortedArray[mid];
            int cmp = Double.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public static int binarySearch(float[] sortedArray, int fromIndex, int toIndex, float key) {
        return ArrayHelper.binarySearch((double[])JsUtils.uncheckedCast(sortedArray), fromIndex, toIndex, (double)key);
    }

    public static void sortPrimitive(float[] array) {
        ArrayHelper.sortPrimitive(array, ArrayHelper.getDoubleComparator());
    }

    public static void sortPrimitive(double[] array) {
        ArrayHelper.sortPrimitive(array, ArrayHelper.getDoubleComparator());
    }

    public static void sortPrimitive(long[] array) {
        ArrayHelper.sortPrimitive(array, ArrayHelper.getLongComparator());
    }

    public static void sortPrimitive(Object array) {
        ArrayHelper.sortPrimitive(array, ArrayHelper.getIntComparator());
    }

    public static void sortPrimitive(float[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex, ArrayHelper.getDoubleComparator());
    }

    public static void sortPrimitive(double[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex, ArrayHelper.getDoubleComparator());
    }

    public static void sortPrimitive(long[] array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex, ArrayHelper.getLongComparator());
    }

    public static void sortPrimitive(Object array, int fromIndex, int toIndex) {
        ArrayHelper.sortPrimitive(array, fromIndex, toIndex, ArrayHelper.getIntComparator());
    }

    private static void sortPrimitive(Object array, CompareFunction fn) {
        ArrayHelper.asNativeArray(array).sort(fn);
    }

    private static void sortPrimitive(Object array, int fromIndex, int toIndex, CompareFunction fn) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, ArrayHelper.getLength(array));
        Object[] temp = ArrayHelper.unsafeClone(array, fromIndex, toIndex);
        ArrayHelper.sortPrimitive(temp, fn);
        ArrayHelper.copy((Object)temp, 0, array, fromIndex, toIndex - fromIndex);
    }

    public static <T> void sort(T[] array, Comparator<? super T> c) {
        MergeSorter.sort(array, 0, array.length, c);
    }

    public static <T> void sort(T[] array, int fromIndex, int toIndex, Comparator<? super T> c) {
        InternalPreconditions.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        MergeSorter.sort(array, fromIndex, toIndex, c);
    }

    private static CompareFunction getIntComparator() {
        return (CompareFunction)JsUtils.uncheckedCast((a, b) -> a - b);
    }

    private static CompareFunction getDoubleComparator() {
        return (CompareFunction)JsUtils.uncheckedCast(Double::compare);
    }

    private static CompareFunction getLongComparator() {
        return (CompareFunction)JsUtils.uncheckedCast(Long::compare);
    }

    private static NativeArray asNativeArray(Object array) {
        return (NativeArray)JsUtils.uncheckedCast(array);
    }

    @JsMethod(namespace="vmbootstrap.Arrays", name="$getElementInitialValue")
    private static native Object getElementInitialValue(Object var0);

    private ArrayHelper() {
    }

    @JsType(isNative=true, name="Array", namespace="<global>")
    private static class NativeArray {
        int length;

        NativeArray(int length) {
        }

        native void push(Object var1);

        native Object[] slice();

        native Object[] slice(int var1, int var2);

        native void fill(Object var1);

        native void fill(Object var1, int var2, int var3);

        native void splice(int var1, int var2, Object ... var3);

        native <T> void sort(CompareFunction var1);
    }

    @JsFunction
    private static interface CompareLongFunction {
        public int compare(long var1, long var3);
    }

    @JsFunction
    private static interface CompareDoubleFunction {
        public double compare(double var1, double var3);
    }

    @JsFunction
    private static interface CompareFunction {
        public double compare(Object var1, Object var2);
    }
}

