/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.JsUtils;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

public class ConsoleLogger {
    public static ConsoleLogger createIfSupported() {
        return JsUtils.typeOf(ConsoleLogger.getConsole()).equals("undefined") ? null : new ConsoleLogger();
    }

    public void log(String level, String message) {
        LogFn logFn = (LogFn)JsUtils.getProperty(ConsoleLogger.getConsole(), level);
        logFn.call(ConsoleLogger.getConsole(), message);
    }

    public void log(String level, Throwable t) {
        this.log(level, t, "Exception: ", true);
    }

    private void log(String level, Throwable t, String label, boolean expanded) {
        this.groupStart(label + t.toString(), expanded);
        this.log(level, ConsoleLogger.getBackingErrorStack(t));
        Throwable cause = t.getCause();
        if (cause != null) {
            this.log(level, cause, "Caused by: ", false);
        }
        for (Throwable suppressed : t.getSuppressed()) {
            this.log(level, suppressed, "Suppressed: ", false);
        }
        this.groupEnd();
    }

    private void groupStart(String msg, boolean expanded) {
        this.getGroupStartFn(expanded).call(ConsoleLogger.getConsole(), msg);
    }

    private LogFn getGroupStartFn(boolean expanded) {
        if (!expanded && Console.groupCollapsed != null) {
            return Console.groupCollapsed;
        }
        if (Console.group != null) {
            return Console.group;
        }
        return Console.log;
    }

    private void groupEnd() {
        if (Console.groupEnd != null) {
            Console.groupEnd.call(ConsoleLogger.getConsole(), new Object[0]);
        }
    }

    @JsMethod
    private static native String getBackingErrorStack(Throwable var0);

    @JsProperty(namespace="<global>", name="console")
    private static native Object getConsole();

    @JsType(isNative=true, namespace="<global>", name="console")
    private static class Console {
        public static LogFn log;
        public static LogFn group;
        public static LogFn groupCollapsed;
        public static LogFn groupEnd;

        private Console() {
        }
    }

    @JsType(isNative=true, namespace="<global>", name="Function")
    private static interface LogFn {
        public void call(Object var1, Object ... var2);
    }
}

