/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    private static final int MAX_SKIP_BUFFER_SIZE = 1024;

    public abstract void close() throws IOException;

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        char[] chr = new char[1];
        return this.read(chr) == -1 ? -1 : chr[0];
    }

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public boolean ready() throws IOException {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("Not supported");
    }

    public long skip(long n) throws IOException {
        long remaining;
        long numRead;
        int bufferSize = Math.min((int)n, 1024);
        char[] skipBuffer = new char[bufferSize];
        for (remaining = n; remaining > 0L && (numRead = (long)this.read(skipBuffer, 0, (int)remaining)) >= 0L; remaining -= numRead) {
        }
        return n - remaining;
    }
}

