/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import javaemul.internal.InternalPreconditions;

abstract class AbstractStringBuilder
implements CharSequence,
Appendable {
    String string;

    AbstractStringBuilder(String string) {
        this.string = string;
    }

    @Override
    public int length() {
        return this.string.length();
    }

    public void setLength(int newLength) {
        int oldLength = this.length();
        if (newLength < oldLength) {
            this.string = this.string.substring(0, newLength);
        } else if (newLength > oldLength) {
            this.string = this.string + String.valueOf(new char[newLength - oldLength]);
        }
    }

    public int capacity() {
        return Integer.MAX_VALUE;
    }

    public void ensureCapacity(int ignoredCapacity) {
    }

    public void trimToSize() {
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(index);
    }

    public void getChars(int srcStart, int srcEnd, char[] dst, int dstStart) {
        this.string.getChars(srcStart, srcEnd, dst, dstStart);
    }

    public void setCharAt(int index, char x) {
        this.replace0(index, index + 1, String.valueOf(x));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.string.substring(start, end);
    }

    public String substring(int begin) {
        return this.string.substring(begin);
    }

    public String substring(int begin, int end) {
        return this.string.substring(begin, end);
    }

    public int indexOf(String x) {
        return this.string.indexOf(x);
    }

    public int indexOf(String x, int start) {
        return this.string.indexOf(x, start);
    }

    public int lastIndexOf(String s) {
        return this.string.lastIndexOf(s);
    }

    public int lastIndexOf(String s, int start) {
        return this.string.lastIndexOf(s, start);
    }

    @Override
    public String toString() {
        return this.string;
    }

    void append0(char[] x, int start, int len) {
        this.string = this.string + String.valueOf(x, start, len);
    }

    void append0(String x) {
        this.string = this.string + x;
    }

    void appendCodePoint0(int x) {
        this.string = this.string + String.fromCodePoint(x);
    }

    void replace0(int start, int end, String toInsert) {
        int length = this.string.length();
        if (end > length) {
            end = length;
        } else {
            InternalPreconditions.checkStringElementIndex(start, end + 1);
        }
        this.string = this.string.substring(0, start) + toInsert + this.string.substring(end);
    }

    void reverse0() {
        int length = this.string.length();
        if (length <= 1) {
            return;
        }
        char[] buffer = new char[length];
        buffer[0] = this.string.charAt(length - 1);
        for (int i = 1; i < length; ++i) {
            buffer[i] = this.string.charAt(length - 1 - i);
            if (!Character.isSurrogatePair(buffer[i], buffer[i - 1])) continue;
            AbstractStringBuilder.swap(buffer, i - 1, i);
        }
        this.string = new String(buffer);
    }

    private static void swap(char[] buffer, int f, int s) {
        char tmp = buffer[f];
        buffer[f] = buffer[s];
        buffer[s] = tmp;
    }
}

