/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import javaemul.internal.EmulatedCharset;
import javaemul.internal.InternalPreconditions;

public abstract class Charset
implements Comparable<Charset> {
    private final String name;

    public static SortedMap<String, Charset> availableCharsets() {
        return AvailableCharsets.CHARSETS;
    }

    public static Charset defaultCharset() {
        return EmulatedCharset.UTF_8;
    }

    public static Charset forName(String charsetName) {
        InternalPreconditions.checkArgument(charsetName != null, "Null charset name");
        charsetName = charsetName.toUpperCase();
        if (EmulatedCharset.ISO_8859_1.name().equals(charsetName)) {
            return EmulatedCharset.ISO_8859_1;
        }
        if (EmulatedCharset.ISO_LATIN_1.name().equals(charsetName)) {
            return EmulatedCharset.ISO_LATIN_1;
        }
        if (EmulatedCharset.UTF_8.name().equals(charsetName)) {
            return EmulatedCharset.UTF_8;
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    protected Charset(String name, String[] aliasesIgnored) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public final int compareTo(Charset that) {
        return this.name.compareToIgnoreCase(that.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Charset)) {
            return false;
        }
        Charset that = (Charset)o;
        return this.name.equals(that.name);
    }

    public final String toString() {
        return this.name;
    }

    private static final class AvailableCharsets {
        private static final SortedMap<String, Charset> CHARSETS;

        private AvailableCharsets() {
        }

        static {
            TreeMap<String, EmulatedCharset> map = new TreeMap<String, EmulatedCharset>();
            map.put(EmulatedCharset.ISO_8859_1.name(), EmulatedCharset.ISO_8859_1);
            map.put(EmulatedCharset.ISO_LATIN_1.name(), EmulatedCharset.ISO_LATIN_1);
            map.put(EmulatedCharset.UTF_8.name(), EmulatedCharset.UTF_8);
            CHARSETS = Collections.unmodifiableSortedMap(map);
        }
    }
}

