/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import javaemul.internal.InternalPreconditions;

public interface PrimitiveIterator<T, C>
extends Iterator<T> {
    public void forEachRemaining(C var1);

    public static interface OfLong
    extends PrimitiveIterator<Long, LongConsumer> {
        public long nextLong();

        @Override
        default public Long next() {
            return this.nextLong();
        }

        @Override
        default public void forEachRemaining(LongConsumer consumer) {
            InternalPreconditions.checkNotNull(consumer);
            while (this.hasNext()) {
                consumer.accept(this.nextLong());
            }
        }

        @Override
        default public void forEachRemaining(Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                this.forEachRemaining((LongConsumer)((Object)consumer));
            } else {
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfInt
    extends PrimitiveIterator<Integer, IntConsumer> {
        public int nextInt();

        @Override
        default public Integer next() {
            return this.nextInt();
        }

        @Override
        default public void forEachRemaining(IntConsumer consumer) {
            InternalPreconditions.checkNotNull(consumer);
            while (this.hasNext()) {
                consumer.accept(this.nextInt());
            }
        }

        @Override
        default public void forEachRemaining(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this.forEachRemaining((IntConsumer)((Object)consumer));
            } else {
                this.forEachRemaining(consumer::accept);
            }
        }
    }

    public static interface OfDouble
    extends PrimitiveIterator<Double, DoubleConsumer> {
        public double nextDouble();

        @Override
        default public Double next() {
            return this.nextDouble();
        }

        @Override
        default public void forEachRemaining(DoubleConsumer consumer) {
            InternalPreconditions.checkNotNull(consumer);
            while (this.hasNext()) {
                consumer.accept(this.nextDouble());
            }
        }

        @Override
        default public void forEachRemaining(Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                this.forEachRemaining((DoubleConsumer)((Object)consumer));
            } else {
                this.forEachRemaining(consumer::accept);
            }
        }
    }
}

