/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import javaemul.internal.InternalPreconditions;

public class TreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Serializable {
    private NavigableMap<E, Boolean> map;

    public TreeSet() {
        this.map = new TreeMap<E, Boolean>();
    }

    public TreeSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public TreeSet(Comparator<? super E> c) {
        this.map = new TreeMap<E, Boolean>(c);
    }

    public TreeSet(SortedSet<E> s) {
        this(InternalPreconditions.checkNotNull(s).comparator());
        this.addAll(s);
    }

    private TreeSet(NavigableMap<E, Boolean> map) {
        this.map = map;
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, Boolean.FALSE) == null;
    }

    @Override
    public E ceiling(E e) {
        return this.map.ceilingKey(e);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.map.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new TreeSet<E>(this.map.descendingMap());
    }

    @Override
    public E first() {
        return (E)this.map.firstKey();
    }

    @Override
    public E floor(E e) {
        return this.map.floorKey(e);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new TreeSet<E>(this.map.headMap(toElement, inclusive));
    }

    @Override
    public E higher(E e) {
        return this.map.higherKey(e);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public E last() {
        return (E)this.map.lastKey();
    }

    @Override
    public E lower(E e) {
        return this.map.lowerKey(e);
    }

    @Override
    public E pollFirst() {
        return AbstractMap.getEntryKeyOrNull(this.map.pollFirstEntry());
    }

    @Override
    public E pollLast() {
        return AbstractMap.getEntryKeyOrNull(this.map.pollLastEntry());
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new TreeSet<E>(this.map.subMap(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new TreeSet<E>(this.map.tailMap(fromElement, inclusive));
    }
}

