/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.Arrays;

public class AtomicReferenceArray<V> {
    private final V[] values;

    public AtomicReferenceArray(V[] array) {
        this.values = Arrays.copyOf(array, array.length);
    }

    public AtomicReferenceArray(int length) {
        this.values = new Object[length];
    }

    public boolean compareAndSet(int i, V expect, V update) {
        if (this.values[i] == expect) {
            this.values[i] = update;
            return true;
        }
        return false;
    }

    public V get(int i) {
        return this.values[i];
    }

    public V getAndSet(int i, V x) {
        V previous = this.values[i];
        this.values[i] = x;
        return previous;
    }

    public void lazySet(int i, V x) {
        this.values[i] = x;
    }

    public int length() {
        return this.values.length;
    }

    public void set(int i, V x) {
        this.values[i] = x;
    }

    public boolean weakCompareAndSet(int i, V expect, V update) {
        return this.compareAndSet(i, expect, update);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

