/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.DoubleStreamImpl;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.LongStreamImpl;
import java.util.stream.Stream;
import java.util.stream.StreamImpl;
import java.util.stream.TerminatableStream;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.PrimitiveLists;

final class IntStreamImpl
extends TerminatableStream<IntStreamImpl>
implements IntStream {
    private final Spliterator.OfInt spliterator;

    public IntStreamImpl(TerminatableStream<?> previous, Spliterator.OfInt spliterator) {
        super(previous);
        this.spliterator = spliterator;
    }

    @Override
    public Spliterator.OfInt spliterator() {
        this.terminate();
        return this.spliterator;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public OptionalInt findFirst() {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return OptionalInt.of(holder.value);
        }
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt findAny() {
        return this.findFirst();
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return !this.anyMatch(predicate.negate());
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.filter(predicate).findFirst().isPresent();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.collect(IntSummaryStatistics::new, (intSummaryStatistics, value) -> intSummaryStatistics.accept(value), IntSummaryStatistics::combine);
    }

    @Override
    public OptionalDouble average() {
        IntSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(stats.getAverage());
    }

    @Override
    public long count() {
        this.terminate();
        long count = 0L;
        while (this.spliterator.tryAdvance(value -> {})) {
            ++count;
        }
        return count;
    }

    @Override
    public OptionalInt max() {
        IntSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(stats.getMax());
    }

    @Override
    public OptionalInt min() {
        IntSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(stats.getMin());
    }

    @Override
    public int sum() {
        return (int)this.summaryStatistics().getSum();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        this.terminate();
        Object acc = supplier.get();
        this.spliterator.forEachRemaining(value -> accumulator.accept(acc, value));
        return acc;
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return OptionalInt.of(this.reduce(holder.value, op));
        }
        this.terminate();
        return OptionalInt.empty();
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        holder.value = identity;
        this.spliterator.forEachRemaining(value -> holder.accept(op.applyAsInt(holder.value, value)));
        return holder.value;
    }

    @Override
    public int[] toArray() {
        this.terminate();
        PrimitiveLists.Int entries = PrimitiveLists.createForInt();
        this.spliterator.forEachRemaining(value -> entries.push(value));
        return entries.toArray();
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.terminate();
        this.spliterator.forEachRemaining(action);
    }

    @Override
    public void forEach(IntConsumer action) {
        this.forEachOrdered(action);
    }

    @Override
    public IntStream filter(IntPredicate predicate) {
        this.throwIfTerminated();
        return new IntStreamImpl(this, new FilterSpliterator(predicate, this.spliterator));
    }

    @Override
    public IntStream map(IntUnaryOperator mapper) {
        this.throwIfTerminated();
        return new IntStreamImpl(this, new MapToIntSpliterator(mapper, this.spliterator));
    }

    @Override
    public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
        this.throwIfTerminated();
        return new StreamImpl<U>(this, new MapToObjSpliterator<U>(mapper, this.spliterator));
    }

    @Override
    public LongStream mapToLong(IntToLongFunction mapper) {
        this.throwIfTerminated();
        return new LongStreamImpl(this, new MapToLongSpliterator(mapper, this.spliterator));
    }

    @Override
    public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
        this.throwIfTerminated();
        return new DoubleStreamImpl(this, new MapToDoubleSpliterator(mapper, this.spliterator));
    }

    @Override
    public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? extends IntStream> spliteratorOfStreams = new MapToObjSpliterator<IntStream>(mapper, this.spliterator);
        Spliterators.AbstractIntSpliterator flatMapSpliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 0){
            IntStream nextStream;
            Spliterator.OfInt next;

            @Override
            public boolean tryAdvance(IntConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new IntStreamImpl(this, flatMapSpliterator);
    }

    @Override
    public IntStream distinct() {
        this.throwIfTerminated();
        HashSet seen = new HashSet();
        return this.filter(seen::add);
    }

    @Override
    public IntStream sorted() {
        this.throwIfTerminated();
        Spliterators.AbstractIntSpliterator sortedSpliterator = new Spliterators.AbstractIntSpliterator(this.spliterator.estimateSize(), this.spliterator.characteristics() | 4){
            Spliterator.OfInt ordered;
            {
                this.ordered = null;
            }

            @Override
            public Comparator<? super Integer> getComparator() {
                return null;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (this.ordered == null) {
                    PrimitiveLists.Int list = PrimitiveLists.createForInt();
                    IntStreamImpl.this.spliterator.forEachRemaining(value -> list.push(value));
                    Arrays.sort(list.internalArray(), 0, list.size());
                    this.ordered = Spliterators.spliterator(list.internalArray(), 0, list.size(), this.characteristics());
                }
                return this.ordered.tryAdvance(action);
            }
        };
        return new IntStreamImpl(this, sortedSpliterator);
    }

    @Override
    public IntStream peek(final IntConsumer action) {
        InternalPreconditions.checkNotNull(action);
        this.throwIfTerminated();
        Spliterators.AbstractIntSpliterator peekSpliterator = new Spliterators.AbstractIntSpliterator(this.spliterator.estimateSize(), this.spliterator.characteristics()){

            @Override
            public boolean tryAdvance(IntConsumer innerAction) {
                return IntStreamImpl.this.spliterator.tryAdvance(action.andThen(innerAction));
            }
        };
        return new IntStreamImpl(this, peekSpliterator);
    }

    @Override
    public IntStream limit(long maxSize) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
        return new IntStreamImpl(this, new LimitSpliterator(maxSize, this.spliterator));
    }

    @Override
    public IntStream skip(long n) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(n >= 0L, "n may not be negative");
        if (n == 0L) {
            return this;
        }
        return new IntStreamImpl(this, new SkipSpliterator(n, this.spliterator));
    }

    @Override
    public LongStream asLongStream() {
        return this.mapToLong(i -> i);
    }

    @Override
    public DoubleStream asDoubleStream() {
        return this.mapToDouble(i -> i);
    }

    @Override
    public Stream<Integer> boxed() {
        return this.mapToObj(Integer::valueOf);
    }

    @Override
    public IntStream sequential() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public IntStream parallel() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public boolean isParallel() {
        this.throwIfTerminated();
        return false;
    }

    @Override
    public IntStream unordered() {
        this.throwIfTerminated();
        return this;
    }

    private static final class ValueConsumer
    implements IntConsumer {
        int value;

        private ValueConsumer() {
        }

        @Override
        public void accept(int value) {
            this.value = value;
        }
    }

    private static final class LimitSpliterator
    extends Spliterators.AbstractIntSpliterator {
        private final long limit;
        private final Spliterator.OfInt original;
        private int position = 0;

        public LimitSpliterator(long limit, Spliterator.OfInt original) {
            super(original.hasCharacteristics(64) ? Math.min(original.estimateSize(), limit) : Long.MAX_VALUE, original.characteristics());
            this.limit = limit;
            this.original = original;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if ((long)this.position >= this.limit) {
                return false;
            }
            boolean result = this.original.tryAdvance(action);
            ++this.position;
            return result;
        }
    }

    private static final class SkipSpliterator
    extends Spliterators.AbstractIntSpliterator {
        private long skip;
        private final Spliterator.OfInt original;

        public SkipSpliterator(long skip, Spliterator.OfInt original) {
            super(original.hasCharacteristics(64) ? Math.max(0L, original.estimateSize() - skip) : Long.MAX_VALUE, original.characteristics());
            this.skip = skip;
            this.original = original;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            while (this.skip > 0L) {
                if (!this.original.tryAdvance(ignore -> {})) {
                    return false;
                }
                --this.skip;
            }
            return this.original.tryAdvance(action);
        }
    }

    private static final class FilterSpliterator
    extends Spliterators.AbstractIntSpliterator {
        private final IntPredicate filter;
        private final Spliterator.OfInt original;
        private boolean found;

        public FilterSpliterator(IntPredicate filter, Spliterator.OfInt original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFBFBF);
            InternalPreconditions.checkNotNull(filter);
            this.filter = filter;
            this.original = original;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            this.found = false;
            while (!this.found && this.original.tryAdvance(item -> {
                if (this.filter.test(item)) {
                    this.found = true;
                    action.accept(item);
                }
            })) {
            }
            return this.found;
        }
    }

    private static final class MapToDoubleSpliterator
    extends Spliterators.AbstractDoubleSpliterator {
        private final IntToDoubleFunction map;
        private final Spliterator.OfInt original;

        public MapToDoubleSpliterator(IntToDoubleFunction map, Spliterator.OfInt original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsDouble(u)));
        }
    }

    private static final class MapToLongSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final IntToLongFunction map;
        private final Spliterator.OfInt original;

        public MapToLongSpliterator(IntToLongFunction map, Spliterator.OfInt original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsLong(u)));
        }
    }

    private static final class MapToObjSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final IntFunction<? extends T> map;
        private final Spliterator.OfInt original;

        public MapToObjSpliterator(IntFunction<? extends T> map, Spliterator.OfInt original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.original.tryAdvance(u -> action.accept((T)this.map.apply(u)));
        }
    }

    private static final class MapToIntSpliterator
    extends Spliterators.AbstractIntSpliterator {
        private final IntUnaryOperator map;
        private final Spliterator.OfInt original;

        public MapToIntSpliterator(IntUnaryOperator map, Spliterator.OfInt original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsInt(u)));
        }
    }

    static class Empty
    extends TerminatableStream<Empty>
    implements IntStream {
        public Empty(TerminatableStream<?> previous) {
            super(previous);
        }

        @Override
        public IntStream filter(IntPredicate predicate) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream map(IntUnaryOperator mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public <U> Stream<U> mapToObj(IntFunction<? extends U> mapper) {
            this.throwIfTerminated();
            return new StreamImpl.Empty(this);
        }

        @Override
        public LongStream mapToLong(IntToLongFunction mapper) {
            this.throwIfTerminated();
            return new LongStreamImpl.Empty(this);
        }

        @Override
        public DoubleStream mapToDouble(IntToDoubleFunction mapper) {
            this.throwIfTerminated();
            return new DoubleStreamImpl.Empty(this);
        }

        @Override
        public IntStream flatMap(IntFunction<? extends IntStream> mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream distinct() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream sorted() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream peek(IntConsumer action) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream limit(long maxSize) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
            return this;
        }

        @Override
        public IntStream skip(long n) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(n >= 0L, "n may not be negative");
            return this;
        }

        @Override
        public void forEach(IntConsumer action) {
            this.terminate();
        }

        @Override
        public void forEachOrdered(IntConsumer action) {
            this.terminate();
        }

        @Override
        public int[] toArray() {
            this.terminate();
            return new int[0];
        }

        @Override
        public int reduce(int identity, IntBinaryOperator op) {
            this.terminate();
            return identity;
        }

        @Override
        public OptionalInt reduce(IntBinaryOperator op) {
            this.terminate();
            return OptionalInt.empty();
        }

        @Override
        public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
            this.terminate();
            return supplier.get();
        }

        @Override
        public int sum() {
            this.terminate();
            return 0;
        }

        @Override
        public OptionalInt min() {
            this.terminate();
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt max() {
            this.terminate();
            return OptionalInt.empty();
        }

        @Override
        public long count() {
            this.terminate();
            return 0L;
        }

        @Override
        public OptionalDouble average() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public IntSummaryStatistics summaryStatistics() {
            this.terminate();
            return new IntSummaryStatistics();
        }

        @Override
        public boolean anyMatch(IntPredicate predicate) {
            this.terminate();
            return false;
        }

        @Override
        public boolean allMatch(IntPredicate predicate) {
            this.terminate();
            return true;
        }

        @Override
        public boolean noneMatch(IntPredicate predicate) {
            this.terminate();
            return true;
        }

        @Override
        public OptionalInt findFirst() {
            this.terminate();
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt findAny() {
            this.terminate();
            return OptionalInt.empty();
        }

        @Override
        public LongStream asLongStream() {
            this.throwIfTerminated();
            return new LongStreamImpl.Empty(this);
        }

        @Override
        public DoubleStream asDoubleStream() {
            this.throwIfTerminated();
            return new DoubleStreamImpl.Empty(this);
        }

        @Override
        public Stream<Integer> boxed() {
            this.throwIfTerminated();
            return new StreamImpl.Empty<Integer>(this);
        }

        @Override
        public IntStream sequential() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream parallel() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        @Override
        public Spliterator.OfInt spliterator() {
            this.terminate();
            return Spliterators.emptyIntSpliterator();
        }

        @Override
        public boolean isParallel() {
            this.throwIfTerminated();
            return false;
        }

        @Override
        public IntStream unordered() {
            this.throwIfTerminated();
            return this;
        }
    }
}

